<?php
    if (!defined("__ZBXE__")) exit();

    /**
     * @file hidden_module.addon.php
     * @author mooo (hhyoon@mooo.org)
     * @brief hide module when who has no permission to read accesses
     **/

    if (Context::getResponseMethod() == 'XMLRPC' or Context::get('module') == 'admin') return;

    // before module init
    if ($called_position != 'before_module_init' or $GLOBALS['__hidden_module_addon_called__']) return;
    $GLOBALS['__hidden_module_addon_called__'] = true;

    // object for module model
    $oModuleModel = &getModel('module');

    // check module_info via document_srl when document_srl is set
    $document_srl = Context::get('document_srl');
    if ($document_srl)
        $module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);

    // check module_info via mid when mid is set
    $mid = Context::get('mid');
    if (!$module_info->mid and $mid)
        $module_info = $oModuleModel->getModuleInfoByMid($mid);

    // return if module_info cannot be checked
    if (!$module_info or !$module_info->mid) return;

    // get grant info
    $grant = $oModuleModel->getGrant($module_info, Context::get('logged_info'));

    // modify mid to the default mid when the user has no permission
    if (isset($grant->access) and !$grant->access) {
        $module_info = $oModuleModel->getDefaultMid();

        $this->mid = $module_info->mid;
        $this->document_srl = 0;
        $this->module_srl = 0;
        $this->act = '';
        $this->module = '';
        $this->module_info = null;

        Context::set('mid', $module_info->mid, true);
        Context::set('document_srl', $this->document_srl, true);
        Context::set('module_srl', $this->module_srl, true);
        Context::set('act', $this->act, true);
        Context::set('module', $this->module, true);
        Context::set('module_info', $this->module_info, true);
    }

?>
