<?php

    /**
     * @file hidden_module.addon.php
     * @author mooo (hhyoon@kldp.org)
     * @brief 권한이 없는 사용자에게 특정 모듈을 숨김
     **/

    if (!defined("__ZBXE__")) exit();
    if (Context::getResponseMethod() == 'XMLRPC' || Context::get('module') == 'admin') return;

    // 모듈 객체 생성 이전
    if ($called_position != 'before_module_init' or $GLOBALS['__hidden_module_addon_called__']) return;
    $GLOBALS['__hidden_module_addon_called__'] = true;

    // 모듈 모델
    $oModuleModel = &getModel('module');

    // document_srl이 설정된 경우 이를 통해 모듈 정보를 확인
    $document_srl = Context::get('document_srl');
    $mid = Context::get('mid');
    if ($document_srl)
        $module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);

    if (!$module_info->mid and $mid)
        $module_info = $oModuleModel->getModuleInfoByMid($mid);

    if (!$module_info or !$module_info->mid) return;

    // 선택한 모듈만 동작하도록
    $mid_list = explode("|@|", $addon_info->mid_list);
    if (!$mid or !in_array($module_info->mid, $mid_list)) return;

    // 로그인 정보
    $logged_info = Context::get('logged_info');

    // 권한 체크
    $grant_name = 'list';
    $grant = false;
    if ($logged_info and count($logged_info->group_list)) {
        if (count($module_info->grants[$grant_name])) {
            $group_srls = $module_info->grants[$grant_name];
            if (!is_array($group_srls)) $group_srls = array($group_srls);

            foreach ($logged_info->group_list as $group_srl => $group_title) {
                if(in_array($group_srl, $group_srls)) {
                    $grant = true;
                    break;
                }
            }
        } // if ($module_info
    } // if ($logged_info

    // 권한이 없는 경우 기본 모듈로 전환
    if ($grant == false) {
        $module_info = $oModuleModel->getModuleInfoByMid();

        $this->mid = $module_info->mid;
        Context::set('mid', $module_info->mid, true);

        $this->document_srl = 0;
        Context::set('document_srl', 0, true);

        $this->module_srl = 0;
        Context::set('module_srl', 0, true);

        $this->act = '';
        Context::set('act', '', true);

        $this->module = '';
        Context::set('module', '', true);

        $this->module_info = '';
        Context::set('module_info', null, true);
    }

?>
