
function completeSendSms(rec_obj) {
	alert(rec_obj['message']);
}

(function($) {

/* DOM READY */
jQuery(function($) {
	var $widgetContainer = $('div.smsxe');
	var $widgetForm = $('form#fo_sms_widget', $widgetContainer);
	var $widgetSerchForm = $('form#fo_sms_widget_search', $widgetContainer);
	var $searchArea = $('.search_area', $widgetContainer);
	var $sendPcsList = $('.send_pcs_list', $widgetContainer);
	var $searchInputbox = $('.input_box', $searchArea);
	var $statusArea = $('.status', $widgetContainer);

	$widgetForm.submit(function() {
		if($(this).hasClass('disable')) {
			alert('사용권한이 없습니다');
			return false;
		}

		if(!$('[name=send_content]', this).val()) {
			alert(lang_require_sms_text);
			$('[name=send_content]', this).focus();
			return false;
		}

		if($('[name=appointment]', this).is(':checked')) {
			var app_date = $('[name=appointment_day]', $widgetForm).val();
			var year  = 	app_date.substring(0,4);
			var month = 	app_date.substring(4,6) - 1;
			var day   = 	app_date.substring(6,8);
			var hour = $('[name=appointment_hour]').val();
			var min	 = $('[name=appointment_min]').val();

			var to_day = new Date().getTime(); // 오늘의 날짜와 시간을 구함
			var appoint_date = new Date(year, month, day, hour, min, 59).getTime();

			if(to_day > appoint_date) {
				alert(lang_set_wrong_appoint_msg);
				return false;
			}
			$('[name=send_appointment_time]', $widgetForm).val(year+'-'+(++month)+'-'+day+' '+hour+':'+min+':'+59);
		}

		procFilter(this, sms_send);
		return false;

	});

	$widgetSerchForm.submit(function() {
		var bcode = $('[name=bcode]', this).val();
		var search = $('[name=search]', this).val();
		var title = $('[name=search]', this).attr('title');
		if(title == search || !search) {
			alert("검색어를 입력해주세요.\n검색항목 : 아이디, 이름, 닉네임");
			$('[name=search]', this).focus();
			return false;
		}
		popopen('./?module=sms&act=dispSmsMemberAddrSetting&bcode='+bcode+'&search=userName&string='+search);
		return false;
	});

	$('textarea', $widgetForm).keyup(function() {
		var get_length = PerbizSMS.getByteLength(this);
		if(!get_length) return;

		$('.status_byte', $statusArea).text(get_length.length);
		$('.limit_byte', $statusArea).text(get_length.limit_byte);
		$('.status_count', $statusArea).text(get_length.sms_count);
	});

	$('textarea', $widgetForm).triggerHandler('keyup');
	$('textarea', $widgetForm).removeAttr('disabled');
	$('.btn_submit', $widgetForm).removeAttr('disabled');

	$('input', $sendPcsList).keypress(function(e) {
		if(e.which == 13) {
			var $nextInput = $(this).parent().next().children('input');

			if($nextInput.length) {
				$nextInput.focus().select();
			} else {
				$('.return_pcs input', $widgetContainer).focus().select();
			}
			return false;
		}
	});

	$('.bth_addressbook a', $widgetContainer).click(function() {
		if($(this).is('.lock')) {
			alert('주소록을 사용할 수 없습니다');
			return false;
		}
		popopen(this.href);
		return false;
	});

	$searchInputbox.watermark($searchInputbox.attr('title'));

	/**
	 * @berif 목록에서 번호 삭제
	 **/
	$('.btn_delete', $sendPcsList).click(function() {
		var $inputAll = $('input', $sendPcsList);
		$(this).prev('input').val('');
		var $nextInput = $(this).parent().nextAll().children('input');
		var values = [];

		$inputAll.each(function(idx) {
			if(this.value && this.value != 'undefined') values.push(this.value);
		});

		$inputAll.val('');
		$inputAll.each(function(idx) {
			if(values[idx]) {
				this.value = values[idx];
			} else {
				this.value = '';
			}

		});
	});


	$('[name=appointment]', $widgetForm).click(function() {
		if($(this).is(':checked')) {
			$('#appointment_div', $widgetForm).show();
		} else {
			$('#appointment_div', $widgetForm).hide();
		}
	});


	$('.btn_appoint', $widgetForm).click(function() {
		$('.appoint', $widgetForm).toggle();
	});

	$('.close', $widgetForm).click(function() {
		$('.appoint', $widgetForm).hide();
	});

	var option = { gotoCurrent: false,yearRange:'-100:+10', onSelect:function(dateText) {
		$('[name=appointment_day]', $widgetForm).val(dateText.replace(/-/g, ''));
	}};
	$('.inputDate', $widgetForm).datepicker(option);
});

}) (jQuery);
