<?php
    /**
     * @class  minishopModel
     * @author perbiz (dev@perbiz.co.kr)
     * @brief  minishop 모듈의 model 클래스
     **/

    class minishopModel extends minishop {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 목록 설정 값을 가져옴
         **/
        function getListConfig($module_srl) {
            $oModuleModel = &getModel('module');
            $oDocumentModel = &getModel('document');

            // 저장된 목록 설정값을 구하고 없으면 기본 값으로 설정
            $list_config = $oModuleModel->getModulePartConfig('minishop', $module_srl);
            if(!$list_config || !count($list_config)) $list_config = array( 'no', 'title', 'nick_name','regdate','readed_count');

            // 사용자 선언 확장변수 구해와서 배열 변환후 return
            $inserted_extra_vars = $oDocumentModel->getExtraKeys($module_srl);

            foreach($list_config as $key) {
                if(preg_match('/^([0-9]+)$/',$key)) $output['extra_vars'.$key] = $inserted_extra_vars[$key];
                else $output[$key] = new ExtraItem($module_srl, -1, Context::getLang($key), $key, 'N', 'N', 'N', null);
            }
            return $output;
        }

        /**
         * @brief 기본 목록 설정값을 return
         **/
        function getDefaultListConfig($module_srl) {
            // 가상번호, 제목, 등록일, 수정일, 닉네임, 아이디, 이름, 조회수, 추천수 추가
            $virtual_vars = array( 'no', 'title', 'regdate', 'last_update', 'nick_name', 'user_id', 'user_name', 'readed_count', 'voted_count' );
            foreach($virtual_vars as $key) {
                $extra_vars[$key] = new ExtraItem($module_srl, -1, Context::getLang($key), $key, 'N', 'N', 'N', null);
            }

            // 사용자 선언 확장변수 정리
            $oDocumentModel = &getModel('document');
            $inserted_extra_vars = $oDocumentModel->getExtraKeys($module_srl);

            if(count($inserted_extra_vars)) foreach($inserted_extra_vars as $obj) $extra_vars['extra_vars'.$obj->idx] = $obj;

            return $extra_vars;

        }

        /**
         * @brief 미니샵 게시물 등록
         */
        function insertMinishop($obj) {			
            if(!$obj->minishop_srl) $obj->minishop_srl = getNextSequence();
            if(!$obj->module_srl) return new Object(-1,'msg_invalid_document');
            if(!$obj->document_srl) return new Object(-1,'msg_invalid_document');
            if($obj->minishop_sell_type == 'safe') {
                if(!$obj->minishop_deal_number) return new Object(-1,'msg_invalid_document');
                if(!$obj->minishop_mem_auth_code) return new Object(-1,'msg_invalid_document');
				return executeQuery('minishop.insertMinishop', $obj);
            }
            if($obj->minishop_sell_type == 'no_safe') {
				return executeQuery('minishop.insertMinishop_no_safe', $obj);				
            }
			
        }

        /**
         * @brief 미니샵 게시물 수정
         */
        function updateMinishop($obj) {
            if(!$obj->module_srl) return new Object(-1,'msg_invalid_document');
            if(!$obj->document_srl) return new Object(-1,'msg_invalid_document');            
			if($obj->minishop_sell_type == 'safe') {
				return executeQuery('minishop.updateMinishop', $obj);
            }
            if($obj->minishop_sell_type == 'no_safe') {
				return executeQuery('minishop.updateMinishop_no_safe', $obj);			
            }
        }

        /**
         * @brief 카트에 넣은 상품 정보 가져오기
         **/
        function getCartList($mid) {
            $oDocumentModel = &getModel('document');
            $oMemberModel = &getModel('member');
            $oModuleModel = &getModel('module');
            $cur_module_info = $oModuleModel->getModuleInfoByMid($mid);

            $cart_list = null;
            $sum_price = 0;
            if(!$_SESSION[$this->cart_sessname][$mid]) return $cart_list;
            $cart_items = $this->getCartItem($mid);

            foreach($cart_items as $idx => $seller) {
                foreach($seller as $deal_number => $cart_item) {
                    $item = new minishopItem($cur_module_info->module_srl, $cart_item['document_srl']);
                    $oDocument = $oDocumentModel->getDocument($cart_item['document_srl']);
                    $item->select_product_quantity = $cart_item['select_product_quantity'];
                    $item->sum_price = $item->get('minishop_price') * $cart_item['select_product_quantity'];
                    $item->oDocument = $oDocument;
                    $cart_list->list[$item->get('minishop_mem_email')]->items[$deal_number] = $item;
                    $cart_list->list[$item->get('minishop_mem_email')]->sum_price += $item->sum_price;
                    $sum_price += $item->sum_price;
                }
            }
            $cart_list->sum_price = $sum_price;
            return $cart_list;
        }

        /**
         * @brief 카트에서 주문할 물품정보 정리
         **/
        function getCartOrderList($mid, $mem_email, $args) {
            $cart_list = $this->getCartList($mid);
            $order_list = array();

            if(!count($cart_list->list[$mem_email]->items)) return;

            foreach($cart_list->list[$mem_email]->items as $idx => $item) {
                $deal_number = $item->getMinishopDealNumber();
                $pro_qty = $args->{'cart_quantity_'.$idx};
                $order_list[] = Array(
                    'pro_unique' => $deal_number,
                    'pro_qty' => $pro_qty
                );
            }

            return $order_list;
        }


        /**
         * @brief 카트 데이터 가져오기
         **/
        function getCartItem($mid, $mem_email = null, $deal_number = null) {
            if($mem_email && $deal_number) {
                return $_SESSION[$this->cart_sessname][$mid][$mem_email][$deal_number];
            } elseif($mem_email && !$deal_number) {
                return $_SESSION[$this->cart_sessname][$mid][$mem_email];
            } else {
                return $_SESSION[$this->cart_sessname][$mid];
            }
        }

        /**
         * @brief 카트 데이터 넣기
         **/
        function setCartItem($mid, $mem_email, $vars) {
            $_SESSION[$this->cart_sessname][$mid][$mem_email][$vars->deal_number] = array(
                'mem_email' => $vars->mem_email,
                'deal_number' => $vars->deal_number,
                'document_srl' => $vars->document_srl,
                'select_product_quantity' => $vars->select_product_quantity
            );
        }
    }
?>
