/**
 * @file   modules/minishop/js/minishop.js
 * @author aliveJune (sjune@perbiz.co.kr)
 * @brief  minishop 모듈의 javascript
 **/

/* 거래완료 이후 */
function completeDealEndMinishop(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var page = ret_obj['page'];
    var document_srl = ret_obj['document_srl'];
    var url = current_url.setQuery('mid',mid).setQuery('act','').setQuery('document_srl',document_srl);
    if(page) url = url.setQuery('page',page);
    location.href = url;
}

/* 글쓰기 작성후 */
function completeMinishopInserted(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var minishop_srl = ret_obj['minishop_srl'];
    var category_srl = ret_obj['category_srl'];

    //alert(message);
    url = current_url.setQuery('mid',mid).setQuery('act','');
    if(category_srl) url = url.setQuery('category',category_srl);
    location.href = url;
}


/* 안전거래 거래모듈 */
function doMinishopPayModule(minishop_deal_number) {
    var url = 'http://www.ezcro.com/php/common/flex/paymodule/paymodule.html?skin_name=xe&pro_unique='+minishop_deal_number;
    doPopup(url,'minishopPayPop',440,620,'no');
}

/*팝업*/
function doPopup(page,name,width,height,scrollbars){
    t = (screen.height) ? (screen.height-height)/2 : 0;
    l = (screen.width) ? (screen.width-width)/2 : 0;
    set = 'height='+height+',width='+width+',top='+t+',left='+l+',scrollbars='+scrollbars+',resizable';
    window.open(page,name,set);
}


//현재 페이지 reload
function completeReload(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];

    location.href = location.href;
}

/* 검색 실행 */
function completeSearch(ret_obj, response_tags, params, fo_obj) {
    fo_obj.submit();
}

function completeVote(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    alert(message);
    location.href = location.href;
}

// 현재 페이지 reload
function completeReload(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];

    location.href = location.href;
}

/* 댓글 글쓰기 작성후 */
function completeInsertComment(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var comment_srl = ret_obj['comment_srl'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(comment_srl) url = url.setQuery('rnd',comment_srl)+'#comment_'+comment_srl;

    //alert(message);

    location.href = url;
}

/* 댓글 삭제 */
function completeDeleteComment(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}

/* 트랙백 삭제 */
function completeDeleteTrackback(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}

/* 글 삭제 */
function completeDeleteDocument(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('act','').setQuery('document_srl','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}
/* 카테고리 이동 */
function doChangeCategory() {
    var category_srl = jQuery('#board_category option:selected').val();
    location.href = decodeURI(current_url).setQuery('category',category_srl);
}

/* 스크랩 */
function doScrap(document_srl) {
    var params = new Array();
    params['document_srl'] = document_srl;
    exec_xml('member','procMemberScrapDocument', params, null);
}


/* 장바구니 담기 */
function doMinishopAddCart(mem_email, deal_number, document_srl, select_product_quantity) {
    jQuery.exec_json('minishop.procMinishopAddCart', {'mid':current_mid, 'mem_email':mem_email, 'deal_number':deal_number, 'document_srl':document_srl, 'select_product_quantity':select_product_quantity}, function(ret) {
        alert(ret.message);
    });
}


function doCartOrder(fo_obj) {
    var $fo_obj = jQuery(fo_obj).closest('form');
    if(!$fo_obj.find('input[name=mem_email]:checked').val()) {
        alert(msg_minishop_not_selected_seller);
        return;
    }

    var url = current_url.setQuery('act', 'procMinishopCartOrder');
    var serialize = $fo_obj.serialize();
    if(serialize) url += '&'+$fo_obj.serialize();
    var status = 'toolbar=0,location=0,status=0,menubar=0,scrollbars=1,resizable=1,width=450,height=600,top=30,left=30';
    window.open(url, 'minishop_cart_order', status);
}

function doCartClear(mem_email, deal_number) {
    var args = {};
    args.mid = current_mid;
    if(mem_email) args.mem_email = mem_email;
    if(deal_number) args.deal_number = deal_number;
    jQuery.exec_json('minishop.procMinishopClearCart', args, function(ret) {
        reloadDocument();
    });
}

(function($) {
    $(function() {
        var $cartSelector = $('span.cart_selector');
        if($cartSelector.length) {
            $cartSelector.find('input:button').click(function() {
                var $this = $(this);
                var mem_email = $this.attr('mem_email');
                var deal_number = $this.attr('deal_number');
                var document_srl = $this.attr('document_srl');
                var select_product_quantity = $cartSelector.find('select option:selected').val();
                doMinishopAddCart(mem_email, deal_number, document_srl, select_product_quantity);
            });
        }

        $('div.minishop_cart input:radio').click(function(a,b,c) {
            $('div.minishop_cart').find('select').attr('disabled', 'disabled');
            $(this).closest('tbody').find('select').removeAttr('disabled');
        });

        $('div.minishop_cart select.cart_quantity').change(function() {
            var $this = $(this);
            var deal_number = $this.attr('deal_number');
            var qty = $this.find(':selected').val();
            var item = minishop_cart.items[deal_number];
            var prev_qty = item.quantity;
            var unit_price = item.unit_price;
            var sum_price = minishop_cart.items[deal_number].unit_price * qty;
            var mem_email = $this.closest('tbody').find('input:radio').val();
            var total_price = minishop_cart.sum_price[mem_email];
            var target = $this.closest('tr').find('span.sum_price');
            var sum_target = $this.closest('tbody').find('span.total_sum_price');

            if(prev_qty > qty) {
                total_price -= (prev_qty - qty) * unit_price;
                item.quantity = qty;
                minishop_cart.sum_price[mem_email] = total_price;
            } else if(prev_qty < qty) {
                total_price += (qty - prev_qty) * unit_price;
                item.quantity = qty;
                minishop_cart.sum_price[mem_email] = total_price;
            }
            target.text(number_format(sum_price));
            sum_target.text(number_format(total_price));
        });
    });
}) (jQuery);

function number_format(input){ 
    var input = String(input); 
    var reg = /(\-?\d+)(\d{3})($|\.\d+)/; 
    if(reg.test(input)){ 
        return input.replace(reg, function(str, p1,p2,p3){ 
                return number_format(p1) + "," + p2 + "" + p3; 
            }     
        ); 
    }else{ 
        return input; 
    } 
}
function doSubmit(){
	if(!confirm("정말로 입력하시겠습니까?")) return false;
}