<?php
    /**
     * @class  minishopController
     * @author perbiz (dev@perbiz.co.kr)
     * @brief  minishop 모듈의 Controller class
     **/

    require_once(_XE_PATH_.'classes/httprequest/XEHttpRequest.class.php');

    class minishopController extends minishop {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 미니샵 글 작성.
         **/
        function procMinishopInsert() {

            // 권한 체크
            if(!$this->grant->write_document) return new Object(-1, 'msg_not_permitted');

            // 글작성시 필요한 변수를 세팅
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
            if($obj->is_notice!='Y'||!$this->grant->manager) $obj->is_notice = 'N';
            settype($obj->title, "string");
            if($obj->title == '') $obj->title = cut_str(strip_tags($obj->content),20,'...');

            //그래도 없으면 Untitled
            if($obj->title == '') $obj->title = 'Untitled';

            // 관리자가 아니라면 게시글 색상/굵기 제거
            if(!$this->grant->manager) {
                unset($obj->title_color);
                unset($obj->title_bold);
            }

            // 이미 존재하는 글인지 체크
            $oDocumentModel = &getModel('document');
            $oDocument = $oDocumentModel->getDocument($obj->document_srl, $this->grant->manager);

            // xe 미니샵 관리자 인증아이디 & 인증코드 얻기
            $oModuleModel = &getModel('module');
            $mid = Context::get('mid');
            $cur_module_info = $oModuleModel->getModuleInfoByModuleSrl($this->module_srl);
            $manager_auth_id = $cur_module_info->manager_auth_id;
            $manager_auth_code = $cur_module_info->manager_auth_code;

            // 미니샵 등록 및 수정
            $minishop_router_page   = $this->ezcro_router_home."router_xe_v2.php";

            // 안전거래 서버에 전달할 파라미터 세팅
            $minishop_router_params  = "?manager_auth_id=".$manager_auth_id."&manager_auth_code=".crypt($manager_auth_code)."&title=".urlencode($obj->title);
            if($oDocument->isExists() && $oDocument->document_srl == $obj->document_srl) {
                // 수정
                $minishop_router_params .= "&ezcro_uid=".$obj->minishop_deal_number;
                $minishop_router_params .= "&mod_type=update";
                $obj->content = preg_replace('!<\!--(Before|After)(Document|Comment)\(([0-9]+),([0-9]+)\)-->!is', '', $obj->content);
            }

            // 안전거래 서버에 전달할 파라미터 세팅
            $minishop_router_params .= "&content=".urlencode(cut_str($this->replaceImageSrc($obj->content),500,'...'));
            $minishop_router_params .= "&minishop_price=".$obj->minishop_price;
            $minishop_router_params .= "&minishop_take_type=".$obj->minishop_take_type;
            $minishop_router_params .= "&minishop_pay_type=".$obj->minishop_pay_type;
            $minishop_router_params .= "&minishop_mem_email=".$obj->minishop_mem_email;
            $minishop_router_params .= "&minishop_pro_num=".$obj->minishop_pro_num;
            $minishop_router_params .= "&xe_mem_auth_code=".$obj->xe_mem_auth_code;

            // 안전거래 서버에 데이터 전송
            $minishop_deal_number = 0;
            $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");

            for($i=0;$i<=10;$i++) {
                $minishop_sock_result = $oXEHttpReq->send($minishop_router_page.$minishop_router_params,"POST",10);
                if($minishop_sock_result->error != -1) {
                    break;
                }
            }

            // 안전거래 서버에서 받은 결과 데이터 처리
            if($minishop_sock_result->error == -1) {
                return new Object(-1, 'msg_minishop_connect_failed');
            } else {
                $minishop_return_data = unserialize($minishop_sock_result->body);
                if($minishop_return_data[code] == "0000") {
                    // 데이터 연동 성공
                    $obj->minishop_deal_number = $minishop_return_data[deal_number];
                } else if($minishop_return_data[code] == "1111") {
                    // 데이터 연동 실패
                    return new Object(-1, $minishop_return_data[body]);
                } else {
                    // 소켓 연결 실패
                    return new Object(-1, 'msg_minishop_connect_failed');
                }
            }

            // 소켓연동 이후 등록및 수정처리
            $oDocumentController = &getController('document');
            $obj->minishop_sell_type = 'safe'; // 안전거래

            $oDB = &DB::getInstance();
            $oDB->begin();
            if($oDocument->isExists() && $oDocument->document_srl == $obj->document_srl) {
                // xe document 수정
                $output = $oDocumentController->updateDocument($oDocument, $obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }

                $oMinishopItem = new minishopItem($this->module_info->module_srl,$obj->document_srl);	
                $obj->document_srl = $output->get('document_srl');
                $obj->minishop_srl = $oMinishopItem->getMinishopSrl();
                $obj->minishop_is_deal_end = 'n';

                // 미니샵 정보 수정
                $oMinishopModel = &getModel('minishop');
                $output = $oMinishopModel->updateMinishop($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }

                $msg_code = 'success_updated';
            } else {
            	$obj->minishop_is_deal_end = 'n';
                // xe document 등록
                $output = $oDocumentController->insertDocument($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }
                $obj->document_srl = $output->get('document_srl');

                // 미니샵 정보 등록
                $obj->minishop_mem_auth_code = $obj->xe_mem_auth_code;
                $obj->minishop_srl = getNextSequence();
                $oMinishopModel = &getModel('minishop');
                $oMinishopModel->insertMinishop($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }

                $msg_code = 'success_registed';

            }
            // 성공 이후처리
            $oDB->commit();

            // 결과를 리턴
            $this->add('mid', Context::get('mid'));
            $this->add('document_srl', $output->get('document_srl'));

            // 성공 메세지 등록
            $this->setMessage($msg_code);
        }

        /**
         * @brief 일반거래 게시물 등록 및 수정
         */
        function procMinishopInsertNoSafe(){
            // 권한 체크
            if(!$this->grant->write_document) return new Object(-1, 'msg_not_permitted');

            // 글작성시 필요한 변수를 세팅
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
            if($obj->is_notice!='Y'||!$this->grant->manager) $obj->is_notice = 'N';
            settype($obj->title, "string");
            if($obj->title == '') $obj->title = cut_str(strip_tags($obj->content),20,'...');

            //그래도 없으면 Untitled
            if($obj->title == '') $obj->title = 'Untitled';

            // 관리자가 아니라면 게시글 색상/굵기 제거
            if(!$this->grant->manager) {
                unset($obj->title_color);
                unset($obj->title_bold);
            }

            // 이미 존재하는 글인지 체크
            $oDocumentModel = &getModel('document');
            $oDocument = $oDocumentModel->getDocument($obj->document_srl, $this->grant->manager);
            $oDocumentController = &getController('document');
            $obj->minishop_sell_type = 'no_safe'; // 일반거래

            // 미니샵 & document 등록 및 수정
            $oDB = &DB::getInstance();
            $oDB->begin();
            if($oDocument->isExists() && $oDocument->document_srl == $obj->document_srl) {
                // xe document 수정
                $output = $oDocumentController->updateDocument($oDocument, $obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }
                $obj->document_srl = $output->get('document_srl');

                $oMinishopItem = new minishopItem($this->module_info->module_srl,$obj->document_srl);
                $obj->minishop_srl = $oMinishopItem->getMinishopSrl();
                
                // 미니샵 정보 수정
                $oMinishopModel = &getModel('minishop');
                $output = $oMinishopModel->updateMinishop($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return $output;
                }

                $msg_code = 'success_updated';
            } else {
                // xe document 등록
                $output = $oDocumentController->insertDocument($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }

                $obj->document_srl = $output->get('document_srl');

                // 미니샵 정보 등록
                $oMinishopModel = &getModel('minishop');
                $oMinishopModel->insertMinishop($obj);
                if(!$output->toBool()) {
                    $oDB->rollback();
                    return new Object(-1,'msg_error_occured');
                }
                $msg_code = 'success_registed';
            }

            $oDB->commit();

            // 결과를 리턴
            $this->add('mid', Context::get('mid'));
            $this->add('document_srl', $output->get('document_srl'));

            // 성공 메세지 등록
            $this->setMessage($msg_code);
        }


        /**
         * @brief 안전거래 이메일 체크
         */
        function procMinishopEmailCheck() {
            $minishop_sock_params = null;
            $mem_email = Context::get('mem_email');
            $minishop_email_check_sock_url = $this->ezcro_router_home."email_chk.php";
            $minishop_sock_params .= "?mem_email=".$mem_email;

            // 안전거래 서버에 데이터 전송
            $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
            for($i=0;$i<=3;$i++) {
                $minishop_sock_result = $oXEHttpReq->Send($minishop_email_check_sock_url.$minishop_sock_params,"GET",30);
                if($minishop_sock_result->error != -1) {
                    break;
                }
            }

            // 안전거래 서버에서 받은 결과 데이터 처리
            if($minishop_sock_result->error == -1) {
                return new Object(-1, 'msg_minishop_auth_fail');
            } else {
                header("Content-type: text/html; charset=UTF-8");
                die($minishop_sock_result->body);
            }
        }


        /**
         * @brief 코멘트 추가
         **/
        function procMinishopInsertComment() {

            // 권한 체
            if(!$this->grant->write_comment) return new Object(-1, 'msg_not_permitted');

            // 댓글 입력에 필요한 데이터 추출
            $obj = Context::gets('document_srl','comment_srl','parent_srl','content','password','nick_name','nick_name','member_srl','email_address','homepage','is_secret','notify_message');
            $obj->module_srl = $this->module_srl;

            // 원글이 존재하는지 체크
            $oDocumentModel = &getModel('document');
            $oDocument = $oDocumentModel->getDocument($obj->document_srl);
            if(!$oDocument->isExists()) return new Object(-1,'msg_not_permitted');

            // comment 모듈의 model 객체 생성
            $oCommentModel = &getModel('comment');

            // comment 모듈의 controller 객체 생성
            $oCommentController = &getController('comment');

            // comment_srl이 존재하는지 체크
            // 만일 comment_srl이 n/a라면 getNextSequence()로 값을 얻어온다.
            if(!$obj->comment_srl) {
                $obj->comment_srl = getNextSequence();
            } else {
                $comment = $oCommentModel->getComment($obj->comment_srl, $this->grant->manager);
            }

            // comment_srl이 없을 경우 신규 입
            if($comment->comment_srl != $obj->comment_srl) {

                // parent_srl이 있으면 답변으
                if($obj->parent_srl) {
                    $parent_comment = $oCommentModel->getComment($obj->parent_srl);
                    if(!$parent_comment->comment_srl) return new Object(-1, 'msg_invalid_request');

                    $output = $oCommentController->insertComment($obj);

                    // 없으면 신규
                } else {
                    $output = $oCommentController->insertComment($obj);
                }

                // 문제가 없고 모듈 설정에 관리자 메일이 등록되어 있으면 메일 발송
                if($output->toBool() && $this->module_info->admin_mail) {

                    $oMail = new Mail();
                    $oMail->setTitle($oDocument->getTitleText());
                    $oMail->setContent( sprintf("From : <a href=\"%s#comment_%d\">%s#comment_%d</a><br/>\r\n%s", $oDocument->getPermanentUrl(), $obj->comment_srl, $oDocument->getPermanentUrl(), $obj->comment_srl, $obj->content));
                    $oMail->setSender($obj->user_name, $obj->email_address);

                    $target_mail = explode(',',$this->module_info->admin_mail);
                    for($i=0;$i<count($target_mail);$i++) {
                        $email_address = trim($target_mail[$i]);
                        if(!$email_address) continue;
                        $oMail->setReceiptor($email_address, $email_address);
                        @$oMail->send();
                    }
                }

                // comment_srl이 있으면 수정으
            } else {
                $obj->parent_srl = $comment->parent_srl;
                $output = $oCommentController->updateComment($obj, $this->grant->manager);
                $comment_srl = $obj->comment_srl;
            }

            if(!$output->toBool()) return $output;

            $this->setMessage('success_registed');
            $this->add('mid', Context::get('mid'));
            $this->add('document_srl', $obj->document_srl);
            $this->add('comment_srl', $obj->comment_srl);
        }

        /**
         * @brief 문서삭제
         **/
        function procMinishopDeleteDocument() {

            // 문서 번호 확인
            $document_srl = Context::get('document_srl');

            // 문서 번호가 없다면 오류 발생
            if(!$document_srl) return $this->doError('msg_invalid_document');

            // document module model 객체 생성
            $oDocumentController = &getController('document');

            // 삭제 시도
            $output = $oDocumentController->deleteDocument($document_srl, $this->grant->manager);
            if(!$output->toBool()) return $output;
            // 성공 메세지 등록
            $this->add('mid', Context::get('mid'));
            $this->add('page', $output->get('page'));
            $this->setMessage('success_deleted');
        }

        /**
         * @brief 코멘트 삭제
         **/
        function procMinishopDeleteComment() {
            // 댓글 번호 확인
            $comment_srl = Context::get('comment_srl');
            if(!$comment_srl) return $this->doError('msg_invalid_request');

            // comment 모듈의 controller 객체 생성
            $oCommentController = &getController('comment');

            $output = $oCommentController->deleteComment($comment_srl, $this->grant->manager);
            if(!$output->toBool()) return $output;

            $this->add('mid', Context::get('mid'));
            $this->add('page', Context::get('page'));
            $this->add('document_srl', $output->get('document_srl'));
            $this->setMessage('success_deleted');
        }


        /**
         * @brief 문서와 댓글의 비밀번호를 확인
         **/
        function procBoardVerificationPassword() {
            // 비밀번호와 문서 번호를 받음
            $password = Context::get('password');
            $document_srl = Context::get('document_srl');
            $comment_srl = Context::get('comment_srl');

            $oMemberModel = &getModel('member');

            // comment_srl이 있을 경우 댓글이 대상
            if($comment_srl) {
                // 문서번호에 해당하는 글이 있는지 확
                $oCommentModel = &getModel('comment');
                $oComment = $oCommentModel->getComment($comment_srl);
                if(!$oComment->isExists()) return new Object(-1, 'msg_invalid_request');

                // 문서의 비밀번호와 입력한 비밀번호의 비교
                if(!$oMemberModel->isValidPassword($oComment->get('password'),$password)) return new Object(-1, 'msg_invalid_password');

                $oComment->setGrant();
            } else {
                // 문서번호에 해당하는 글이 있는지 확
                $oDocumentModel = &getModel('document');
                $oDocument = $oDocumentModel->getDocument($document_srl);
                if(!$oDocument->isExists()) return new Object(-1, 'msg_invalid_request');

                // 문서의 비밀번호와 입력한 비밀번호의 비교
                if(!$oMemberModel->isValidPassword($oDocument->get('password'),$password)) return new Object(-1, 'msg_invalid_password');

                $oDocument->setGrant();
            }
        }

        /**
         * @brief 아이디 클릭시 나타나는 팝업메뉴에 "작성글 보기" 메뉴를 추가하는 trigger
         **/
        function triggerMemberMenu(&$obj) {
            $member_srl = Context::get('target_srl');
            $mid = Context::get('cur_mid');

            if(!$member_srl || !$mid) return new Object();

            $logged_info = Context::get('logged_info');

            // 호출된 모듈의 정보 구함
            $oModuleModel = &getModel('module');
            $cur_module_info = $oModuleModel->getModuleInfoByModuleSrl($this->module_srl);

            if($cur_module_info->module != 'minishop') return new Object();

            // 자신의 아이디를 클릭한 경우
            if($member_srl == $logged_info->member_srl) {
                $member_info = $logged_info;
            } else {
                $oMemberModel = &getModel('member');
                $member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl);
            }

            if(!$member_info->user_id) return new Object();

            // 아이디로 검색기능 추가
            $url = getUrl('','mid',$mid,'search_target','user_id','search_keyword',$member_info->user_id);
            $oMemberController = &getController('member');
            $oMemberController->addMemberPopupMenu($url, 'cmd_view_own_document', './modules/member/tpl/images/icon_view_written.gif');

            return new Object();
        }

         /**
         * @brief 글내용에 포함된 이미지 경로를 추출하여 절대경로로 대체함
         **/
        function replaceImageSrc($content) {
            if(in_array($_SERVER['HTTP_HOST'], array('localhost', '127.0.0.1'))){
                // 로컬이면 이미지 태그 무시
                $content = preg_replace( '/<img.*src="(.*?)".*?>/', ' ', $content );
            } else {
                $content = preg_replace('/src=(["\']?)files/i','src=$1'.Context::getRequestUri().'files', $content);
            }
            return $content;
        }


         /**
         * @brief 거래 완료 처리
         **/
        function procMinishopDealEnd() {
            $minishop_deal_number = 0;
            $obj = Context::getRequestVars();
            if($obj->document_srl > 0) {
                $oMinishopItem = new minishopItem($this->module_info->module_srl,$obj->document_srl);
                $minishop_deal_number = $oMinishopItem->minishop_deal_number;
                $minishop_srl = $oMinishopItem->getMinishopSrl();
                $xe_mem_auth_code = $oMinishopItem->getMinishopMemAuthCode();
                // 미니샵 상품고유번호로 안전거래 거래중지요청
                if($minishop_deal_number > 0) {
                    // xe 미니샵 관리자 인증아이디 & 인증코드 얻기
                    $oModuleModel = &getModel('module');
                    $cur_module_info = $oModuleModel->getModuleInfoByModuleSrl($this->module_info->module_srl);
                    $manager_auth_id = $cur_module_info->manager_auth_id;
                    $manager_auth_code = $cur_module_info->manager_auth_code;


                    // 안전거래 서버에 전달할 파라미터 세팅
                    $minishop_router_mod_page   = $this->ezcro_router_home."router_mod_xe.php";
                    $minishop_router_mod_params .= "?manager_auth_id=".$manager_auth_id."&manager_auth_code=".crypt($manager_auth_code);
                    $minishop_router_mod_params .= "&ezcro_uid=".$minishop_deal_number."&mod_type=end";
                    $minishop_router_mod_params .= "&xe_mem_auth_code=".$xe_mem_auth_code;

                    // 안전거래 서버에 데이터 전송
                    $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
                    for($i=0;$i<=3;$i++) {
                        $minishop_sock_result = $oXEHttpReq->send($minishop_router_mod_page.$minishop_router_mod_params,"POST",10);
                        if($minishop_sock_result->error != -1) {
                            break;
                        }
                    } // end for

                    // 안전거래 서버에서 받은 결과 데이터 처리
                    if($minishop_sock_result->error == -1) {
                        return new Object(-1, 'msg_minishop_connect_failed');
                    } else {
                        $minishop_return_data = unserialize($minishop_sock_result->body);
                        if($minishop_return_data[code] == "0000") {
                            // 데이터 연동 성공
                            $obj->minishop_deal_number = $minishop_return_data[deal_number];
                        } else if($minishop_return_data[code] == "1111") {
                            // 데이터 연동 실패
                            return new Object(-1, $minishop_return_data[body]);
                        } else {
                            // 소켓 연결 실패
                            return new Object(-1, 'msg_minishop_connect_failed');
                        }
                    } // end if
                }

                // 상품정보 수정
                $args = null;
				$args->module_srl = $this->module_info->module_srl;
                $args->document_srl = $obj->document_srl;
                $args->minishop_srl = $minishop_srl;
                $args->minishop_is_deal_end = 'y';
                $args->minishop_price = $oMinishopItem->minishop_price;
                $args->minishop_take_type = $oMinishopItem->minishop_take_type;
                $args->minishop_pay_type = $oMinishopItem->minishop_pay_type;
                $args->minishop_pro_num = $oMinishopItem->minishop_pro_num;
                $args->minishop_sell_type = $oMinishopItem->minishop_sell_type;

                Context::addJsFile($this->module_path.'tpl/js/minishop.js');
                $output = executeQuery('minishop.updateMinishop', $args);
                $this->add('module_srl', $obj->module_srl);
                $this->add('document_srl', $obj->document_srl);
                $this->add('mid', Context::get('mid'));
                $this->add('page',Context::get('page'));

            } else {
                return new Object(-1, 'msg_minishop_deal_end_failed');
            }
        }


        /**
         * @brief 카트에 상품 넣기
         **/
        function procMinishopAddCart() {
            $oMiniModel = &getModel('minishop');
            $vars = Context::getRequestVars();

            $cart_item_info = $oMiniModel->getCartItem($vars->mid, $vars->mem_email, $vars->deal_number);
            if($cart_item_info && $cart_item_info['select_product_quantity'] == $vars->select_product_quantity) {
                $this->setMessage('exist_cart');
                return;
            }
            $oMiniModel->setCartItem($vars->mid, $vars->mem_email, $vars);

            $this->setMessage('stored_cart');
        }


        /**
         * @brief 카트 비우기
         **/
        function procMinishopClearCart($mid=null, $mem_email = null, $deal_number = null) {
            if(!$mid) $mid = Context::get('mid');
            if(!$mem_email) $mem_email = Context::get('mem_email');
            if(!$deal_number) $deal_number = Context::get('deal_number');

            if($mem_email && $deal_number) {
                unset($_SESSION[$this->cart_sessname][$mid][$mem_email][$deal_number]);
            } elseif($mem_email && !$deal_number) {
                unset($_SESSION[$this->cart_sessname][$mid][$mem_email]);
            } else {
                unset($_SESSION[$this->cart_sessname][$mid]);
            }
        }


        /**
         * @brief 카트 상품 주문하기
         **/
        function procMinishopCartOrder() {
            $oModuleModel = &getModel('module');
            $oMinishopModel = &getModel('minishop');
            $mid = Context::get('mid');
            $module_srl = Context::get('module_srl');

            $cur_module_info = $oModuleModel->getModuleInfoByMid($mid);

            // 정리
            $vars = Context::getRequestVars();
            $args->mem_email = $vars->mem_email;
            $args->manager_auth_id = $cur_module_info->manager_auth_id;
            $args->manager_auth_code = crypt($cur_module_info->manager_auth_code);
            $args->cart = base64_encode(serialize($oMinishopModel->getCartOrderList($mid, $vars->mem_email, $vars)));

            $request_url = $this->ezcro_router_home.'cart_xe.php';

            $parameters = array();
            foreach($args as $key => $item) {
                $parameters[$key] = $key.'='.$item;
            }
            $parameters = '?'.implode('&', $parameters);

            $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
            $response = $oXEHttpReq->send($request_url.$parameters, "POST", 10);
            $response = (object)unserialize($response->body);

            if($response->code == '0000') {
                $this->procMinishopClearCart($mid, $vars->mem_email);
                $opener_url = getUrl('', 'mid',$mid);
                Context::addHtmlHeader('<script type="text/javascript">opener.window.location="'.$opener_url.'"; move_url("'.$response->pay_url.'");</script>');
            } else {
                if($response->code == '8888') $response->body .= '\n'.sprintf(Context::getLang('msg_product_qty_less'), $response->pro_unique, $response->pro_remain_num);
                Context::addHtmlHeader('<script type="text/javascript">alert("'.$response->body.'"); self.close();</script>');
            }

            $this->setLayoutFile('default_layout');
        }
    }
?>
