<?php
    /**
     * @class  minishop
     * @author perbiz (dev@perbiz.co.kr)
     * @brief  minishop 모듈의 high class 
     **/

    require_once(_XE_PATH_.'modules/minishop/minishop.item.php');

    class minishop extends ModuleObject {

        var $search_option = array('title','content','title_content','comment','user_name','nick_name','user_id','tag'); ///< 검색 옵션
        var $order_target = array('list_order', 'update_order', 'regdate', 'voted_count', 'readed_count', 'comment_count', 'title'); // 정렬 옵션

        var $skin = "default"; ///< 기본 스킨 이름
        var $list_count = 20; ///< 한 페이지에 나타날 글의 수
        var $page_count = 10; ///< 페이지의 수
        var $category_list = NULL; ///< 카테고리 목록

        var $ezcro_hostname = "www.ezcro.com";
        var $ezcro_router_home = "http://xe.ezcro.com/";
        var $cart_sessname = 'minishop_cart';
        var $_port = '80';

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            
            // fsockopen 함수 사용 여부 체크
            if(!function_exists('fsockopen')) {
                die(Context::getLang('msg_fsockopen_failed'));
            }
            
            // default_socket_timeout 설정
            @ini_set("default_socket_timeout", 300);
                        
            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');


            // 기본 게시판 생성
            $output = executeQuery('module.getDefaultMidInfo');
            if($output->data) return new Object();

            // 기본 모듈을 찾음
            $oModuleModel = &getModel('module');
            $module_info = $oModuleModel->getDefaultMid();

            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oModuleModel = &getModel('module');            
  
            $oDB = &DB::getInstance();
            // 2009. 07. 27 minishop_price 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_price")) return true;
            // 2009. 07. 27 minishop_take_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_take_type")) return true;
            // 2009. 07. 27 minishop_pay_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_pay_type")) return true;
            // 2009. 07. 27 minishop_pro_num 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_pro_num")) return true;
            // 2009. 07. 27 minishop_mem_email 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_mem_email")) return true;
            // 2009. 08. 28 minishop_is_deal_end 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_is_deal_end")) return true;
            // 2009. 09. 02 minishop_mem_auth_code 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_mem_auth_code")) return true;
            // 2010. 01. 08 minishop_sell_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_sell_type")) return true;      
            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            $oDB = &DB::getInstance();
            // 2009. 07. 27 minishop_price 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_price")) {
                $oDB->addColumn('minishop',"minishop_price","number",11);
            }
            // 2009. 07. 27 minishop_take_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_take_type")) {
                $oDB->addColumn('minishop',"minishop_take_type","varchar",5);
            }
            // 2009. 07. 27 minishop_pay_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_pay_type")) {
                $oDB->addColumn('minishop',"minishop_pay_type","varchar",5);
            }
            // 2009. 07. 27 minishop_pro_num 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_pro_num")) {
                $oDB->addColumn('minishop',"minishop_pro_num","number",11);
            }
            // 2009. 07. 27 minishop_mem_email 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_mem_email")) {
                $oDB->addColumn('minishop',"minishop_mem_email","varchar",250);
            }

            // 2009. 08. 28 minishop_is_deal_end 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_is_deal_end")) {
                $oDB->addColumn('minishop',"minishop_is_deal_end","varchar",1,'n');
            }

            // 2009. 09. 02 minishop_mem_auth_code 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_mem_auth_code")) {
                $oDB->addColumn('minishop',"minishop_mem_auth_code","varchar",255);
            }
            
            // 2010. 01. 08 minishop_sell_type 컬럼 추가
            if(!$oDB->isColumnExists("minishop","minishop_sell_type")) {
                $oDB->addColumn('minishop',"minishop_sell_type","varchar",10,'safe');
            }
            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }

        /**
         * @brief module_info 에서 shop type 얻기
         **/
        function getminishopShopType() {
            $oModuleModel = &getModel('module');
            $module_info = $oModuleModel->getDefaultMid();
        	return $module_info->minishop_shop_type;           
        }

    }
?>