/**
 * @file   modules/minishop/js/minishop.js
 * @author aliveJune (sjune@perbiz.co.kr)
 * @brief  minishop 모듈의 javascript
 **/

/* 거래완료 이후 */
function completeDealEndMinishop(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var page = ret_obj['page'];
    var document_srl = ret_obj['document_srl'];
    var url = current_url.setQuery('mid',mid).setQuery('act','').setQuery('document_srl',document_srl);
    if(page) url = url.setQuery('page',page);
    location.href = url;
}

/* 글쓰기 작성후 */
function completeMinishopInserted(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var minishop_srl = ret_obj['minishop_srl'];
    var category_srl = ret_obj['category_srl'];

    url = current_url.setQuery('act','');
    if(mid) url = url.setQuery('mid',mid);
    if(category_srl) url = url.setQuery('category',category_srl);
    location.href = url;
}


/* 안전거래 거래모듈 */
function doMinishopPayModule(minishop_deal_number) {
	var url = "http://www.ezcro.com/php/common/flex/paymodule/paymodule.html?skin_name=xe&pro_unique="+minishop_deal_number;
	doPopup(url,'minishopPayPop',440,620,"no");
}

/*팝업*/
function doPopup(page,name,width,height,scrollbars){
	t = (screen.height) ? (screen.height-height)/2 : 0;
	l = (screen.width) ? (screen.width-width)/2 : 0;
	set = 'height='+height+',width='+width+',top='+t+',left='+l+',scrollbars='+scrollbars+',resizable';
	window.open(page,name,set);
}


//현재 페이지 reload
function completeReload(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];

    location.href = location.href;
}

/* 검색 실행 */
function completeSearch(ret_obj, response_tags, params, fo_obj) {
    fo_obj.submit();
}

function completeVote(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    alert(message);
    location.href = location.href;
}

// 현재 페이지 reload
function completeReload(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];

    location.href = location.href;
}

/* 댓글 글쓰기 작성후 */
function completeInsertComment(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var comment_srl = ret_obj['comment_srl'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(comment_srl) url = url.setQuery('rnd',comment_srl)+"#comment_"+comment_srl;

    //alert(message);

    location.href = url;
}

/* 댓글 삭제 */
function completeDeleteComment(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}

/* 트랙백 삭제 */
function completeDeleteTrackback(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var document_srl = ret_obj['document_srl'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('document_srl',document_srl).setQuery('act','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}

/* 글 삭제 */
function completeDeleteDocument(ret_obj) {
    var error = ret_obj['error'];
    var message = ret_obj['message'];
    var mid = ret_obj['mid'];
    var page = ret_obj['page'];

    var url = current_url.setQuery('mid',mid).setQuery('act','').setQuery('document_srl','');
    if(page) url = url.setQuery('page',page);

    //alert(message);

    location.href = url;
}
/* 카테고리 이동 */
function doChangeCategory() {
    var category_srl = jQuery('#board_category option:selected').val();
    location.href = decodeURI(current_url).setQuery('category',category_srl);
}

/* 스크랩 */
function doScrap(document_srl) {
    var params = new Array();
    params["document_srl"] = document_srl;
    exec_xml("member","procMemberScrapDocument", params, null);
}
