<?php
    /**
     * @class  minishopItem
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  minishopItem 객체
     **/

    class minishopItem extends Object {
        var $document_srl = 0;
        var $module_srl = 0;
        
		function minishopItem($module_srl = 0,$document_srl = 0) {
            $this->module_srl = $module_srl;
            $this->document_srl = $document_srl;
            $this->_loadFromDB();
        }

		function _loadFromDB() {
			if(!$this->module_srl) return;
			if(!$this->document_srl) return;
			$args = null;
			$args->module_srl = $this->module_srl;
			$args->document_srl = $this->document_srl;
			$output = executeQuery('minishop.getMinishop', $args);
			$this->setAttribute($output->data);
		}
        
		function setAttribute($attribute) {
			if(!$attribute->module_srl || !$attribute->document_srl) {
				$this->module_srl = null;
				$this->document_srl = null;
				return;
			}
			$this->comment_srl = $attribute->comment_srl;
			$this->document_srl = $attribute->document_srl;
			$this->adds($attribute);
            if(count($attribute)) foreach($attribute as $key => $val) $this->{$key} = $val;
			
		}

		// 거래번호
		function getMinishopSrl() {
			return $this->get('minishop_srl');
		}
		
		// 회원의 상품인증코드		
		function getMinishopMemAuthCode() {
			return $this->get('minishop_mem_auth_code');
		}
				
		// 안전거래 상품 고유번호
		function getMinishopDealNumber() {
			return $this->get('minishop_deal_number');
		}
				
		// 거래완료 여부
		function getMinishopIsDealEnd() {
			if($this->get('minishop_is_deal_end') == 'y') return true;
			else return false;
		}

        // 거래상태
        function getMinishopDealStatus() {
            if(!$this->getMinishopIsDealEnd()) return Context::getLang('minishop_deal_doing');
            else return Context::getLang('minishop_deal_end');
        }
        		
		// 상품가격
    	function getMinishopPrice() {
			if($this->get('minishop_price') < 1) return '-';

			return number_format($this->get('minishop_price')).Context::getLang('won');
		}
		
		// 배송방법
		function getMinishopTakeType() {
            if(is_null($this->get('minishop_take_type'))) return '-';
            $minishop_take_types = Context::getLang('minishop_take_types');
            return $minishop_take_types[$this->get('minishop_take_type')];
		}
		
		// 결제수단
		function getMinishopPayType() {
			if(is_null($this->get('minishop_pay_type'))) return '-';
            $minishop_pay_types = Context::getLang('minishop_pay_types');
            return $minishop_pay_types[$this->get('minishop_pay_type')];
		}
		
		// 상품수량
		function getMinishopProNum() {
			if($this->get('minishop_pro_num') < 1) return '-';
			return $this->get('minishop_pro_num').Context::getLang('num');
		}
		
		// 판매자 이메일
    	function getMinishopMemEmail() {
    		if(is_null($this->get('minishop_mem_email'))) return '-';

    		return sprintf('<a href="mailto:%s">%s</a>',$this->get('minishop_mem_email'),$this->get('minishop_mem_email'));
		}
		
    }
?>
