<?php 
    /**
     * @class  minishop
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  minishop 모듈의 high class 
     **/

    require_once(_XE_PATH_.'modules/minishop/minishop.item.php');

	class minishop extends ModuleObject {
	
		var $search_option = array('title','content','title_content','comment','user_name','nick_name','user_id','tag'); ///< 검색 옵션
        var $order_target = array('list_order', 'update_order', 'regdate', 'voted_count', 'readed_count', 'comment_count', 'title'); // 정렬 옵션
        
        var $skin = "default"; ///< 스킨 이름
        var $list_count = 20; ///< 한 페이지에 나타날 글의 수
        var $page_count = 10; ///< 페이지의 수
        var $category_list = NULL; ///< 카테고리 목록
        
        var $ezcro_hostname = "www.ezcro.com";
        var $ezcro_router_home = "http://xe.ezcro.com/";

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');

            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            $oModuleController->insertTrigger('member.getMemberMenu', 'minishop', 'controller', 'triggerMemberMenu', 'after');

            // 기본 게시판 생성
            $output = executeQuery('module.getDefaultMidInfo');
            if($output->data) return new Object();

            // 기본 모듈을 찾음
            $oModuleModel = &getModel('module');
            $module_info = $oModuleModel->getDefaultMid();

            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oModuleModel = &getModel('module');
            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            if(!$oModuleModel->getTrigger('member.getMemberMenu', 'minishop', 'controller', 'triggerMemberMenu', 'after')) return true;
            
            $oDB = &DB::getInstance();
			// 2009. 07. 27 minishop_price 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_price")) return true;            
			// 2009. 07. 27 minishop_take_type 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_take_type")) return true;            
			// 2009. 07. 27 minishop_pay_type 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_pay_type")) return true;            
			// 2009. 07. 27 minishop_pro_num 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_pro_num")) return true;            
			// 2009. 07. 27 minishop_mem_email 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_mem_email")) return true;           
			// 2009. 08. 28 minishop_is_deal_end 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_is_deal_end")) return true;
			// 2009. 09. 02 minishop_mem_auth_code 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_mem_auth_code")) return true;    	                     
            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            if(!$oModuleModel->getTrigger('member.getMemberMenu', 'minishop', 'controller', 'triggerMemberMenu', 'after'))
                $oModuleController->insertTrigger('member.getMemberMenu', 'minishop', 'controller', 'triggerMemberMenu', 'after');
                
        	$oDB = &DB::getInstance();	
			// 2009. 07. 27 minishop_price 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_price")) {
				$oDB->addColumn('minishop',"minishop_price","number",11);
			}
			// 2009. 07. 27 minishop_take_type 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_take_type")) {
				$oDB->addColumn('minishop',"minishop_take_type","varchar",5);
			}
			// 2009. 07. 27 minishop_pay_type 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_pay_type")) {
				$oDB->addColumn('minishop',"minishop_pay_type","varchar",5);
			}
			// 2009. 07. 27 minishop_pro_num 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_pro_num")) {
				$oDB->addColumn('minishop',"minishop_pro_num","number",11);
			}
			// 2009. 07. 27 minishop_mem_email 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_mem_email")) {
				$oDB->addColumn('minishop',"minishop_mem_email","varchar",250);
			}       
			
			// 2009. 08. 28 minishop_is_deal_end 컬럼 추가
	        if(!$oDB->isColumnExists("minishop","minishop_is_deal_end")) {
				$oDB->addColumn('minishop',"minishop_is_deal_end","varchar",1,'n');
			}  
			
			// 2009. 09. 02 minishop_mem_auth_code 컬럼 추가\
	        if(!$oDB->isColumnExists("minishop","minishop_mem_auth_code")) {
				$oDB->addColumn('minishop',"minishop_mem_auth_code","varchar",255);
			}  			
            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }	

		
	}
?>