/**
 * @brief 뉴스티커 형식으로 표시하기 위한 초기화 작업
 **/

var newsTickerMoveUpStep = new Array();
function doStartScroll(id, type, itemSize, speed, scroll_rate, stop) {
    var pObj = xGetElementById(id);
    var childObj = pObj.firstChild;

    while(childObj) {
        if(childObj.nodeName == 'UL') {
            childObj.id = id+'_first';
            var cloneObj = childObj.cloneNode(true);
            cloneObj.id = id+'_second';
            childObj.parentNode.insertBefore(cloneObj, childObj);

			if(type == 'typeA') var ticker = {"pObj":pObj, "child":childObj, "itemWidth":itemSize, "speed":speed, "scroll_rate":scroll_rate}
			else if(type == 'typeB') var ticker = {"pObj":pObj, "child":childObj, "itemHeight":itemSize, "speed":speed, "scroll_rate":scroll_rate}
            else var ticker = {"pObj":pObj, "child":childObj, "itemHeight":itemSize, "speed":speed, "scroll_rate":scroll_rate}

			newsTickerMoveUpStep[id] = 1;

			if(stop == 'Y') {
		        xAddEventListener(pObj, 'mouseover', function() { newsTickerMoveUpStep[id] = 0; } );
			    xAddEventListener(pObj, 'mouseout', function() { newsTickerMoveUpStep[id] = 1; } );
			}

            doScroll(ticker);
            return;
        }
        childObj = childObj.nextSibling;
    }
}
function doScroll(obj, i) {
	if(!parseInt(obj.scroll_rate)) obj.scroll_rate = 3500;
	if(typeof(obj.itemWidth) != 'undefined') {
		var sl = obj.pObj.scrollLeft;
		var childObj = xGetElementsByTagName('ul', obj.pObj);
		if(typeof(i) == 'undefined') var i = 0;
		var count = childObj.length;
		if(count < i) i = 0;
		(function($){
		$(obj.pObj).scrollLeft($(childObj[i]).scrollLeft());
		i = i + 1;
		})(jQuery);

		if(obj.pObj.scrollLeft % obj.itemWidth == 0) setTimeout( function() { doScroll(obj, i); }, obj.scroll_rate);
		else setTimeout( function() { doScroll(obj); }, obj.speed );
	} else if (typeof(obj.itemHeight) != 'undefined') {
		var st = obj.pObj.scrollTop;
		st += newsTickerMoveUpStep[obj.pObj.id];

		if(st > xHeight(obj.child)) st = 0;
		obj.pObj.scrollTop = st;

		if(obj.pObj.scrollTop % obj.itemHeight == 0) setTimeout( function() { doScroll(obj); }, obj.scroll_rate);
		else setTimeout( function() { doScroll(obj); }, obj.speed );
	}
}
