<?php
    /**
     * @class lineadWidget
     * @author SMaker (dowon2308@paran.com)
     * @version 0.6.1
     * @brief 전광판 출력 위젯
     **/

	if(file_exists(_XE_PATH_.'modules/ad/ad.item.php')) require_once(_XE_PATH_.'modules/ad/ad.item.php');

    class lineadWidget extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
			// 언어팩 로드
			Context::loadLang(_XE_PATH_.'widgets/lineadWidget/lang');

			// 광고 모듈이 설치되어 있지 않은 경우 에러
			if(!is_dir(_XE_PATH_.'modules/ad/') || !file_exists(_XE_PATH_.'modules/ad/ad.class.php')) return Context::getLang('msg_not_installed_ad_module');

			// 대상 모듈
			if($args->module_srls) {
				$args->module_srls = (int)$args->module_srls;

				// module_srl로 mid 값 구함
				$oModuleModel = &getModel('module');
				$oModuleInfo= $oModuleModel->getModuleInfoByModuleSrl($args->module_srls);

				// 넘어온 mid 값이 배열인지 확인
				if(is_array($oModuleInfo)) $oModuleInfo = $oModuleInfo[0];

				// 대상 모듈이 광고 모듈인지 확인
				if($oModuleInfo->module != 'ad') return Context::getLang('msg_linead_invalid_target_module');

				$widget_info->linead_mid = $oModuleInfo->mid;
			}

			// module_srl 또는 mid 값을 찾지 못했을 경우 에러
			if(!$args->module_srls || !$widget_info->linead_mid) return Context::getLang('msg_not_founded');

			$oTemplate = &TemplateHandler::getInstance();

			// 넘어온 변수들을 확인하고 잘못되었으면 기본 값 지정
			$widgetTypes = array('typeA','typeB','typeC');
			if(!$args->widget_type || !in_array($args->widget_type,$widgetTypes)) $args->widget_type = 'typeB'; // 종류
			$args->subject_cut_size = (int)$args->subject_cut_size;
			if(!$args->subject_cut_size) $args->subject_cut_size = 50; // 내용 길이 제한 (기본값 : 50)
			if($args->scroll_stop != 'N') $args->scroll_stop ='Y'; // 마우스 올릴 시 스크롤 중단 (기본값 : 사용)
			if($args->display_author != 'N') $args->display_author = 'Y'; // 등록자 표시 (기본값 : 사용)
			if($args->display_notice_head != 'N') $args->display_notice_head = 'Y'; // 공지 머릿말 표시 (기본값 : 사용)
			if(!(int)$args->scroll_speed) $args->scroll_speed = 50; // 스크롤 속도 (기본값 : 50)
			if(!(int)$args->scroll_rate) $args->scroll_rate = 3500; // 스크롤 간격 (기본값 : 3500)
			if($args->use_extra_info != 'Y') $args->use_extra_info = 'N'; // // 회원 확장 정보 사용 (기본값 : 사용 안함)

			// 위젯 정보에 넣기
			$widget_info->widget_type = $args->widget_type;
			$widget_info->subject_cut_size = $args->subject_cut_size;
			$widget_info->display_author = $args->display_author;
			$widget_info->display_notice_head = $args->display_notice_head;
			$widget_info->display_image_nick = $args->display_image_nick;
			$widget_info->scroll_stop = $args->scroll_stop;
			$widget_info->scroll_speed = $args->scroll_speed;
			$widget_info->scroll_rate = $args->scroll_rate;
			$widget_info->use_extra_info = $args->use_extra_info;

			// 캐시 파일 경로
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($args->module_srls));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);

			// 디버그 모드 (true : 사용, false : 사용 안함)
			$debug_mode = false;

			$oAdModel = &getModel('ad');

			// if exists cache file, read cache file or find in db
			if(!file_exists($cache_filename) || (file_exists($cache_filename) && date('YmdHis',filemtime($cache_filename))+60*60 < date('YmdHis')) || $debug_mode) {
				$args->module_srl = $args->module_srls;
				$args->end_date = date('YmdHis');
				$args->no_page = 'Y';

				$output = $oAdModel->getAdList($args);

				// write cache file
				FileHandler::writeFile($cache_filename, base64_encode(serialize($output->data)));
			} else {
				// read cache file
				$output->data = unserialize(base64_decode(FileHandler::readFile($cache_filename)));
			}

			$widget_info->ad_list = $output->data;

			Context::set('colorset', $args->colorset);
			Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
			Context::set('colorset', $args->colorset);

            // 템플릿 컴파일
            $output = $oTemplate->compile($tpl_path, 'content');

			return $output;
        }
    }
?>
