<?php
/**
 * @class  ad
 * @author 퍼니XE <contact@funnyxe.com>
 * @brief  ad 모듈의 high class
 **/

	class ad extends ModuleObject {
		// URL 열기 대상
		public $url_target = array('_blank','_self');

		// 파일 종류에 따른 Content-Type 정의
		public $image_mime = array('image/gif','image/jpeg','image/png');
		public $video_mime = array('video/mp4','video/mpeg','video/quicktime','video/x-flv','video/x-ms-wmv','video/x-msvideo');

		// 관리자 페이지에서 사용되는 검색 옵션
		public $search_option = array('content','user_id','member_srl','user_name','nick_name','is_notice','tags','click_count','regdate','ipaddress');

		/**
		 * @brief 광고 모듈 설치
		 * @return new Object
		 **/
		public function moduleInstall()
		{
			$oModuleController = getController('module');
			$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');
			$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');
			$oModuleController->insertTrigger('moduleObject.proc', 'ad', 'controller', 'triggerBeforeModuleProc', 'before');

			return $this->makeObject();
		}

		/**
		 * @brief 광고 모듈 삭제
		 * @return new Object
		 */
		function moduleUninstall()
		{
			$oModuleModel = getModel('module');
			$oModuleController = &getController('module');

			// 모듈 삭제
			$output = executeQueryArray('ad.getAllModule');
			if($output->data) {
				@set_time_limit(0);
				foreach($output->data as $module) {
					$oModuleController->deleteModule($module->module_srl);
				}
			}

			/* 트리거 삭제 */
			if($oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after'))
				$oModuleController->deleteTrigger('moduleHandler.init', 'ad', 'controller' , 'triggerNotifyAdTime', 'after');

			if($oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before'))
				$oModuleController->deleteTrigger('module.deleteModule', 'ad', 'controller' , 'triggerDeleteModuleAds', 'before');

			if($oModuleModel->getTrigger('moduleObject.proc', 'ad', 'controller', 'triggerBeforeModuleProc', 'before'))
				$oModuleController->deleteTrigger('moduleObject.proc', 'ad', 'controller' , 'triggerBeforeModuleProc', 'before');
			/* 트리거 삭제 끝 */

			return $this->makeObject();
		}

		/**
		 * @brief 업데이트가 필요한지 확인
		 **/
		public function checkUpdate()
		{
			$oDB = DB::getInstance();
			$oAdModel =  getModel('ad');

			// 트리거 존재 여부 확인
			$oModuleModel = getModel('module');
			if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after')) return true;
			if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before')) return true;
			if(!$oModuleModel->getTrigger('moduleObject.proc', 'ad', 'controller', 'triggerBeforeModuleProc', 'before')) return true;

			return false;
		}

		/**
		* @brief 업데이트
		 * @return new Object
		**/
		public function moduleUpdate()
		{
			$oDB = DB::getInstance();
			$oAdModel = getModel('ad');
			$oAdController = getController('ad');
			$oModuleModel = getModel('module');
			$oModuleController = getController('module');

			// 광고 알림용 트리거 추가
			if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after'))
				$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');

			// 광고 삭제용 트리거 추가
			if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before'))
				$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');

			if(!$oModuleModel->getTrigger('moduleObject.proc', 'ad', 'controller', 'triggerBeforeModuleProc', 'before'))
			{
				$oModuleController->insertTrigger('moduleObject.proc', 'ad', 'controller', 'triggerBeforeModuleProc', 'before');
			}
			return $this->makeObject('success_updated');
		}

		/**
		 * 캐시 파일 재생성
		 *
		 * @return void
		 **/
		public function recompileCache()
		{
			// 모든 캐시 파일을 삭제한다
			$oAdController = getController('ad');
			$oAdController->deleteAllCache();
		}

		public function makeObject($code = 0, $msg = 'success')
		{
			return class_exists('BaseObject') ? new BaseObject($code, $msg) : new Object($code, $msg);
		}
	}

	/**
	 * 광고 이미지 출력 함수
	 */
	function XE_ad_image($document_srl = null, $width = 100, $height = 100) {
	}

	function days_in_month($month, $year) {
		return $month == 2 ? ($year % 4 ? 28 : ($year % 100 ? 29 : ($year % 400 ? 28 : 29))) : (($month - 1) % 7 % 2 ? 30 : 31); 
	}