<?php
    /**
     * @class  AdAdminView
     * @author SMaker (dowon2308@paran.com)
     * @brief  admin view class of ad module
     **/
     
     class adAdminView extends ad {

        /**
         * @brief init
         **/
        function init() {
            // 권한 확인
            $oMemberModel = &getModel('member');
            $logged_info = $oMemberModel->getLoggedInfo();

            // 관리자가 아니라면 에러
            if($logged_info->is_admin!='Y') return $this->stop('msg_is_not_administrator');

            // 요청된 module_srl이 모듈의 module_srl과 다르다면
            $module_srl = Context::get('module_srl');
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set('module_srl', $module_srl);
            }

            // module 모듈의 model 객체 생성
            $oModuleModel = &getModel('module');

            // 요청받은 모듈의 정보를 구함
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                if(!$module_info) {
                    Context::set('module_srl','');
                } else {
					ModuleModel::syncModuleToSite($module_info);
					$this->module_info = $module_info;
					Context::set('module_info',$module_info);
				}
			}

			// 요청된 모듈이 ad가 아니면 모듈을 ad로 바꿔서 재접속
			if(strtolower($this->module_info->module) != 'ad') {
				// URL 구함
				if(version_compare(__ZBXE_VERSION__, '1.2.6', '>=')) $url = str_replace('&amp;','&',getNotEncodedFullUrl('module','ad'));
				else $url = htmlspecialchars_decode(getUrl('module','ad'));

				// 새 주소로 이동
				Context::close();
				header('location:'.$url);
				exit;
			}

			// 기본 설정 구함
			$oAdModel = &getModel('ad');
			$config = $this->config = $oAdModel->getConfig();
			Context::set('config', $config);

			// 모듈 버전 구함
			Context::set('module_version',$oAdModel->getVersion());

			// 템플릿 경로 지정
			$template_path = sprintf('%stpl/',$this->module_path);
			$this->setTemplatePath($template_path);

			// 공용 css / js 파일 로드
			Context::addJsFile($this->module_path.'tpl/js/ad_admin.js');

            // ID 찾기 팝업창이 아닌 경우에만 대시보드 레이아웃 지정
			if(strtolower(Context::get('act')) != 'dispAdAdminFindUserId') {
				// 모듈 분류 구함
				$module_category = $oModuleModel->getModuleCategories();
				Context::set('module_category', $module_category);

				// 레이아웃 변경
				$this->setLayoutPath($this->getTemplatePath());
				$this->setLayoutFile('DashboardLayout.html');

				// 대시보드 메뉴 구함
				$this->dashboard_menus = Context::getLang('dashboard_menus');
				unset($this->dashboard_menus['PluginSetup']); /// < 연동 설정은 제외
				Context::set('dashboard_menus', $this->dashboard_menus);
			}

			// set browser title
			Context::setBrowserTitle(Context::getLang('ad_module'));
		}

		function dispAdAdminDashBoard() {
			// create ad module model
			$oAdModel = &getModel('ad');

			// if exists old linead module info, execute update
			/*if(!file_exists(_XE_PATH_.'files/cache/ad/updated')) {
				if($oAdModel->getOldConfig()) $need_update = true;
			}*/

			if($this->config->display_today_ad == 'Y') {

			// 목록을 구하기 위한 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->list_count = 10;
			$args->page_count = 1;

			// 오늘 등록된 광고만 뽑아오기
			$args->start_regdate = date('Ymd').'000000';

			// set sort index
			$args->sort_index = 'list_order';
			$args->order_type = 'asc';

			// except notice
			$args->is_notice = 'N';

			// all
			$args->select_all_ad = 'Y';

			// get normal ad
			$output = $oAdModel->getAdList($args);
			Context::set('today_ad', $output->data);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('page_navigation', $output->page_navigation);
			}

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('dashboard'));

			// 템플릿 파일 지정
			$this->setTemplateFile('_dashboard');
		}

		function dispAdAdminConfig() {
			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','insert_config.xml');

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['DefaultSetup']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('Config');
		}

		function dispAdAdminUpdate() {
			$command = Context::get('command');
			switch($command) {
				case 'migration':
					$title = Context::getLang('cmd_update');
					$template_file = 'Update';
					break;
				case 'delete':
					$title = Context::getLang('cmd_delete_old_config');
					$template_file = 'DeleteOldConfig';
					break;
				default :
					return new Object(-1, 'msg_invalid_request');
			}
			$title = $command!='update'?'기존 설정 삭제':Context::getLang('cmd_update');

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$title);

			// 템플릿 파일 지정
			$this->setTemplateFile($template_file);
		}

		/**
		 * @brief 광고 목록
		 **/
		function dispAdAdminList() {
			$oModuleModel = &getModel('module');
			$oAdModel = &getModel('ad');

			if(Context::get('is_total') != 'Y') $args->module_srl = $this->module_srl;

			// 목록을 구하기 위한 대상 모듈/ 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->page = Context::get('page');
			$args->list_count = $module_info->list_count;
			$args->page_count = $module_info->page_count;

			// 검색과 정렬을 위한 변수 설정
			$args->search_target = Context::get('search_target');
			$args->search_keyword = Context::get('search_keyword');

			// 지정된 정렬값이 없다면 정렬 값을 지정함
			$args->sort_index = 'list_order';
			$args->order_type = 'asc';

			// 공지는 제외
			$args->is_notice = 'N';

			$args->select_all_ad = 'Y';

			// 만약 검색어가 있으면 list_count를 search_list_count 로 이용
			if($args->search_keyword) $args->list_count = $this->search_list_count;

			// 일반 글을 구해서 context set
			$output = $oAdModel->getAdList($args);
			Context::set('ad_list', $output->data);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('page_navigation', $output->page_navigation);

			// 템플릿에서 사용할 변수를 Context::set()
			if($this->module_srl) Context::set('module_srl',$this->module_srl);
			Context::set('module_info',$this->module_info);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageAd']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('AdList');
		}

		/**
		 * @brief  광고 모듈 목록
		 **/
		function dispAdAdminModuleList() {
			// 등록된 ad 모듈을 불러와 세팅
			$args->sort_index = 'module_srl';
			$args->page = Context::get('page');
			$args->list_count = 20;
			$args->page_count = 10;
			$args->s_module_category_srl = Context::get('module_category_srl');
			$output = executeQueryArray('ad.getAdModuleList', $args);
			ModuleModel::syncModuleToSite($output->data);

			// 템플릿에 쓰기 위해서 context::set
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('board_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('ModuleList');
		}

		/**
		 * @brief 선택된 광고 모듈의 정보 출력 (바로 정보 입력으로 변경)
		 **/
		function dispAdAdminModuleInfo() {
			$this->dispAdAdminInsertModule();
		}

		/**
		 * @brief 광고 모듈 추가 폼 출력
		 **/
		function dispAdAdminInsertModule() {
			if(!in_array($this->module_info->module, array('admin', 'ad'))) return new Object(-1, 'msg_invalid_request');

			// 스킨 목록을 구해옴
			$oModuleModel = &getModel('module');
			$skin_list = $oModuleModel->getSkins($this->module_path);
			Context::set('skin_list',$skin_list);

			// 레이아웃 목록을 구해옴
			$oLayoutModel = &getModel('layout');
			$layout_list = $oLayoutModel->getLayoutList();
			Context::set('layout_list', $layout_list);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','insert_module.xml');

			// module_srl의 유무에 따른 브라우저 제목 지정
			if(Context::get('module_srl')) Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_module_setup'));
			else Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_make_module'));

			// 템플릿 파일 지정
			$this->setTemplateFile('ModuleInsert');
		}

		/**
		 * @brief 광고 모듈 삭제 화면 출력
		 **/
		function dispAdAdminDeleteModule() {
			if(!Context::get('module_srl')) return $this->dispAdAdminModuleList();
			if(!in_array($this->module_info->module, array('admin', 'ad'))) return new Object(-1, 'msg_invalid_request');

			$module_info = Context::get('module_info');

			// 광고 갯수 구함
			$oAdModel = &getModel('ad');
			$ad_count = $oAdModel->getAdCount($module_info->module_srl);
			$module_info->ad_count = $ad_count;

			Context::set('module_info',$module_info);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','delete_module.xml');

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_delete_module'));

			// 템플릿 파일 지정
			$this->setTemplateFile('ModuleDelete');
		}

		/**
		 * @brief 권한 목록 출력
		 **/
		function dispAdAdminGrantInfo() {
			// 공통 모듈 권한 설정 페이지 호출
			$oModuleAdminModel = &getAdminModel('module');
			$grant_content = $oModuleAdminModel->getModuleGrantHTML($this->module_info->module_srl, $this->xml_info->grant);
			Context::set('grant_content', $grant_content);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title'].' > '.Context::getLang('cmd_manage_grant'));

			// 템플릿 파일 지정
			$this->setTemplateFile('GrantList');
		}

		/**
		 * @brief 스킨 정보 보여줌
		 **/
		function dispAdAdminSkinInfo() {
			// 공통 모듈 권한 설정 페이지 호출
			$oModuleAdminModel = &getAdminModel('module');
			$skin_content = $oModuleAdminModel->getModuleSkinHTML($this->module_info->module_srl);
			Context::set('skin_content', $skin_content);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title'].' > '.Context::getLang('cmd_manage_skin'));

			$this->setTemplateFile('SkinInfo');
		}

		/**
		 * @brief 공지 관리
		 **/
		function dispAdAdminNoticeList() {
			$oModuleModel = &getModel('module');
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->page = Context::get('page');
			$args->list_count = $module_info->list_count;
			$args->page_count = $module_info->page_count;

			// 검색과 정렬을 위한 변수 설정
			$args->search_target = Context::get('search_target');
			$args->search_keyword = Context::get('search_keyword');

			// 지정된 정렬값이 없다면 정렬 값을 지정함
			$args->sort_index = 'list_order';
			$args->order_type = 'asc';

			// 만약 검색어가 있으면 list_count를 search_list_count 로 이용
			if($args->search_keyword) $args->list_count = $this->search_list_count;

			$args->is_notice = 'Y';
            $args->with_page = true;
            $args->select_all_ad = 'Y';

			// 공지를 구해서 context set
			$output = $oAdModel->getAdList($args);
			Context::set('notice_list', $output->data);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('page_navigation', $output->page_navigation);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageNotice']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('NoticeIndex');
		}

		/**
		 * @brief 공지 등록
		 **/
		function dispAdAdminNoticeWrite() {
			if(!Context::get('module_srl')) {
				// 등록된 ad 모듈을 불러와 세팅
				$args->sort_index = 'module_srl';
				$args->page = Context::get('page');
				$args->list_count = 20;
				$args->page_count = 10;
				$args->s_module_category_srl = Context::get('module_category_srl');
				$output = executeQueryArray('ad.getAdModuleList', $args);
				ModuleModel::syncModuleToSite($output->data);

				// 템플릿에 쓰기 위해서 context::set
				Context::set('total_count', $output->total_count);
				Context::set('total_page', $output->total_page);
				Context::set('page', $output->page);
				Context::set('board_list', $output->data);
				Context::set('page_navigation', $output->page_navigation);

				// 브라우저 제목 지정
				Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_insert_notice').' > '.Context::getLang('cmd_select_module'));
			} else {
				// 브라우저 제목 지정
				Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_insert_notice'));

				// module srl로 mid 찾기
				$oModuleModel = &getModel('module');
				$module_info = $oModuleModel->getModuleInfoByModuleSrl((int)Context::get('module_srl'));

				// mid를 찾지 못했다면 에러
				if($module_info->mid) {
					Context::set('mid', $module_info->mid);
					Context::set('module_srl', $module_info->module_srl);
				} else {
					return new Object(-1, 'msg_module_is_not_exists');
				}

				// Apply Javascript Filter
				Context::addJsFilter($this->module_path.'tpl/filter/','insert_notice.xml');
			}

			// 템플릿 파일 지정
			$this->setTemplateFile('NoticeWrite');
		}

		/**
		 * @brief 추가 기능 설정
		 **/
		function dispAdAdminPluginSetup() {
			// 추가 기능을 구해옴
			$oAdModel = &getModel('ad');
			$plugin_list = $oAdModel->getPluginList(false, $site_srl);

			Context::set('plugin_list', $plugin_list);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['PluginSetup']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('PluginIndex');
		}

		/**
		 * @brief help desk
		 **/
		function dispAdAdminHelp() {
			// create model class of ad module
			$oAdModel = &getModel('ad');

			// get help list
			$oHelpList = $oAdModel->getHelpList();
			Context::set('help_index', $oHelpList);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['help']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('Help');
		}

		/**
		 * @brief help desk
		 **/
		function dispAdAdminHelpView() {
			$doc = Context::get('doc');

			// if document is not exists, return main page
			if(!$doc) return $this->dispAdAdminHelp();

			// create model class of ad module
			$oAdModel = &getModel('ad');

			// get help list
			$oHelpList = $oAdModel->getHelpList();
			Context::set('help_index', $oHelpList);

			// get content
			$help_content = $oAdModel->getHelpContent($doc);
			Context::set('help_content', $help_content);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['help']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('HelpView');
		}

		/**
		 * @brief ID 찾기 팝업
		 **/
		function dispAdAdminFindUserId() {
			// 템플릿 파일 지정
			$this->setTemplateFile('FindUserId');
		}
	}
?>
