<?php
    /**
     * @class  adController
     * @author SMaker (dowon2308@paran.com)
     * @brief  controller class of ad module
     **/

    class adController extends ad {

        /**
         * @brief init
         **/
        function init() {
			$oAdModel = &getModel('ad');
			if(!$this->module_info->ad_time_range)
				$this->module_info->ad_time_range = $oAdModel->getDefaultAdTimeRange();
        }

        /**
         * @brief procAdRegister
         **/
		function procAdRegister() {
			// get logged info
			$logged_info = Context::get('logged_info');

            // grant check
            if(!$this->grant->register_ad) return new Object(-1, 'msg_not_permitted');

            // get request vars
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
            if($obj->is_notice !='Y'|| !$this->grant->manager) $obj->is_notice = 'N';
			if($logged_info->is_admin != 'Y') $obj->url = removeHackTag($obj->url);

			// if ad content is null, print error
			settype($obj->ad_content, 'string');
			if($obj->ad_content == '') return new Object(-1, 'msg_invalid_request');

			// set default value
			$obj->title = $obj->ad_content;
			$obj->content = $obj->ad_content;
			$obj->allow_comment = 'N';
			$obj->lock_comment = 'Y';
			if($obj->url && !preg_match('/^([a-z]+):\/\//i',$obj->url)) $obj->url = 'http://'.$obj->url;
			if(!in_array($obj->url_target,array('_self','_blank'))) $obj->url_target = '_blank';

			// if writer doesn't have highlight grant, delete highlight option
			if(!$this->grant->highlight_ad) {
				unset($obj->ad_color);
				unset($obj->ad_bgcolor);
				unset($obj->used_style);
			}

			// used ad option convert to array
			$used_style = $obj->used_style?explode('|@|',$obj->used_style):false;

			// if color (text, background) is same, print error
			if($obj->ad_color && $obj->ad_bgcolor && $obj->ad_color == $obj->ad_bgcolor) return new Object(-1, 'msg_invalid_color');

			// calculate ad highlight point
			if($obj->is_notice != 'Y' && ($obj->used_style || $obj->ad_color || $obj->ad_bgcolor)) {
				$highlight_point = 0;

				if($this->module_info->each_highlight_point == 'Y') {
					if(count($used_style)>0) $highlight_point += count($used_style) * $this->module_info->highlight_point;
					if($obj->ad_color) $highlight_point += $this->module_info->highlight_point;
					if($obj->ad_bgcolor) $highlight_point += $this->module_info->highlight_point;
				} else {
					$highlight_point = $this->module_info->highlight_point;
				}
			}

			// used text color save in array
			if($obj->ad_color) {
				$used_style[] = 'text_'.$obj->ad_color;
				unset($obj->ad_color);
			}

			// used background color save in array
			if($obj->ad_bgcolor) {
				$used_style[] = 'bg_'.$obj->ad_bgcolor;
				unset($obj->ad_bgcolor);
			}

			// add used ad option and style array
			if(is_array($used_style)) $obj->used_style = join('|@|',$used_style);
			else $obj->used_style = '';

			// create model object of point module
			$oPointModel = &getModel('point');

			// create controller object of point module
			$oPointController = &getController('point');

			// if logged member isn't manager
			if(!$this->grant->manager) {
				// check daily registration limit (except the notice)
				$daily_limit = (int)$this->module_info->daily_limit;
				if($daily_limit>0 && $obj->is_notice !='Y') {
					$args->start_date = date('Ymd').'000000';
					$args->module_srl = $this->module_info->module_srl;
					$args->member_srl = $logged_info->member_srl;
					$args->is_notice = 'N';
					
					$output = executeQuery('ad.getAds',$args);
					if(count($output->data)>$daily_limit) return new Object(-1, sprintf(Context::getLang('msg_daily_limit_over'),$daily_limit));
					unset($output);
				}
			}

			// check point (except the notice)
			if($obj->is_notice !='Y') {
				$ad_point = (int)$this->module_info->ad_point;
				// if use the ad time
				if($this->module_info->ad_point_rate && $this->module_info->use_time == 'Y') {
					$ad_point *= $obj->ad_time / $this->module_info->ad_point_rate;
					$ad_point += $highlight_point;
					if($ad_point>0) {
						$prev_point = $oPointModel->getPoint($logged_info->member_srl);
						if($ad_point > $prev_point) return new Object(-1, 'msg_not_enough_point');
					}
				}
			}
				

			// check validation of ad time (for defense the Firebug and Developer Tool)
			if($this->module_info->use_time == 'Y') {
				$obj->ad_time = (int)$obj->ad_time;
				$ad_time_range = $this->module_info->ad_time_range?explode(',',$this->module_info->ad_time_range):$oAdModel->getDefaultAdTimeRangeArray();
				$ad_time_range[] = -1;
				if($obj->ad_time == -1 && (!$this->grant->unlimited_ad && !$this->grant->manager)) return new Object(-1, 'msg_invalid_ad_time');
				if(!$obj->ad_time || !in_array($obj->ad_time, $ad_time_range)) return new Object(-1, 'msg_invalid_ad_time');
			}
			
            // create model class of ad module
            $oAdModel = &getModel('ad');

            // create controller class of ad module
            $oDocumentController = &getController('document');

            // check already exists
            $oAd = $oAdModel->getAd($obj->document_srl, $this->grant->manager);

            // if already exists, print error
            if($oAd->isExists() && $oAd->document_srl == $obj->document_srl) {
				return new Object(-1, 'msg_invalid_request');
            // else
            } else {
				// insert document
                $output = $oDocumentController->insertDocument($obj);
                $msg_code = 'success_registed';
                $obj->document_srl = $output->get('document_srl');

				// 오류 발생시 멈춤
				if(!$output->toBool()) return $output;

				// insert ad
				$ad->module_srl = $obj->module_srl;
				$ad->document_srl = $obj->document_srl;
				$ad->ad_time = $obj->ad_time;
				$ad->url = $obj->url;
				$ad->url_target = $obj->url_target;
				$ad->style = $obj->used_style;
				$ad->start_date = date('YmdHis');
				$output = $this->insertAd($ad);
				if(!$output->toBool()) return $output;

				// subtract the point (except the notice)
				if($ad_point>0 && $obj->is_notice !='Y') $oPointController->setPoint($logged_info->member_srl, $ad_point, 'minus');
            }

            // return the result
            $this->add('mid', Context::get('mid'));

            // set success message
            $this->setMessage($msg_code);
		}

		/**
		 * @brief insert Ad
		 **/
		function insertAd($args) {
			// check $args
			if(!$args || !$args->document_srl) return;
			$args->ad_time = (int)$args->ad_time;
			if($this->module_info->use_time == 'Y' && !$args->ad_time) return new Object(-1, 'msg_input_ad_time');
			if($this->module_info->use_time != 'Y') $args->ad_time = -1;

			// module srl
			$module_srl = $args->module_srl;
			unset($args->module_srl);

			// create model object of ad module
			$oAdModel = &getModel('ad');

			// set end date
			if($this->module_info->use_time == 'Y' && $args->ad_time != -1) $args->end_date = date('YmdHis',$oAdModel->dateAdd('h',$args->ad_time,time()));
			else $args->end_date = -1;

			// set default value
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';
			if(!$args->start_date) $args->start_date = date('YmdHis');

			// execute query
			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);
			unset($obj);

			// cache file update
			$this->updateListCache($module_srl);

			return $output;
		}

		/**
		 * @brief insert Notice
		 **/
		function insertNotice($args) {
			if(!$args || !$args->document_srl) return;

			// create model object of ad module
			$oAdModel = &getModel('ad');

			$oAd = $oAdModel->getAd($args->document_srl, $this->grant->manager);

			// check $args
			$args->ad_time = (int)$args->ad_time;
			$args->start_date = trim($args->start_date);
			$args->start_hour = (int)trim($args->start_hour);
			$args->start_minute = (int)trim($args->start_minute);
			$args->start_second = (int)trim($args->start_second);
			if(!$args->ad_time) $args->ad_time = -1;
			if(!$args->start_hour) $args->start_hour = '00';
			if(!$args->start_minute) $args->start_minute = '00';
			if(!$args->start_second) $args->start_second = '00';
			if(strlen($args->start_hour)<2) $args->start_hour .= '0';
			if(strlen($args->start_minute)<2) $args->start_minute .= '0';
			if(strlen($args->start_second)<2) $args->start_second .= '0';

			// set end date
			if(!$args->start_date) {
				if($args->ad_time != -1) $args->end_date = $oAdModel->dateAdd('h',$args->ad_time,date('YmdHis'));
				else $args->end_date = -1;
			} else {
				$args->end_date = $oAdModel->dateAdd('h',$args->ad_time,$args->start_date.$args->start_hour.$args->start_minute.$args->start_second);
			}

			// set default value
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';

			// executeQuery
			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);

			unset($obj);

			// cache file update
			$this->updateListCache($module_srl);

			return $output;
		}

		/**
		 * @brief delete Ad
		 **/
		function deleteAd($document_srl, $delete_document = true, $return_point = true) {
			if(!$document_srl) return;

			$obj->document_srl = $document_srl;

			// create model class of ad module
			$oAdModel = &getModel('ad');

			// create model class of document model
			$oDocumentModel = &getModel('document');

			// get document info
			$oDocument = $oDocumentModel->getDocument($document_srl, $this->grant->manager);

			// if document doesn't exists, return error
			if(!$oDocument->isExists()) return new Object(-1, 'msg_not_exists_ad');

			// delete document
			if($delete_document) {
				$oDocumentController = &getController('document');
				$oDocumentController->deleteDocument($document_srl);
			}

			// executeQuery
			$output = executeQuery('ad.deleteAd', $obj);

			// return point
			$return_point = false;
			if($return_point) {
				$oAd = $oAdModel->getAd($document_srl, $this->grant->manager);
				$remaining = $oAd->getRemainingTime(true);
				$days = (int)days_in_month(date('m'),date('Y'));

				$round = sec_round_to_min($remaining['second']);
				$remaining['second'] = $round['sec'];
				$remaining['minute'] = $round['min'];
				$round = min_round_to_hour($remaining['second']);
				$remaining['minute'] = $round['min'];
				$remaining['hour'] = $round['hour'];
				$remaining['hour'] = day_to_hour($remaining['day']);
				$remaining['day'] = 0;
			}

			// cache file update
			$this->updateListCache($oDocument->get('module_srl'));

			return $output;
		}

		/**
		 * @brief linead module convert to ad module
		 **/
		function updateModule() {
			$args->old_module = 'linead';
			$args->new_module = 'ad';
			return executeQuery('ad.updateOldModule',$args);
		}

		/**
         *
         * @brief ad time notify trigger
		 * @return new Object
         **/
        function triggerNotifyAdTime() {
			// if not logged
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return new Object();

			// 특정 모듈이면 종료
			if(in_array(Context::get('module'),array('addon','admin','widget','editor'))) return new Object();

			// 특정 action이면 종료
			/*$notNotifyAction = array();
			if(in_array(Context::get('act'),$notNotifyAction) || strpos(Context::get('act'),'dispAdAdmin')) return new Object();*/

			// create model object of ad module
			$oAdModel = &getModel('ad');

			// create controller object of communication module
			$oCommunicationController = &getController('communication');

			// get notify module list
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			if(!file_exists($cache_filename)) {
				$query = $oAdModel->getNotifyModuleSrls();
				if(!$query->toBool() || !$query->data) return new Object();

				foreach($query->data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

				$module_srls = join(',',$module_srls);

				// set cache
				FileHandler::writeFile($cache_filename, $module_srls);
			} else {
				$module_srls = trim(FileHandler::readFile($cache_filename));
			}

			// if not exists notify module, return new Object
			if(!$module_srls) return new Object();

			// get notify ad list
			$cache_filename = sprintf('./files/cache/ad/%snotify_ad.cache.txt', getNumberingPath($member_srl));

			// debug mode (true :enable, false : disable)
			$debug_mode = false;

			// if exists cache file, read cache file or find from db
			if(!file_exists($cache_filename) || (file_exists($cache_filename) && date('YmdHis',filemtime($cache_filename))+60*60 < date('YmdHis')) || $debug_mode) {
				$args->module_srl = $module_srls;
				$args->member_srl = $logged_info->member_srl;
				$args->end_date = date('YmdHis');
				$args->is_notice = 'N';
				$query = $oAdModel->getAdNotifyList($args);
				$notify_list = $query->data;

				// write cache file
				FileHandler::writeFile($cache_filename, serialize($query));

				// 오류가 발생하거나 알림 대상 목록 결과가 없으면 종료
				if(!$query->toBool() || !$query->data) return new Object();
			} else {
				// read cache file
				$query = unserialize(FileHandler::readFile($cache_filename));
				$notify_list = $query->data;
			}

			// 알림 대상 목록 결과가 있으면 쪽지 보내기
			if($notify_list && count($notify_list)) {
				$member_srl = $logged_info->member_srl;
				$user_name = $logged_info->user_name;
				$nick_name = $logged_info->nick_name;

				// get admin member srl
				$admin = $oAdModel->getAdminMemberSrl();

				// get title and content of message
				$title = Context::getLang('notify_title');
				$content = Context::getLang('notify_content');
				foreach($notify_list as $key => $val) {
					// set message title / content
					$title = $title['typeA'];
					$content = sprintf($content['typeA'],$nick_name,$nick_name,$val->getAdContent(),zdate($val->get('regdate')),zdate($val->get('end_date')));
					// send message
					$oCommunicationController->sendMessage($admin, $member_srl, $title, $content, false);
					// delete ad
					$this->deleteAd($val->document_srl, true, false);
				}
				// cache file update
				FileHandler::writeFile($cache_filename, 'N;');
			}
			return new Object();
		}

        /**
         * @brief 모듈이 삭제될때 등록된 모든 광고를 삭제하는 trigger
		 * @return new Object
         **/
        function triggerDeleteModuleAds(&$obj) {
            $module_srl = $obj->module_srl;
            if(!$module_srl) return new Object();

			// create model class of ad module
			$oAdModel = &getModel('ad');

            // 등록된 광고 목록 구하기 (delete 쿼리가 다중 테이블 select를 지원하지 않아서 어쩔 수 없음)
			$args->module_srl = $module_srl;
			$args->no_page = 'Y';
			$args->select_document_srl = 'Y';
			$args->is_notice = 'N';
			$output = $oAdModel->getAdList($args);
			if(!$output->toBool()) return $output;

			unset($args);

			if($output->data) {
				foreach($output->data as $key => $val) $documents[] = $val->document_srl;

				// delete cache file
				$this->deleteModuleCache($val->get('module_srl'));

				// delete ad
				$args->document_srls = join(',',$documents);
				$output = executeQuery('ad.deleteModuleAds',$args);
			    if(!$output->toBool()) return $output;
			}

            // cache file update
			$this->updateNotifyModuleCache();

            return new Object();
        }

        /**
         * @brief insert statistics
         **/
		function insertStatistics($obj) {
		}

        /**
         * @brief updateNotifyModuleCache
		 *	 @return none
         **/
		function updateNotifyModuleCache() {
			// create model class of ad module
			$oAdModel = &getModel('ad');

			$output = $oAdModel->getNotifyModuleSrls();
			if(!$output->toBool() || !$output->data) $output->data = '';

			foreach($output->data as $key => $val) if($val->value == 'Y') $modules[] = $val->module_srl;

			$modules = join(',',$modules);

			FileHandler::writeFile('./files/cache/ad/notify_modules.cache.txt', $modules);
		}

        /**
         * @brief updateListCache
		 *	 @return none
         **/
		function updateListCache($module_srl) {
			// create model class of ad module
			$oAdModel = &getModel('ad');

			$args->end_date = date('YmdHis');
			$args->module_srl = $module_srl;
			$args->no_page = 'Y';

			$output = $oAdModel->getAdList($args);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($output->data)));
		}

        /**
         * @brief initListCache
		 *	 @return none
         **/
		function initListCache($module_srl) {
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, 'N;');
		}

        /**
         * @brief deleteModuleCache
		 *	 @return none
         **/
		function deleteModuleCache($module_srl) {
			// delete cache file
			FileHandler::removeDir(sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl)));
		}

        /**
         * @brief deleteNotifyModuleCache
		 *	 @return none
         **/
		function deleteNotifyModuleCache() {
			// delete cache file
			FileHandler::removeFile('./files/cache/ad/notify_modules.cache.txt');
		}

        /**
         * @brief deleteAllCache
		 *	 @return none
         **/
		function deleteAllCache() {
			// delete cache file
			FileHandler::removeDir('./files/cache/ad/');
		}
    }
?>
