<?php
    /**
     * @class  adItem
     * @author SMaker (dowon2308@paran.com)
     * @brief  item class of ad module
     **/

    require_once(_XE_PATH_.'modules/document/document.item.php');

    class AdItem extends documentItem {

        
        function AdItem($document_srl = 0) {
            $this->document_srl = $document_srl;
            $this->_loadFromDB();
        }

        function setAd($document_srl) {
            $this->document_srl = $document_srl;
            $this->_loadFromDB();
        }

        function _loadFromDB() {
            $obj->document_srl = $this->document_srl;
            $output = executeQuery('ad.getAd', $obj);
            if(!$output->toBool()) return;

            $this->setAttribute($output->data);
        }

        function setAttribute($attribute) {
            $this->document_srl = $attribute->document_srl;
            $this->adds($attribute);

			$GLOBALS['__AdItem__'][$this->document_srl] = $this;
        }

		/**
		 * @brief return ad content (only text)
		 */
		function getAdContentText($cut_size = 0) {
			return parent::getTitleText($cut_size);
		}

		/**
		 * @brief 광고 내용에 스타일을 적용하여 출력
		 */
		function getAdContent($cut_size = 0, $hyperlink = false) {
			// get content and style list
			$content = $this->getAdContentText($cut_size);
			$style = $this->getStyleList();

			// if exists applied style, apply
			if(count($style)) {

				// get text color and background color
				foreach($style as $key => $val) {
					if(strpos($val,'text_') !== false) {
						$textcolor = str_replace('text_','',$val);
						unset($val);
						continue;
					} elseif(strpos($val,'bg_') !== false) {
						$bgcolor = str_replace('bg_','',$val);
						unset($val);
						continue;
					} else {
						switch($val) {
							case 'bold':
								$content = sprintf('<strong>%s</strong>',$content);
								break;
							case 'underline':
								$content = sprintf('<u>%s</u>',$content);
								break;
							case 'italic':
								$content = sprintf('<i>%s</i>',$content);
								break;
						}
					}
				}

				if($textcolor || $bgcolor) {
					$span = '<span style="';
					if($textcolor) $span .= sprintf('color:%s;',$textcolor);
					if($bgcolor) $span .= sprintf('background-color:%s;',$bgcolor);
					$span .= sprintf('">%s</span>',$content);
					$content = sprintf($span,$content);
				}
			}

			// if apply the link, wrap to 'a' tag
			if($hyperlink && $this->getUrl()) $content = sprintf('<a href="" target="">%s</a>',$this->getUrl(),$content,$this->getUrlTarget());

			return $content;
		}

		/**
		 * @brief return URL
		 * @return url
		 */
		function getUrl() {
			return addslashes(htmlspecialchars($this->get('url')));
		}

		/**
		 * @brief return URL open target
		 *	 @return URL target
		 */
		function getUrlTarget() {
			return $this->get('url_target');
		}

		/**
		 * @brief return remaining time
		 *	 @return array or string
		 **/
		function getRemainingTime($only_diff = false) {
			if($this->get('end_date')<date('YmdHis')) return false;

			// create model class of ad module
			$oAdModel = &getModel('ad');

			$diff = $oAdModel->dateDiff(date('Y-m-d H:i:s'), zdate($this->get('end_date'), 'Y-m-d H:i:s'));
			if($only_diff) return $diff;

			$time = Context::getLang('time_word');
			return $diff['month'].$time['month'].' '.$diff['day'].$time['day'].' '.$diff['hour'].$time['hour'].' '.$diff['minute'].$time['minute'].' '.$diff['second'].$time['second'];
		}


		/**
		 * @brief return applied text color
		 *	 @return text color
		 */
		function getTextColor() {
			// get applied style list
			$style = $this->getStyleList();

			if(!count($style)) return false;

			// extract the text color from style list
			foreach($style as $key => $val) if(strpos($val,'text_')) return str_replace('text_','',$val);

			return false;
		}

		/**
		 * @brief return applied background color
		 *	 @return background color
		 */
		function getBgColor() {
			// get applied style list
			$style = $this->getStyleList();

			if(!count($style)) return false;

			// extract the background color from style list
			foreach($style as $key => $val) if(strpos($val,'bg_')) return str_replace('bg_','',$val);

			return false;
		}

		/**
		 * @brief 적용된 스타일(굵기, 밑줄, 기울임꼴, 글자색, 배경색) 목록을 반환
		 */
		function getStyle(){
			return str_replace('|@|',',',$this->get('style'));
		}

		/**
		 * @brief 적용된 스타일(굵기, 밑줄, 기울임꼴, 글자색, 배경색) 목록을 배열로 반환
		 */
		function getStyleList(){
			return explode('|@|',$this->get('style'));
		}
    }
?>
