<?php
    /**
     * @class  ad
     * @author SMaker (dowon2308@paran.com)
     * @brief  base class of ad module
     **/

    class ad extends ModuleObject {

        // search option for admin page
        var $search_option = array('content','user_id','member_srl','user_name','nick_name','is_notice','tags','click_count','regdate','ipaddress');

        /**
         * @brief install ad module
		 * @return new Object
         **/
        function moduleInstall() {
			$oModuleController = &getController('module');
			$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');
			$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');

			return new Object();
        }

        /**
         * @brief if update is necessary it returns true 
         **/
        function checkUpdate() {
			$oDB = &DB::getInstance();
			$oAdModel =  &getModel('ad');

			// check field missing
			if(!$oDB->isColumnExists('ad', 'start_date')) return true;
			if(!$oDB->isColumnExists('ad', 'style')) return true;

			if(!file_exists(_XE_PATH_.'files/cache/ad/updated')) {
				// check old linead module info
				 if(is_object($oAdModel->getOldConfig())) return true;

				// check old linead module
				if($oAdModel->isExistsOldModule()) return true;
			}

			// check trigger
            $oModuleModel = &getModel('module');
			if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after')) return true;
			if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before')) return true;

			return false;
        }

        /**
         * @brief update module
		 * @return new Object
         **/
        function moduleUpdate() {
			$oDB = &DB::getInstance();
			$oAdModel = &getModel('ad');
			$oAdController = &getController('ad');
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');

			// check field missing
			if(!$oDB->isColumnExists('ad', 'start_date')) {
				$oDB->addColumn('ad', 'start_date', 'date', '', '');
				$oDB->addIndex('ad', 'idx_start_date', 'start_date');
			}

			if(!$oDB->isColumnExists('ad', 'style')) $oDB->addColumn('ad', 'style', 'text', '', '');

			// if exists old linead module info, execute update
			if(!file_exists(_XE_PATH_.'files/cache/ad/updated')) {
				$old_config = $oAdModel->getOldConfig();
				if($old_config) {
					// first, save the old module config
					$module_srl = $OldConfig->module_srl;

					// change old linead module to ad module
					$oAdController->updateModule();

					// save need config.
					$config_args->ad_point = $OldConfig->ad_point;
					$config_args->daily_limit = $OldConfig->daily_limit;
					$oModuleController->insertModulePartConfig('ad',$module_srl,$config_args);

					// delete old config
					$args->module = 'linead';
			        $output = executeQuery('module.deleteModuleConfig', $args);
				    if(!$output->toBool()) return $output;

					// write cache file
					$cache_path ='./files/cache/ad/updated';
					FileHandler::writeFile($cache_path, 'Y');
			}

			if(!file_exists(_XE_PATH_.'files/cache/ad/updated') && $oAdModel->isExistsOldModule()) $oAdController->updateModule();
		}

		// trigger for ad notify feature
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after'))
			$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');

		// trigger for delete ads
		if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before'))
			$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');

			return new Object(0,'success_updated');
        }

        /**
         * @brief regenerate cache file
		 * @return none
         **/
        function recompileCache() {
			// delete all cache
			$oAdController = &getController('ad');
			$oAdController->deleteAllCache();
        }
    }

	/**
	 * @brief print ad image function
	 */
	 function XE_ad_image($document_srl = 0, $width = 100, $height = 100) {
	 }

	/**
	 * @brief print ad content function
	 */
	 function XE_ad_content($document_srl = 0, $content_size = 20) {
	 }

	if(!function_exists('date_parse')) {
		function date_parse($date) {
			$date = getdate(strtotime($date));
			return array(
					'second' => $date['seconds'],
					'minute' => $date['minutes'],
					'hour' => $date['hours'],
					'month' => $date['mon'],
					'year' => $date['year']
				);
		}
	}

	if(!function_exists('cal_days_in_month')) {
		function cal_days_in_month($calendar = '', $month , $year) {
			if(checkdate($month, 31, $year)) return 31;
			if(checkdate($month, 30, $year)) return 30;
			if(checkdate($month, 29, $year)) return 29;
			if(checkdate($month, 28, $year)) return 28;
		}
	}

	function days_in_month($month, $year) {
		return $month == 2 ? ($year % 4 ? 28 : ($year % 100 ? 29 : ($year % 400 ? 28 : 29))) : (($month - 1) % 7 % 2 ? 30 : 31); 
	} 

	if(!function_exists('htmlspecialchars_decode')) {
		function htmlspecialchars_decode ($str, $quote_style = ENT_COMPAT) {
			return strtr($str, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $quote_style)));
		}
	}

	function sec_round_to_min($sec) {
		$min = 0;
		if($sec>=30) {
			while($sec>=30) {
				$sec -= 30;
				$min += 1;
			}
		}

		return array('sec' => $sec, 'min' => $min);
	}

	function min_round_to_hour($min) {
		$hour = 0;
		if($min>=30) {
			while($min>=30) {
				$min -= 30;
				$hour += 1;
			}
		}

		return array('min' => $min, 'hour' => $hour);
	}

	function sec_to_min($sec) {
		return (int)$sec / 60;
	}

	function min_to_hour($min) {
		return (int)$min / 60;
	}

	function day_to_hour($day) {
		return (int)$day * 24;
	}
?>
