<?php
    /**
     * @class  adView
     * @author SMaker (dowon2308@paran.com)
     * @brief  view class of ad module
     **/

    class adView extends ad {

        /**
         * @brief init
         **/
        function init() {
			// create model class of ad module
			$oAdModel = &getModel('ad');
			Context::set('oAdModel',$oAdModel);

            // set skin path
            $template_path = sprintf('%sskins/%s/',$this->module_path, $this->module_info->skin?$this->module_info->skin:'xe_default');
            if(!is_dir($template_path)) {
                $this->module_info->skin = 'xe_default';
                $template_path = sprintf('%sskins/%s/',$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);

			// common js file load
			Context::addJsFile($this->module_path.'tpl/js/ad.js');

			// get ad time range
			$ad_time_range = $oAdModel->getAdTimeRange($this->module_info);
			Context::set('ad_time_range', $ad_time_range);
        }

        /**
         * @brief 광고 컨텐츠 출력
         **/
        function dispAdContent() {
			// create model class of ad module
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->order_type = 'asc';
			$args->end_date = date('YmdHis');

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('ad_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('content');
        }

        /**
         * @brief 광고 등록
         **/
        function dispAdRegister() {
			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'documents.list_order';
            $args->order_type = 'asc';

			// apply javascript filter
			Context::AddJsFilter($this->module_path.'tpl/filter', 'register_ad.xml');

            $this->setTemplateFile('register');
        }

        /**
         * @brief 사용자 광고 목록
         **/
        function dispAdList() {
			// create model class of ad module
			$oAdModel = &getModel('ad');

			// get logged info
			$logged_info = Context::get('logged_info');

			// 로그인 상태가 아니라면 에러
			if(!$logged_info) return new Object(-1, 'msg_please_login');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;
			$args->member_srl = $logged_info->member_srl;

            // for search, sort
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'documents.list_order';
            $args->order_type = 'asc';
			$args->end_date = date('YmdHis');

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('ad_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('list');
        }
    }
?>
