<?php
    /**
     * @class  adModel
     * @author SMaker (dowon2308@paran.com)
     * @brief model class of ad module
     **/

	/**
	 * @brief load ad item object
	 */
	require_once(_XE_PATH_.'modules/ad/ad.item.php');

    class adModel extends ad {

        /**
         * @brief init
         **/
        function init() {
        }

        /**
         * @brief get default config of ad module
         **/
        function getConfig() {
            static $module_info = null;
            if(is_null($module_info)) {
                // get module config (use module model)
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('ad');
				if(!isset($module_info->display_today_ad)) $module_info->display_today_ad  = 'Y';
				if(!isset($module_info->use_help)) $module_info->use_help  = 'Y';

                unset($module_info->grants);
            }
            return $module_info;
        }

        /**
		 * @brief get old module Config (for old version update)
         **/
        function getOldConfig() {
            static $module_info = null;
            if(is_null($module_info)) {
                // module module_info의 값을 구함
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('linead');

                unset($module_info->grants);
            }
            return $module_info;
        }

        /**
         * @brief check old module exists (for old version update)
         **/
        function isExistsOldModule() {
			$output = executeQuery('ad.getOldModule');
			if(count($output->data)) return true;
			return false;
        }

		/**
		 * @brief get ad item object
		 * @return ad item object
		 **/
        function getAd($document_srl = 0) {
            if(!$document_srl) return new AdItem();

            if(!isset($GLOBALS['__AdItem__'][$document_srl])) {
                $oAd = new AdItem($document_srl);
                $GLOBALS['__AdItem__'][$document_srl] = $oAd;
            }

            return $GLOBALS['__AdItem__'][$document_srl];
        }

        /**
		 * @brief get multiple ads.
		 * @return ad item object
         **/
        function getAds($document_srls, $is_admin = false) {
            if(is_array($document_srls)) {
                $list_count = count($document_srls);
                $document_srls = implode(',',$document_srls);
            } else {
                $list_count = 1;
            }
            $args->document_srls = $document_srls;
            $args->list_count = $list_count;
            $args->order_type = 'asc';

            $output = executeQuery('ad.getAds', $args);
            $document_list = $output->data;
            if(!$document_list) return;
            if(!is_array($document_list)) $document_list = array($document_list);

            $document_count = count($document_list);
            foreach($document_list as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                if(!$document_srl) continue;

                if(!$GLOBALS['XE_AD_LIST'][$document_srl]) {
                    $oAd = null;
                    $oAd = new AdItem();
                    $oAd->setAttribute($attribute, false);
                    $GLOBALS['XE_AD_LIST'][$document_srl] = $oAd;
                }

                $result[$attribute->document_srl] = $GLOBALS['XE_AD_LIST'][$document_srl];
            }

            $output = null;
            if(count($result)) {
                foreach($result as $document_srl => $val) {
                    $output[$document_srl] = $GLOBALS['XE_AD_LIST'][$document_srl];
                }
            }

            return $output;
        }

		/**
		 * @brief get ad list
		 **/
        function getAdList($obj) {
            // set default query id
            $query_id = 'ad.getAdList';

            // module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
            if($obj->mid) {
                $oModuleModel = &getModel('module');
                $obj->module_srl = $oModuleModel->getModuleSrlByMid($args->mid);
                unset($args->mid);
            }

            // 넘어온 module_srl은 array일 수도 있기에 array인지를 체크
            if(is_array($obj->module_srl)) $args->module_srl = implode(',', $obj->module_srl);
			else $args->module_srl = $obj->module_srl;

			if($args->no_page == 'Y') {
				// if not use page feature, change query id
				$query_id = 'ad.getAdListNoPage';
			} else {
	            $args->page = $obj->page?$obj->page:1;
		        $args->list_count = $obj->list_count?$obj->list_count:20;
			    $args->page_count = $obj->page_count?$obj->page_count:10;
			}

			$args->member_srl = $obj->member_srl;
			$args->start_date = $obj->start_date;
			$args->start_regdate = $obj->start_regdate;
			$args->end_regdate = $obj->end_regdate;
			$args->end_date = $obj->end_date;
			$args->is_notice = $obj->is_notice;

            // search option 검색 옵션 정리
            $search_target = $obj->search_target;
            $search_keyword = $obj->search_keyword;
            if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'content' :
                        if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                        $args->s_content = $search_keyword;
                        break;
                }
            }

			// document srl만 뽑아올 경우 query id 변경
			if($obj->select_document_srl == 'Y') {
				switch($query_id) {
					case 'ad.getAdList':
						$query_id = 'ad.getAdListSelectDocumentSrl';
						break;
					case 'ad.getAdListNoPage':
						$query_id = 'ad.getAdListNoPageSelectDocumentSrl';
						break;
				}
			}

			if($obj->select_all_ad == 'Y') {
				switch($query_id) {
					case 'ad.getAdList':
						$query_id = 'ad.getAllAdList';
						break;
					case 'ad.getAdListNoPage':
						$query_id = 'ad.getAllAd';
						break;
					case 'ad.getAdListSelectDocumentSrl':
						$query_id = 'ad.getAllAdListSelectDocumentSrl';
						break;
					case 'ad.getAdListNoPageSelectDocumentSrl':
						$query_id = 'ad.getAllAdSelectDocumentSrl';
						break;
				}
			}

			$output = executeQueryArray($query_id, $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            $idx = 0;
            $data = $output->data;
            unset($output->data);

            $keys = array_keys($data);
            $virtual_number = $keys[0];

            foreach($data as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                $oAd = null;
                $oAd = new AdItem();
                $oAd->setAttribute($attribute);

                $output->data[$virtual_number] = $oAd;
                $virtual_number --;
            }

            return $output;
        }

		/**
		 * @brief get ad notify List
		 **/
        function getAdNotifyList($obj) {
            // 기본으로 사용할 query id 지정 (몇 가지 검색 옵션에 따라 query id 변경됨)
            $query_id = 'ad.getAdNotifyList';

            // module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
            if($obj->mid) {
                $oModuleModel = &getModel('module');
                $obj->module_srl = $oModuleModel->getModuleSrlByMid($args->mid);
                unset($args->mid);
            }

            // 넘어온 module_srl은 array일 수도 있기에 array인지를 체크
            if(is_array($obj->module_srl)) $args->module_srl = implode(',', $obj->module_srl);
			else $args->module_srl = $obj->module_srl;

			$args->member_srl = $obj->member_srl;
			$args->start_date = $obj->start_date;
			$args->end_date = $obj->end_date;
			$args->is_notice = $obj->is_notice;

            // 검색 옵션 정리
            if($obj->search_target) {
                switch($obj->search_target) {
                    case 'content' :
                        if($args->search_keyword) $args->search_keyword = str_replace(' ','%',$args->search_keyword);
                        $args->s_content = $args->search_keyword;
                        break;
                }
            }

			$output = executeQueryArray($query_id, $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            $idx = 0;
            $data = $output->data;
            unset($output->data);

            $keys = array_keys($data);
            $virtual_number = $keys[0];

            foreach($data as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                $oAd = null;
                $oAd = new AdItem();
                $oAd->setAttribute($attribute);

                $output->data[$virtual_number] = $oAd;
                $virtual_number --;
            }

            return $output;
        }

        /**
         * @brief module_srl에 해당 하는 광고의 전체 갯수를 가져옴
         **/
        function getAdCount($module_srl, $search_obj = NULL) {
            // 검색 옵션 추가
            $args->module_srl = $module_srl;
            $args->s_content = $search_obj->s_content;
            $args->s_member_srl = $search_obj->s_member_srl;
			$args->is_notice = $search_obj->is_notice;
			$args->start_date = $search_obj->start_date;

            $output = executeQuery('ad.getAdCount', $args);

            // 전체 갯수를 return
            $total_count = $output->data->count;
            return (int)$total_count;
        }

		/**
		 * @brief date add
		 * @return timestamp
		 **/
		function dateAdd($interval, $number, $date) {
			$date_time_array = getdate($date);
		    $hours = $date_time_array['hours'];
		    $minutes = $date_time_array['minutes'];
		    $seconds = $date_time_array['seconds'];
		    $month = $date_time_array['mon'];
		    $day = $date_time_array['mday'];
		    $year = $date_time_array['year'];

	    switch ($interval) {
            case 'yyyy':
		        $year+=$number;
	            break;
		    case 'q':
			    $year+=($number*3);
				break;
	        case 'm':
		        $month+=$number;
			    break;
	        case 'y':
		    case 'd':
			case 'w':
	            $day+=$number;
		        break;
	        case 'ww':
		        $day+=($number*7);
			    break;
	        case 'h':
		        $hours+=$number;
			    break;
	        case 'n':
		        $minutes+=$number;
			    break;
	        case 's':
		        $seconds+=$number; 
			    break;            
			}

		    return mktime($hours,$minutes,$seconds,$month,$day,$year);
		}

		/**
		 * @brief date subtract
		 * @return timestamp
		 **/
		function dateSubtract($interval, $number, $date) {
			$date_time_array = getdate($date);
		    $hours = $date_time_array['hours'];
		    $minutes = $date_time_array['minutes'];
		    $seconds = $date_time_array['seconds'];
		    $month = $date_time_array['mon'];
		    $day = $date_time_array['mday'];
		    $year = $date_time_array['year'];

	    switch ($interval) {
            case 'yyyy':
		        $year-=$number;
	            break;
		    case 'q':
			    $year-=($number*3);
				break;
	        case 'm':
		        $month-=$number;
			    break;
	        case 'y':
		    case 'd':
			case 'w':
	            $day-=$number;
		        break;
	        case 'ww':
		        $day-=($number*7);
			    break;
	        case 'h':
		        $hours-=$number;
			    break;
	        case 'n':
		        $minutes-=$number;
			    break;
	        case 's':
		        $seconds-=$number; 
			    break;            
			}

		    return mktime($hours,$minutes,$seconds,$month,$day,$year);
		}

		/**
		 * @brief compare the two dates
		 * @return array
		 **/
		function dateDiff($startDate, $endDate) {
			$startTime = strtotime($startDate);
			$endTime = strtotime($endDate);

			if($startTime > $endTime) return false;

			$diffTime = $endTime - $startTime;
			
			$startDateParse = date_parse($startDate);
			$endDateParse = date_parse($endDate);
			$maxDay = cal_days_in_month(CAL_GREGORIAN,$startDateParse['month'],$startDateParse['year']);

			$diffDate['month'] = floor($diffTime/60/60/24/31);
			$diffDate['day'] = floor($diffTime/60/60/24);
			$diffDate['hour'] = sprintf("%02d", ($diffTime/60/60)%24);
			$diffDate['minute'] = sprintf("%02d", ($diffTime/60)%60);
			$diffDate['second'] = sprintf("%02d", ($diffTime)%60);

			return $diffDate;
		}


		function getDefaultAdTimeRange() {
			return '5, 10, 15, 20';
		}

		function getDefaultAdTimeRangeArray() {
			return array(5, 10, 15, 20);
		}

		/**
		 * @brief 광고 시간 범위에 포인트 정보까지 추가하여 return
		 **/
		function getAdTimeRange($module_info = null) {
			if($module_info->use_time != 'Y') return;

			$ad_time_range = explode(',', $module_info->ad_time_range?$module_info->ad_time_range:$this->getDefaultAdTimeRange());
			$ad_point = $module_info->ad_point;
			$ad_point_rate = $module_info->ad_point_rate;
			$time_word = Context::getLang('time_word');

			$range = array();

			foreach($ad_time_range as $key => $val) {
				$range[$key]['time'] = $val;
				$range[$key]['title'] = sprintf('%s%s (%s %s)', $range[$key]['time'], $time_word['hour'], (int)$range[$key]['time'] / $ad_point_rate * $ad_point, '포인트');
			}

			return $range;
		}

		/**
		 * @brief 최고 관리자의 회원 번호를 구함
		 */
		function getAdminMemberSrl() {
			$output = executeQuery('ad.getAdminMemberSrl');
			return $output->data->member_srl;
		}

		/**
		 * @brief 알림 대상 모듈 번호 구하기
		 */
		function getNotifyModuleSrls() {
			$output = executeQueryArray('ad.getNotifyModuleSrls');
			return $output;
		}

		/**
		 * @brief 모듈 버전 구함
		 */
		function getVersion() {
			$oModuleModel = &getModel('module');
			$xml_info = $oModuleModel->getModuleInfoXml('ad');
			return $xml_info->version;
		}

		/**
		 * @brief 모듈 버전을 구해서 이미지로 반환 (working)
		 */
		function getVersionImg() {
/*			$version = $this->getVersion();
			$chars = array(
				'.' => array('file' => 'dot.gif', 'width'=> 2),
				'0' => array('file' => '0.gif', 'width' => 6),
				'1' => array('file' => '1.gif', 'width' => 6),
				'2' => array('file' => '2.gif', 'width' => 6),
				'3' => array('file' => '3.gif', 'width' => 6),
				'4' => array('file' => '4.gif', 'width' => 6)
			);

			foreach($chars as $key => $val) {
				$pattern = '/^[0-9]+(.[0-9])';
				$img = sprintf('<img src="img/chars/%s" width="%s" height="5" />', $val['file'], $val['width']);
				$version = preg_replace($pattern, $img, $version);
			}

			return $version;
*/
		}
    }
?>
