<?php
    /**
     * @class  A\adAdminController
     * @author SMaker (dowon2308@paran.com)
     * @brief  admin controller class of ad module
     **/

    class adAdminController extends ad {

        /**
         * @brief init
         **/
        function init() {
        }

		/**
		 * @brief 기본 설정 > 저장
		 **/
		function procAdAdminInsertConfig() {
			$config = Context::getRequestVars();

			$oModuleController = &getController('module');
	        $oModuleController->insertModuleConfig('ad', $config);

			$this->setMessage('success_saved');
        }

        /**
         * @brief 광고 모듈 추가
         **/
        function procAdAdminInsertModule($args = null) {
            // module 모듈의 model/controller 객체 생성
            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');

            // 광고 모듈의 정보 설정
            $args = Context::getRequestVars();
            $args->module = 'ad';
            $args->mid = $args->mid;
			if(!$args->mid) $args->mid = $args->connect_url;
            unset($args->connect_url);

            // 기본 값외의 것들을 정리
            if($args->ad_point<1) $args->ad_point = 0;
            if($args->daily_limit<1) $args->daily_limit = 0;
			if($args->use_notify != 'Y') $args->use_notify = 'N';

            // module_srl이 넘어오면 원 모듈이 있는지 확인
            if($args->module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
                if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
            }

            // module_srl의 값에 따라 insert/update
            if(!$args->module_srl) {
                $output = $oModuleController->insertModule($args);
                $msg_code = 'success_registed';
            } else {
                $output = $oModuleController->updateModule($args);
                $msg_code = 'success_updated';
            }

            if(!$output->toBool()) return $output;

			// 캐시 설정
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			// 알림 설정이 바뀌었을 경우 캐시 파일 업데이트
			if($module_info->use_notify && $module_info->use_notify != $args->use_notify) {
				$modules = $oAdModel->getNotifyModules();

				$data = $modules->data; 

				if($data) {
					foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

					$module_srls = join(',',$module_srls);

					// 폴더가 없으면 생성
					if(!is_dir($cache_path)) FileHandler::makedir($cache_path);

					// 캐시 설정
					FileHandler::writeFile($cache_filename, $module_srls);
				}
			}

            $this->add('page',Context::get('page'));
            $this->add('module_srl',$output->get('module_srl'));
            $this->setMessage($msg_code);
        }

        /**
         * @brief 광고 모듈 삭제
         **/
        function procAdAdminDeleteModule() {
            $module_srl = Context::get('module_srl');

            // 원본을 구해온다
            $oModuleController = &getController('module');
            $output = $oModuleController->deleteModule($module_srl);
            if(!$output->toBool()) return $output;

            $this->add('module','ad');
            $this->add('page',Context::get('page'));
            $this->setMessage('success_deleted');
        }

        /**
         * @brief 관리자 페이지에서 선택된 광고들을 삭제
         **/
        function procAdAdminDeleteChecked() {

            // 선택된 광고가 없으면 오류 표시
            $cart = Context::get('cart');
            if(!$cart) return $this->stop('msg_cart_is_null2');
            $document_srl_list= explode('|@|', $cart);
            $ad_count = count($document_srl_list);
            if(!$ad_count) return $this->stop('msg_cart_is_null2');

            $oAdController = &getController('ad');

            $deleted_count = 0;

            // 광고 삭제
            for($i=0;$i<$ad_count;$i++) {
                $document_srl = trim($document_srl_list[$i]);
                if(!$document_srl) continue;

                $output = $oAdController->deleteAd($document_srl, true, false);
                if(!$output->toBool()) continue;

                $deleted_count ++;
            }

            $this->setMessage(sprintf(Context::getLang('msg_checked_ad_is_deleted'), $deleted_count));
        }

        /**
         * @brief 공지 등록
         **/
		function procAdAdminNoticeWrite() {
            // 권한 체크
            if(!$this->grant->manager) return new Object(-1, 'msg_not_permitted');

            // 공지 등록 시 필요한 변수를 세팅
            $obj = Context::getRequestVars();
			$obj->is_notice = 'Y';

			// 광고 내용이 없으면 에러
			settype($obj->ad_content, 'string');
			if($obj->ad_content == '') return new Object(-1, 'msg_invalid_request');

			// 기본값 지정
			$obj->title = $obj->ad_content; // 제목
			$obj->content = $obj->ad_content; // 내용
			$obj->allow_comment = 'N'; // 댓글 허용
			$obj->lock_comment = 'Y'; // 댓글 잠금
			if($obj->url && !preg_match('/^([a-z]+):\/\//i',$obj->url)) $obj->url = 'http://'.$obj->url; // URL (형식에 맞지 않으면 앞에 http://를 붙임)
			if(!in_array($obj->url_target,array('_self','_blank'))) $obj->url_target = '_blank'; // URL 열기 대상 (_self : 현재 창, _blank : 새 창)

			// 사용한 광고 옵션을 배열로 변환
			if($obj->used_style) $used_style = explode('|@|',$obj->used_style);

			// 글자색과 배경색이 같을 경우 오류
			if($obj->ad_color && $obj->ad_bgcolor && $obj->ad_color == $obj->ad_bgcolor) return new Object(-1, 'msg_invalid_color');

			// 사용한 글자색을 배열에 저장
			if($obj->ad_color) {
				$used_style[] = 'text_'.$obj->ad_color;
				unset($obj->ad_color);
			}

			// 사용한 배경색을 배열에 저장
			if($obj->ad_bgcolor) {
				$used_style[] = 'bg_'.$obj->ad_bgcolor;
				unset($obj->ad_bgcolor);
			}

			// 사용한 광고 옵션 & 스타일 배열을 합치기
			if(is_array($used_style)) $obj->used_style = join('|@|',$used_style);
			else $obj->used_style = array();

			// 광고 시간 확인 (Firebug나 개발자 도구 등을 통해서 임의로 조작하는 것을 막기)
			if($this->module_info->use_time == 'Y') {
				$obj->ad_time = (int)$obj->ad_time;
				$AdTimeRange = explode(',',$this->module_info->ad_time_range);
				$AdTimeRange[] = -1;
				if(!$obj->ad_time || !in_array($obj->ad_time, $AdTimeRange)) return new Object(-1, 'msg_invalid_ad_time');
			}
			
            // ad module의 model 객체 생성
            $oAdModel = &getModel('ad');

            // document module의 controller 객체 생성
            $oDocumentController = &getController('document');

            // 이미 존재하는 광고인지 체크
            $oAd = $oAdModel->getAd($obj->document_srl, $this->grant->manager);

            // 이미 존재하는 경우 에러 출력
            if($oAd->isExists() && $oAd->document_srl == $obj->document_srl) {
				return new Object(-1, 'msg_invalid_request');
            // 그렇지 않으면 신규 등록
            } else {
				// 문서 등록
                $output = $oDocumentController->insertDocument($obj);
                $msg_code = 'success_registed';
                $obj->document_srl = $output->get('document_srl');

				// 오류 발생시 멈춤
				if(!$output->toBool()) return $output;

				// 광고 등록
				$ad->document_srl = $obj->document_srl;
				$ad->ad_time = $obj->ad_time;
				$ad->url = $obj->url;
				$ad->url_target = $obj->url_target;
				$ad->style = $obj->used_style;
				$oAdController= &getController('ad');
				$oAdController->insertNotice($ad);
            }

            // 성공 메세지 등록
            $this->setMessage($msg_code);
		}

        /**
         * @brief 추가 기능을 DB에 추가
         **/
        function insertPlugin($plugin_name, $enabled = false) {
            if($enabled) $enabled = 'Y';
            else $enabled = 'N';

            $args->plugin_name = $component_name;
            $args->enabled = $enabled;

            // 추가 기능이 있는지 확인
            $output = executeQuery('ad.isPluginInserted', $args);
            if($output->data->count) return new Object(-1, 'msg_plugin_is_not_founded');

            // 입력
            $args->list_order = getNextSequence();
            $output = executeQuery('ad.insertPlugin', $args);

            $oAdController = &getController('ad');
            $oAdController->removeCache();
            return $output;
        }
    }
?>