<?php

    require_once(_XE_PATH_.'modules/document/document.item.php');

    class AdItem extends documentItem {

        
        function AdItem($document_srl = 0) {
            $this->document_srl = $document_srl;
            $this->_loadFromDB();
        }

        function setAd($document_srl) {
            $this->document_srl = $document_srl;
            $this->_loadFromDB();
        }

        function _loadFromDB() {
            $obj->document_srl = $this->document_srl;
            $output = executeQuery('ad.getAd', $obj);
            if(!$output->toBool()) return;

            $this->setAttribute($output->data);
        }

        function setAttribute($attribute) {
            $this->document_srl = $attribute->document_srl;
            $this->adds($attribute);

			$GLOBALS['__AdItem__'][$this->document_srl] = $this;
        }

		/**
		 * @brief 광고 내용 출력
		 */
		function getAdContentText($cut_size = 0) {
			return parent::getTitleText($cut_size);
		}

		/**
		 * @brief 광고 내용에 스타일을 적용하여 출력
		 */
		function getAdContent($cut_size = 0, $set_link = false) {
			$content = $this->getAdContentText($cut_size);
			$style = $this->getStyleList();

			// 적용된 스타일이 있으면 적용
			if(count($style)>0) {

				// 글자색과 배경색을 미리 정리해 놓음
				foreach($style as $key => $val) {
					if(!strpos($val,'text_') && !strpos($val,'bg_')) continue;

					if(strpos($val,'text_')) {
						$textColor = str_replace('text_','',$val);
						unset($key);
					} elseif(strpos($val,'bg_')) {
						$bgColor = str_replace('bg_','',$val);
						unset($key);
					}
				}

				$i = 0;
				$maxCount = count($style);

				// 스타일 적용
				foreach($style as $key => $val) {
					switch($val) {
						case 'bold':
							$content = sprintf('<strong>%s</strong>',$content);
							break;
						case 'underline':
							$content = sprintf('<u>%s</u>',$content);
							break;
						case 'italic':
							$content = sprintf('<i>%s</i>',$content);
							break;
					}

					if($i=$maxCount && ($textColor || $bgColor)) {
						$span = '<span style="';
						if($textColor) $span .= sprintf('color:%s;',$textColor);
						if($bgColor) $span .= sprintf('background-color:%s;',$bgColor);
						$span .= sprintf('">%s</span>');
						$content = sprintf($span,$content);
					}

					$i++;
				}
			}

			// 링크를 적용할 경우 a 태그로 감싸기~
			if($set_link && $this->getUrl()) $content = sprintf('<a href="" target="">%s</a>',$this->getUrl(),$content,$this->getUrlTarget());

			return $content;
		}

		/**
		 * @brief URL
		 */
		function getUrl() {
			return addslashes(htmlspecialchars($this->get('url')));
		}

		/**
		 * @brief URL 열기 대상
		 */
		function getUrlTarget() {
			return $this->get('url_target');
		}

		/**
		 * @brief 남은 시간 출력
		 **/
		function getRemainingTime() {
			// 종료된 광고이면 출력 하지 않음
			if($this->get('end_date')<date('YmdHis')) return false;

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			$time = date('Y-m-d H:i:s');
			$end_date = zdate($this->get('end_date'), 'Y-m-d H:i:s');
			$DiffDate = $oAdModel->dateDiff($time,$end_date);
			$Time = Context::getLang('time_word');
			$Str = $DiffDate['month'].$Time['month'].' '.$DiffDate['day'].$Time['day'].' '.$DiffDate['hour'].$Time['hour'].' '.$DiffDate['minute'].$Time['minute'].' '.$DiffDate['second'].$Time['second'];
			return $Str;
		}


		/**
		 * @brief 적용된 글자색을 반환
		 */
		function getTextColor() {
			// 적용된 스타일 목록을 구함
			$style = $this->getStyleList();

			// 스타일 목록에서 글자색을 뽑아냄
			foreach($style as $key => $val) {
				if(strpos($val,'text_')) {
					$textColor = str_replace('text_','',$val);
					break;
				}
			}

			return $textColor;
		}

		/**
		 * @brief 적용된 배경색을 반환
		 */
		function getBgColor() {
			// 적용된 스타일 목록을 구함
			$style = $this->getStyleList();

			// 스타일 목록에서 글자색을 뽑아냄
			foreach($style as $key => $val) {
				if(strpos($val,'bg_')) {
					$textColor = str_replace('bg_','',$val);
					break;
				}
			}

			return $textColor;
		}

		/**
		 * @brief 적용된 스타일(굵기, 밑줄, 기울임꼴, 글자색, 배경색) 목록을 반환
		 */
		function getStyle(){
			return str_replace('|@|',',',$this->get('style'));
		}

		/**
		 * @brief 적용된 스타일(굵기, 밑줄, 기울임꼴, 글자색, 배경색) 목록을 배열로 반환
		 */
		function getStyleList(){
			return explode('|@|',$this->get('style'));
		}
    }
?>
