<?php
    /**
     * @class  AdController
     * @author SMaker (dowon2308@paran.com)
     * @brief  controller class of ad module
     **/

    class adController extends ad {

        /**
         * @brief init
         **/
        function init() {
			$oAdModel = &getModel('ad');
			if(!$this->module_info->ad_time_range)
				$this->module_info->ad_time_range = $oAdModel->getDefaultAdTimeRange();
        }

        /**
         * @brief procAdRegister
         **/
		function procAdRegister() {
            // grant check
            if(!$this->grant->register_ad) return new Object(-1, 'msg_not_permitted');

            // get request vars
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
            if($obj->is_notice !='Y'|| !$this->grant->manager) $obj->is_notice = 'N';

			// if ad content is null, print error
			settype($obj->ad_content, 'string');
			if($obj->ad_content == '') return new Object(-1, 'msg_invalid_request');

			// set default value
			$obj->title = $obj->ad_content; // subject
			$obj->content = $obj->ad_content; // content
			$obj->allow_comment = 'N'; // allow comment
			$obj->lock_comment = 'Y'; // lock comment
			if($obj->url && !preg_match('/^([a-z]+):\/\//i',$obj->url)) $obj->url = 'http://'.$obj->url; // url
			if(!in_array($obj->url_target,array('_self','_blank'))) $obj->url_target = '_blank'; // url target

			// if writer doesn't have highlight grant
			if(!$this->grant->highlight_ad) {
				unset($obj->ad_color); // delete text color
				unset($obj->ad_bgcolor); // delete background color
				unset($obj->used_style); // delete ad option
			}

			// used ad option convert to array
			if($obj->used_style) $used_style = explode('|@|',$obj->used_style);

			// 글자색과 배경색이 같을 경우 오류
			if($obj->ad_color && $obj->ad_bgcolor && $obj->ad_color == $obj->ad_bgcolor) return new Object(-1, 'msg_invalid_color');

			// 광고 강조 포인트 계산
			if($obj->is_notice != 'Y' && ($obj->used_style || $obj->ad_color || $obj->ad_bgcolor)) {
				$highlight_point = 0;

				if($this->module_info->each_highlight_point == 'Y') {
					if(count($used_style)>0) $highlight_point += count($used_style) * $this->module_info->highlight_point;
					if($obj->ad_color) $highlight_point += $this->module_info->highlight_point;
					if($obj->ad_bgcolor) $highlight_point += $this->module_info->highlight_point;
				} else {
					$highlight_point = $this->module_info->highlight_point;
				}
			}

			// used text color save in array
			if($obj->ad_color) {
				$used_style[] = 'text_'.$obj->ad_color;
				unset($obj->ad_color);
			}

			// used background color save in array
			if($obj->ad_bgcolor) {
				$used_style[] = 'bg_'.$obj->ad_bgcolor;
				unset($obj->ad_bgcolor);
			}

			// 사용한 광고 옵션 & 스타일 배열을 합치기
			if(is_array($used_style)) $obj->used_style = join('|@|',$used_style);
			else $obj->used_style = array();

			// get logged info
			$logged_info = Context::get('logged_info');

			// create model object of point module
			$oPointModel = &getModel('point');

			// create controller object of point module
			$oPointController = &getController('point');

			if(!$this->grant->manager) {
				// 하루 등록 제한을 초과 했는지 검사 (공지는 무시)
				$daily_limit = (int)$this->module_info->daily_limit;
				if($daily_limit>0 && $obj->is_notice !='Y') {
					$args->start_date = date('Ymd').'000000';
					$args->module_srl = $this->module_info->module_srl;
					$args->member_srl = $logged_info->member_srl;
					$args->is_notice = 'N';
					
					$output = executeQuery('ad.getAds',$args);
					if(count($output->data)>$daily_limit) return new Object(-1, sprintf(Context::getLang('msg_daily_limit_over'),$daily_limit));
					unset($output);
				}
			}

			// 포인트 검사 (공지는 무시)
			if($obj->is_notice !='Y') {
				$ad_point = (int)$this->module_info->ad_point;
				// 광고 시간을 사용할 경우
				if($this->module_info->ad_point_rate && $this->module_info->use_time == 'Y') {
					$ad_point *= $obj->ad_time / $this->module_info->ad_point_rate;
					$ad_point += $highlight_point;
					if($ad_point>0) {
						$prev_point = $oPointModel->getPoint($logged_info->member_srl);
						if($ad_point > $prev_point) return new Object(-1, 'msg_not_enough_point');
					}
				}
			}
				

			// 광고 시간 확인 (Firebug나 개발자 도구 등을 통해서 임의로 조작하는 것을 막기)
			if($this->module_info->use_time == 'Y') {
				$obj->ad_time = (int)$obj->ad_time;
				$AdTimeRange = explode(',',$this->module_info->ad_time_range);
				$AdTimeRange[] = -1;
				if($obj->ad_time == -1 && !$this->grant->manager) return new Object(-1, 'msg_invalid_ad_time');
				if(!$obj->ad_time || !in_array($obj->ad_time, $AdTimeRange)) return new Object(-1, 'msg_invalid_ad_time');
			}
			
            // ad module의 model 객체 생성
            $oAdModel = &getModel('ad');

            // document module의 controller 객체 생성
            $oDocumentController = &getController('document');

            // 이미 존재하는 광고인지 체크
            $oAd = $oAdModel->getAd($obj->document_srl, $this->grant->manager);

            // if already exists, print error
            if($oAd->isExists() && $oAd->document_srl == $obj->document_srl) {
				return new Object(-1, 'msg_invalid_request');
            // else
            } else {
				// insert document
                $output = $oDocumentController->insertDocument($obj);
                $msg_code = 'success_registed';
                $obj->document_srl = $output->get('document_srl');

				// 오류 발생시 멈춤
				if(!$output->toBool()) return $output;

				// insert ad
				$ad->module_srl = $obj->module_srl;
				$ad->document_srl = $obj->document_srl;
				$ad->ad_time = $obj->ad_time;
				$ad->url = $obj->url;
				$ad->url_target = $obj->url_target;
				$ad->style = $obj->used_style;
				$output = $this->insertAd($ad);
				if(!$output->toBool()) return $output;

				// 포인트 차감 (공지는 무시)
				if($ad_point>0 && $obj->is_notice !='Y') $oPointController->setPoint($logged_info->member_srl, $ad_point, 'minus');
            }

            // 결과를 리턴
            $this->add('mid', Context::get('mid'));

            // 성공 메세지 등록
            $this->setMessage($msg_code);
		}

		/**
		 * @brief insert Ad
		 **/
		function insertAd($args) {
			// check $args
			if(!$args || !$args->document_srl) return;
			$args->ad_time = (int)$args->ad_time;
			if($this->module_info->use_time == 'Y' && !$args->ad_time) return new Object(-1, 'msg_input_ad_time');
			if($this->module_info->use_time != 'Y') $args->ad_time = -1;

			// module srl
			$module_srl = $args->module_srl;
			unset($args->module_srl);

			// create model object of ad module
			$oAdModel = &getModel('ad');

			// set end date
			if($this->module_info->use_time == 'Y' && $args->ad_time != -1) $args->end_date = date('YmdHis',$oAdModel->dateAdd('h',$args->ad_time,time()));
			else $args->end_date = -1;

			// set default value
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';
			if(!$args->start_date) $args->start_date = date('YmdHis');

			// executeQuery
			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);
			unset($obj);

			// cache file update
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $module_srl;
			$obj->no_page = 'Y';

			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief insert Notice
		 **/
		function insertNotice($args) {
			if(!$args || !$args->document_srl) return;

			// create model object of ad module
			$oAdModel = &getModel('ad');

			$oAd = $oAdModel->getAd($args->document_srl, $this->grant->manager);

			// check $args
			$args->ad_time = (int)$args->ad_time;
			$args->start_date = trim($args->start_date);
			$args->start_hour = (int)trim($args->start_hour);
			$args->start_minute = (int)trim($args->start_minute);
			$args->start_second = (int)trim($args->start_second);
			if(!$args->ad_time) $args->ad_time = -1;
			if(!$args->start_hour) $args->start_hour = '00';
			if(!$args->start_minute) $args->start_minute = '00';
			if(!$args->start_second) $args->start_second = '00';
			if(strlen($args->start_hour)<2) $args->start_hour .= '0';
			if(strlen($args->start_minute)<2) $args->start_minute .= '0';
			if(strlen($args->start_second)<2) $args->start_second .= '0';

			// set end date
			if(!$args->start_date) {
				if($args->ad_time != -1) $args->end_date = $oAdModel->dateAdd('h',$args->ad_time,date('YmdHis'));
				else $args->end_date = -1;
			} else {
				$args->end_date = $oAdModel->dateAdd('h',$args->ad_time,$args->start_date.$args->start_hour.$args->start_minute.$args->start_second);
			}

			// set default value
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';

			// executeQuery
			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);

			unset($obj);

			// cache file update
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $module_srl;
			$obj->no_page = 'Y';

			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief delete Ad
		 **/
		function deleteAd($document_srl, $delete_document = true, $return_point = true) {
			if(!$document_srl) return;

			$obj->document_srl = $document_srl;

			// create model object of document model
			$oDocumentModel = &getModel('document');

			// get document info
			$oDocument = $oDocumentModel->getDocument($document_srl, $this->grant->manager);

			// if document doesn't exists, return error
			if(!$oDocument->isExists()) return new Object(-1, 'msg_not_exists_ad');

			// delete document
			if($delete_document) {
				$oDocumentController = &getController('document');
				$oDocumentController->deleteDocument($document_srl);
			}

			// executeQuery
			$output = executeQuery('ad.deleteAd', $obj);

			// cache file update
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $oDocument->get('module_srl');
			$obj->no_page = 'Y';

			$oAdModel = &getModel('ad');
			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($obj->module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief linead module convert to ad module
		 **/
		function updateModule() {
			$args->old_module = 'linead';
			$args->new_module = 'ad';
			return executeQuery('ad.updateOldModule',$args);
		}

		/**
         *
         * @brief ad time notify trigger
         **/
        function triggerNotifyAdTime() {
			// if not logged
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return new Object();

			// 특정 모듈이면 종료
			$notNotifyModule = array('addon','admin','widget','editor');
			if(in_array(Context::get('module'),$notNotifyModule)) return new Object();

			// 특정 action이면 종료
			$notNotifyAction = array();
			if(in_array(Context::get('act'),$notNotifyAction) || strpos(Context::get('act'),'dispAdAdmin')) return new Object();

			$MemberSrl = $logged_info->member_srl;
			$UserName = $logged_info->user_name;
			$NickName = $logged_info->nick_name;

			// create model object of ad module
			$oAdModel = &getModel('ad');

			// create controller object of communication module
			$oCommunicationController = &getController('communication');

			// get notify module list
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			if(!file_exists($cache_filename)) {
				$modules = $oAdModel->getNotifyModules();
				if(!$modules->toBool() || !$modules->data) return new Object();

				$data = $modules->data;

				foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

				$module_srls = join(',',$module_srls);

				// if not exists folder, make dir
				if(!is_dir($cache_path)) FileHandler::makedir($cache_path);

				// set cache
				FileHandler::writeFile($cache_filename, $module_srls);
			} else {
				$module_srls = trim(FileHandler::readFile($cache_filename));
			}

			if(!$module_srls) return new Object();

			// get notify ad list
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%s%snotify_ad.cache.txt', $cache_path, getNumberingPath($MemberSrl));

			// if exists cache file, read cache file or find in db
			if(!file_exists($cache_filename)) {
				$args->module_srl = $module_srls;
				$args->member_srl = $logged_info->member_srl;
				$args->end_date = date('YmdHis');
				$list = $oAdModel->getAdNotifyList($args);
				$notifyList = $list->data;

				// write cache file
				FileHandler::writeFile($cache_filename, serialize($list));

				// 오류가 발생하거나 알림 대상 목록 결과가 없으면 종료
				if(!$list->toBool() || !$list->data) return new Object();
			} else {
				// read cache file
				$list = unserialize(FileHandler::readFile($cache_filename));
				$notifyList = $list->data;
			}

			// 알림 대상 목록 결과가 있으면 쪽지 보내기
			if($notifyList && count($notifyList)>0) {
				// get admin member srl
				$admin = $oAdModel->getAdminMemberSrl();
				// get message title / content
				$notifyTitle = Context::getLang('notify_title');
				$notifyContent = Context::getLang('notify_content');
				foreach($notifyList as $key => $val) {
					// set message title / content
					$title = $notifyTitle['typeA'];
					$content = sprintf($notifyContent['typeA'],$NickName,$NickName,$val->getAdContent(),zdate($val->get('regdate')),zdate($val->get('end_date')));
					// send message
					$oCommunicationController->sendMessage($admin, $MemberSrl, $title, $content, false);
					// delete ad
					$this->deleteAd($val->document_srl, true, false);
				}
				// 캐시 파일 재생성
				FileHandler::writeFile($cache_filename, 'N;');
			}
			return new Object();
		}

        /**
         * @brief 모듈이 삭제될때 등록된 모든 광고를 삭제하는 trigger
         **/
        function triggerDeleteModuleAds(&$obj) {
            $module_srl = $obj->module_srl;
            if(!$module_srl) return new Object();

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

            // 등록된 광고 목록 구하기 (delete 쿼리가 다중 테이블 select를 지원하지 않아서 어쩔 수 없음)
			$args->module_srl = $module_srl;
			$args->no_page = 'Y';
			$args->select_document_srl = 'Y';
			$args->is_notice = 'N';
			$output = $oAdModel->getAdList($args);
			if(!$output->toBool()) return $output;

			unset($args);

			if($output->data) {
				foreach($output->data as $key => $val) $document_srls[] = $val->document_srl;

				// delete cache file
				$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($val->get('module_srl')));
				if(is_dir($cache_path)) FileHandler::removeDir($cache_path);

				// delete ad
				$args->document_srls = join(',',$document_srls);
				$output = executeQuery('ad.deleteModuleAds',$args);
			    if(!$output->toBool()) return $output;
			}

            // 캐시 파일 재생성
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			$modules = $oAdModel->getNotifyModules();
			if(!$modules->toBool() || !$modules->data) return new Object();

			$data = $modules->data;

			foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

			$module_srls = join(',',$module_srls);

			// 폴더가 없으면 생성
			if(!is_dir($cache_path)) FileHandler::makedir($cache_path);

			// set cache
			FileHandler::writeFile($cache_filename, $module_srls);

            return new Object();
        }

        /**
         * @brief insert statistics
         **/
		function insertStatistics($obj) {
		}
    }
?>
