<?php
    /**
    * @class PluginHandler
    * @author SMaker (dowon2308@paran.com)
    * @brief Plugin (추가 기능)의 상위 클래스임
    *
    * 주로 하는 일은 추가 기능 요청시 추가 기능에서 필요로 하는 변수를 세팅해준다
    **/

    class PluginHandler extends Object {

        /**
         * @brief 추가 기능의 xml 및 관련 정보들을 설정
         **/
        function setInfo($info) {
            Context::set('plugin_info', $info);

            if(!$info->extra_vars) return;

            foreach($info->extra_vars as $key => $val) {
                $this->{$key} = trim($val->value);
            }
        }
    }
?>
