<?php
    /**
     * @class  AdModel
     * @author SMaker (dowon2308@paran.com)
     * @brief model class of ad module
     **/

	/**
	 * @brief load ad item object
	 */
	require_once(_XE_PATH_.'modules/ad/ad.item.php');

    class adModel extends ad {

        /**
         * @brief init
         **/
        function init() {
        }

        /**
         * @brief get default config of ad module
         **/
        function getConfig() {
            static $module_info = null;
            if(is_null($module_info)) {
                // get module config (use module model)
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('ad');

                unset($module_info->grants);
            }
            return $module_info;
        }

        /**
		 * @brief get old module Config (for old version update)
         **/
        function getOldConfig() {
            static $module_info = null;
            if(is_null($module_info)) {
                // module module_info의 값을 구함
                $oModuleModel = &getModel('module');
                $module_info = $oModuleModel->getModuleConfig('linead');

                unset($module_info->grants);
            }
            return $module_info;
        }

        /**
         * @brief check old module exists (for old version update)
         **/
        function isExistsOldModule() {
			$output = executeQuery('ad.getOldModule');
			if(count($output->data)) return true;
			return false;
        }

		/**
		 * @brief get ad item object
		 * @return ad item object
		 **/
        function getAd($document_srl = 0) {
            if(!$document_srl) return new AdItem();

            if(!isset($GLOBALS['__AdItem__'][$document_srl])) {
                $oAd = new AdItem($document_srl);
                $GLOBALS['__AdItem__'][$document_srl] = $oAd;
            }

            return $GLOBALS['__AdItem__'][$document_srl];
        }

        /**
		 * @brief get multiple ads.
		 * @return ad item object
         **/
        function getAds($document_srls, $is_admin = false) {
            if(is_array($document_srls)) {
                $list_count = count($document_srls);
                $document_srls = implode(',',$document_srls);
            } else {
                $list_count = 1;
            }
            $args->document_srls = $document_srls;
            $args->list_count = $list_count;
            $args->order_type = 'asc';

            $output = executeQuery('ad.getAds', $args);
            $document_list = $output->data;
            if(!$document_list) return;
            if(!is_array($document_list)) $document_list = array($document_list);

            $document_count = count($document_list);
            foreach($document_list as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                if(!$document_srl) continue;

                if(!$GLOBALS['XE_AD_LIST'][$document_srl]) {
                    $oAd = null;
                    $oAd = new AdItem();
                    $oAd->setAttribute($attribute, false);
                    $GLOBALS['XE_AD_LIST'][$document_srl] = $oAd;
                }

                $result[$attribute->document_srl] = $GLOBALS['XE_AD_LIST'][$document_srl];
            }

            $output = null;
            if(count($result)) {
                foreach($result as $document_srl => $val) {
                    $output[$document_srl] = $GLOBALS['XE_AD_LIST'][$document_srl];
                }
            }

            return $output;
        }

		/**
		 * @brief get ad list
		 **/
        function getAdList($obj) {
            // set default query id
            $query_id = 'ad.getAdList';

            // module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
            if($obj->mid) {
                $oModuleModel = &getModel('module');
                $obj->module_srl = $oModuleModel->getModuleSrlByMid($args->mid);
                unset($args->mid);
            }

            // 넘어온 module_srl은 array일 수도 있기에 array인지를 체크
            if(is_array($obj->module_srl)) $args->module_srl = implode(',', $obj->module_srl);
			else $args->module_srl = $obj->module_srl;

			if($args->no_page == 'Y') {
				// if not use page feature, change query id
				$query_id = 'ad.getAdListNoPage';
			} else {
	            $args->page = $obj->page?$obj->page:1;
		        $args->list_count = $obj->list_count?$obj->list_count:20;
			    $args->page_count = $obj->page_count?$obj->page_count:10;
			}

			$args->member_srl = $obj->member_srl;
			$args->start_date = $obj->start_date;
			$args->start_regdate = $obj->start_regdate;
			$args->end_regdate = $obj->end_regdate;
			$args->end_date = $obj->end_date;
			$args->is_notice = $obj->is_notice;

            // search option 검색 옵션 정리
            $search_target = $obj->search_target;
            $search_keyword = $obj->search_keyword;
            if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'content' :
                        if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                        $args->s_content = $search_keyword;
                        break;
                }
            }

			// document srl만 뽑아올 경우 query id 변경
			if($args->select_document_srl == 'Y') {
				switch($query_id) {
					case 'ad.getAdList':
						$query_id = 'ad.getAdListSelectDocumentSrl';
					case 'ad.getAdListNoPage':
						$query_id = 'ad.getAdListNoPageSelectDocumentSrl';
				}
			}

			$output = executeQueryArray($query_id, $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            $idx = 0;
            $data = $output->data;
            unset($output->data);

            $keys = array_keys($data);
            $virtual_number = $keys[0];

            foreach($data as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                $oAd = null;
                $oAd = new AdItem();
                $oAd->setAttribute($attribute);

                $output->data[$virtual_number] = $oAd;
                $virtual_number --;
            }

            return $output;
        }

		/**
		 * @brief get ad notify List
		 **/
        function getAdNotifyList($obj) {
            // 기본으로 사용할 query id 지정 (몇 가지 검색 옵션에 따라 query id 변경됨)
            $query_id = 'ad.getAdNotifyList';

            // module_srl 대신 mid가 넘어왔을 경우는 직접 module_srl을 구해줌
            if($obj->mid) {
                $oModuleModel = &getModel('module');
                $obj->module_srl = $oModuleModel->getModuleSrlByMid($args->mid);
                unset($args->mid);
            }

            // 넘어온 module_srl은 array일 수도 있기에 array인지를 체크
            if(is_array($obj->module_srl)) $args->module_srl = implode(',', $obj->module_srl);
			else $args->module_srl = $obj->module_srl;

			$args->member_srl = $obj->member_srl;
			$args->start_date = $obj->start_date;
			$args->end_date = $obj->end_date;

            // 검색 옵션 정리
            if($obj->search_target) {
                switch($obj->search_target) {
                    case 'content' :
                        if($args->search_keyword) $args->search_keyword = str_replace(' ','%',$args->search_keyword);
                        $args->s_content = $args->search_keyword;
                        break;
                }
            }

			$output = executeQueryArray($query_id, $args);

            // 결과가 없거나 오류 발생시 그냥 return
            if(!$output->toBool()||!count($output->data)) return $output;

            $idx = 0;
            $data = $output->data;
            unset($output->data);

            $keys = array_keys($data);
            $virtual_number = $keys[0];

            foreach($data as $key => $attribute) {
                $document_srl = $attribute->document_srl;
                $oAd = null;
                $oAd = new AdItem();
                $oAd->setAttribute($attribute);

                $output->data[$virtual_number] = $oAd;
                $virtual_number --;
            }

            return $output;
        }

        /**
         * @brief module_srl에 해당 하는 광고의 전체 갯수를 가져옴
         **/
        function getAdCount($module_srl, $search_obj = NULL) {
            // 검색 옵션 추가
            $args->module_srl = $module_srl;
            $args->s_content = $search_obj->s_content;
            $args->s_member_srl = $search_obj->s_member_srl;
			$args->is_notice = $search_obj->is_notice;
			$args->start_date = $search_obj->start_date;

            $output = executeQuery('ad.getAdCount', $args);

            // 전체 갯수를 return
            $total_count = $output->data->count;
            return (int)$total_count;
        }

		/**
		 * @brief date add
		 * @return timestamp
		 **/
		function dateAdd($interval, $number, $date) {
			$date_time_array = getdate($date);
		    $hours = $date_time_array['hours'];
		    $minutes = $date_time_array['minutes'];
		    $seconds = $date_time_array['seconds'];
		    $month = $date_time_array['mon'];
		    $day = $date_time_array['mday'];
		    $year = $date_time_array['year'];

	    switch ($interval) {
            case 'yyyy':
		        $year+=$number;
	            break;
		    case 'q':
			    $year+=($number*3);
				break;
	        case 'm':
		        $month+=$number;
			    break;
	        case 'y':
		    case 'd':
			case 'w':
	            $day+=$number;
		        break;
	        case 'ww':
		        $day+=($number*7);
			    break;
	        case 'h':
		        $hours+=$number;
			    break;
	        case 'n':
		        $minutes+=$number;
			    break;
	        case 's':
		        $seconds+=$number; 
			    break;            
			}

		    $timestamp= mktime($hours,$minutes,$seconds,$month,$day,$year);
		    return $timestamp;
		}

		/**
		 * @brief date subtract
		 * @return timestamp
		 **/
		function dateSubtract($interval, $number, $date) {
			$date_time_array = getdate($date);
		    $hours = $date_time_array['hours'];
		    $minutes = $date_time_array['minutes'];
		    $seconds = $date_time_array['seconds'];
		    $month = $date_time_array['mon'];
		    $day = $date_time_array['mday'];
		    $year = $date_time_array['year'];

	    switch ($interval) {
            case 'yyyy':
		        $year-=$number;
	            break;
		    case 'q':
			    $year-=($number*3);
				break;
	        case 'm':
		        $month-=$number;
			    break;
	        case 'y':
		    case 'd':
			case 'w':
	            $day-=$number;
		        break;
	        case 'ww':
		        $day-=($number*7);
			    break;
	        case 'h':
		        $hours-=$number;
			    break;
	        case 'n':
		        $minutes-=$number;
			    break;
	        case 's':
		        $seconds-=$number; 
			    break;            
			}

		    $timestamp= mktime($hours,$minutes,$seconds,$month,$day,$year);
		    return $timestamp;
		}

		/**
		 * @brief compare the two dates
		 * @return array
		 **/
		function dateDiff($startDate, $endDate) {
			$startTime = strtotime($startDate);
			$endTime = strtotime($endDate);

			if($startTime > $endTime) return false;

			$diffTime = $endTime - $startTime;
			
			$startDateParse = date_parse($startDate);
			$endDateParse = date_parse($endDate);
			$maxDay = cal_days_in_month(CAL_GREGORIAN,$startDateParse['month'],$st);

			$diffDate['month'] = floor($diffTime/60/60/24/31);
			$diffDate['day'] = floor($diffTime/60/60/24);
			$diffDate['hour'] = sprintf("%02d", ($diffTime/60/60)%24);
			$diffDate['minute'] = sprintf("%02d", ($diffTime/60)%60);
			$diffDate['second'] = sprintf("%02d", ($diffTime)%60);

			return $diffDate;
		}


		function getDefaultAdTimeRange() {
			return '5, 10, 15, 20';
		}

		function getDefaultAdTimeRangeArray() {
			return array(5, 10, 15, 20);
		}

		/**
		 * @brief 최고 관리자의 member srl을 구함
		 */
		function getAdminMemberSrl() {
			$output = executeQuery('ad.getAdminMemberSrl');
			return $output->data->member_srl;
		}

		/**
		 * @brief 알림 대상 모듈 구하기
		 */
		function getNotifyModules() {
			$output = executeQueryArray('ad.getNotifyModules');
			return $output;
		}

		/**
		 * @brief 모듈 버전 구함
		 */
		function getVersion() {
			$oModuleModel = &getModel('module');
			$xml_info = $oModuleModel->getModuleInfoXml('ad');
			return $xml_info->version;
		}

		/**
		 * @brief 모듈 버전을 구해서 이미지로 반환 (working)
		 */
		function getVersionImg() {
/*			$version = $this->getVersion();
			$chars = array(
				'.' => array('file' => 'dot.gif', 'width'=> 2),
				'0' => array('file' => '0.gif', 'width' => 6),
				'1' => array('file' => '1.gif', 'width' => 6),
				'2' => array('file' => '2.gif', 'width' => 6),
				'3' => array('file' => '3.gif', 'width' => 6),
				'4' => array('file' => '4.gif', 'width' => 6)
			);

			foreach($chars as $key => $val) {
				$pattern = '/^[0-9]+(.[0-9])';
				$img = sprintf('<img src="img/chars/%s" width="%s" height="5" />', $val['file'], $val['width']);
				$version = preg_replace($pattern, $img, $version);
			}

			return $version;
*/
		}

        /**
         * @brief 추가 기능의 객체 생성
         **/
        function getPluginObject($plugin) {
            if(!$this->loaded_plugin_list[$plugin]) {
                // 해당 추가 기능의 객체를 생성해서 실행
                $class_path = sprintf('%splugins/%s/', $this->module_path, $plugin);
                $class_file = sprintf('%s%s.class.php', $class_path, $plugin);
                if(!file_exists($class_file)) return new Object(-1, sprintf(Context::getLang('msg_plugin_is_not_founded'), $plugin));

                // 클래스 파일을 읽은 후 객체 생성
                require_once($class_file);
                $eval_str = sprintf('$oPlugin = new %s();', $plugin);
                @eval($eval_str);
                if(!$oPlugin) return new Object(-1, sprintf(Context::getLang('msg_plugin_is_not_founded'), $plugin));

                // 설정 정보를 추가
                $plugin_info = $this->getPlugin($plugin);
                $oPlugin->setInfo($plugin_info);
                $this->loaded_plugin_list[$plugin] = $oPlugin;
            }

            return $this->loaded_plugin_list[$plugin];
        }

        /**
         * @brief 추가 기능 목록 캐시 파일 이름 return
         **/
        function getPluginCacheFile($filter_enabled= true) {
            $lang = Context::getLangType();
            $cache_path = _XE_PATH_.'files/cache/plugin/cache/';
            if(!is_dir($cache_path)) FileHandler::makeDir($cache_path);
            $cache_file = $cache_path.'plugin_list.' . $lang .'.';
            if($filter_enabled) $cache_file .= 'filter.';
            if($site_srl) $cache_file .= $site_srl.'.';
            $cache_file .= 'php';
            return $cache_file;
        }

        /**
         * @brief 추가 기능 목록을 return (DB정보 보함)
         **/
        function getPluginList($filter_enabled = true) {
            $cache_file = $this->getPluginCacheFile($filter_enabled);
            if(!file_exists($cache_file)) {
                $oAdController = &getController('ad');
                $oAdController->makePluginCache($filter_enabled);
            }

            if(!file_exists($cache_file)) return;
            @include($cache_file);

            if(count($plugin_list)) {
                foreach($plugin_list as $key => $val) {
                    if(!trim($key)) continue;
                    if(!is_dir(_XE_PATH_.'modules/ad/plugins/'.$key)) {
                        FileHandler::removeFile($cache_file);
                        return $this->getPluginList($filter_enabled);
                    }
                }
            }

            return $plugin_list;
        }

        /**
         * @brief 추가 기능의 xml + db정보를 구함
         **/
        function getPlugin($plugin_name) {
            $args->plugin_name = $plugin_name;

            $output = executeQuery('ad.getPlugin', $args);

            $plugin = $output->data;

            $plugin_name = $plugin->component_name;

            unset($xml_info);
            $xml_info = $this->getPluginXmlInfo($plugin_name);
            $xml_info->enabled = $plugin->enabled;

            $xml_info->target_group = array();

            $xml_info->mid_list = array();

            if($plugin->extra_vars) {
                $extra_vars = unserialize($plugin->extra_vars);

                if($extra_vars->target_group) {
                    $xml_info->target_group = $extra_vars->target_group;
                    unset($extra_vars->target_group);
                }

                if($extra_vars->mid_list) {
                    $xml_info->mid_list = $extra_vars->mid_list;
                    unset($extra_vars->mid_list);
                }


                if($xml_info->extra_vars) {
                    foreach($xml_info->extra_vars as $key => $val) {
                        $xml_info->extra_vars->{$key}->value = $extra_vars->{$key};
                    }
                }
            }

            return $xml_info;
        }

        /**
         * @brief 추가 기능의 xml정보를 읽음
         **/
        function getPluginXmlInfo($plugin) {
            $lang_type = Context::getLangType();

            // 요청된 추가 기능의 xml파일 위치를 구함
            $plugin_path = sprintf('%s/plugins/%s/', $this->module_path, $plugin);

            $xml_file = sprintf('%sinfo.xml', $plugin_path);
            $cache_file = sprintf('./files/cache/plugin/%s.%s.php', $plugin, $lang_type);

            // 캐시된 xml 파일이 있으면 include 후 정보 return
            if(file_exists($cache_file) && file_exists($xml_file) && filemtime($cache_file) > filemtime($xml_file)) {
                include($cache_file);
                return $xml_info;
            }

            // 캐시된 파일이 없으면 파싱 & 캐싱 후 return
            $oParser = new XmlParser();
            $xml_doc = $oParser->loadXmlFile($xml_file);

            // 정보 정리
            if($xml_doc->plugin->version && $xml_doc->plugin->attrs->version == '0.2') {
                $plugin_info->plugin_name = $plugin;
                $plugin_info->title = $xml_doc->plugin->title->body;
                $plugin_info->description = str_replace('\n', "\n", $xml_doc->plugin->description->body);
                $plugin_info->version = $xml_doc->plugin->version->body;
                $plugin_info->date = $xml_doc->plugin->date->body;
                $plugin_info->homepage = $xml_doc->plugin->link->body;
                $plugin_info->license = $xml_doc->plugin->license->body;
                $plugin_info->license_link = $xml_doc->plugin->license->attrs->link;

                $buff = '<?php if(!defined("__ZBXE__")) exit(); ';
                $buff .= sprintf('$xml_info->plugin_name = "%s";', $plugin_info->plugin_name);
                $buff .= sprintf('$xml_info->title = "%s";', $plugin_info->title);
                $buff .= sprintf('$xml_info->description = "%s";', $plugin_info->description);
                $buff .= sprintf('$xml_info->version = "%s";', $plugin_info->version);
                $buff .= sprintf('$xml_info->date = "%s";', $plugin_info->date);
                $buff .= sprintf('$xml_info->homepage = "%s";', $plugin_info->homepage);
                $buff .= sprintf('$xml_info->license = "%s";', $plugin_info->license);
                $buff .= sprintf('$xml_info->license_link = "%s";', $plugin_info->license_link);

                // 작성자 정보
                if(!is_array($xml_doc->plugin->author)) $author_list[] = $xml_doc->plugin->author;
                else $author_list = $xml_doc->plugin->author;

                for($i=0; $i < count($author_list); $i++) {
                    $buff .= sprintf('$xml_info->author['.$i.']->name = "%s";', $author_list[$i]->name->body);
                    $buff .= sprintf('$xml_info->author['.$i.']->email_address = "%s";', $author_list[$i]->attrs->email_address);
                    $buff .= sprintf('$xml_info->author['.$i.']->homepage = "%s";', $author_list[$i]->attrs->link);
                }

                // history
                if($xml_doc->plugin->history) {
                    if(!is_array($xml_doc->plugin->history)) $history_list[] = $xml_doc->plugin->history;
                    else $history_list = $xml_doc->plugin->history;

                    for($i=0; $i < count($history_list); $i++) {
                        unset($obj);
                        sscanf($history_list[$i]->attrs->date, '%d-%d-%d', $date_obj->y, $date_obj->m, $date_obj->d);
                        $date = sprintf('%04d%02d%02d', $date_obj->y, $date_obj->m, $date_obj->d);
                        $buff .= sprintf('$xml_info->history['.$i.']->description = "%s";', $history_list[$i]->description->body);
                        $buff .= sprintf('$xml_info->history['.$i.']->version = "%s";', $history_list[$i]->attrs->version);
                        $buff .= sprintf('$xml_info->history['.$i.']->date = "%s";', $date);

                        if($history_list[$i]->author) {
                            (!is_array($history_list[$i]->author)) ? $obj->author_list[] = $history_list[$i]->author : $obj->author_list = $history_list[$i]->author;

                            for($j=0; $j < count($obj->author_list); $j++) {
                                $buff .= sprintf('$xml_info->history['.$i.']->author['.$j.']->name = "%s";', $obj->author_list[$j]->name->body);
                                $buff .= sprintf('$xml_info->history['.$i.']->author['.$j.']->email_address = "%s";', $obj->author_list[$j]->attrs->email_address);
                                $buff .= sprintf('$xml_info->history['.$i.']->author['.$j.']->homepage = "%s";', $obj->author_list[$j]->attrs->link);
                            }
                        }

                        if($history_list[$i]->log) {
                            (!is_array($history_list[$i]->log)) ? $obj->log_list[] = $history_list[$i]->log : $obj->log_list = $history_list[$i]->log;

                            for($j=0; $j < count($obj->log_list); $j++) {
                                $buff .= sprintf('$xml_info->history['.$i.']->logs['.$j.']->text = "%s";', $obj->log_list[$j]->body);
                                $buff .= sprintf('$xml_info->history['.$i.']->logs['.$j.']->link = "%s";', $obj->log_list[$j]->attrs->link);
                            }
                        }
                    }
                }

            } else {
                sscanf($xml_doc->plugin->author->attrs->date, '%d. %d. %d', $date_obj->y, $date_obj->m, $date_obj->d);
                $date = sprintf('%04d%02d%02d', $date_obj->y, $date_obj->m, $date_obj->d);
                $xml_info->plugin_name = $plugin;
                $xml_info->title = $xml_doc->plugin->title->body;
                $xml_info->description = str_replace('\n', "\n", $xml_doc->plugin->author->description->body);
                $xml_info->version = $xml_doc->plugin->attrs->version;
                $xml_info->date = $date;
                $xml_info->author->name = $xml_doc->plugin->author->name->body;
                $xml_info->author->email_address = $xml_doc->plugin->author->attrs->email_address;
                $xml_info->author->homepage = $xml_doc->plugin->author->attrs->link;

                $buff = '<?php if(!defined("__ZBXE__")) exit(); ';
                $buff .= sprintf('$xml_info->plugin_name = "%s";', $xml_info->plugin_name);
                $buff .= sprintf('$xml_info->title = "%s";', $xml_info->title);
                $buff .= sprintf('$xml_info->description = "%s";', $xml_info->description);
                $buff .= sprintf('$xml_info->version = "%s";', $xml_info->version);
                $buff .= sprintf('$xml_info->date = "%s";', $xml_info->date);
                $buff .= sprintf('$xml_info->author[0]->name = "%s";', $xml_info->author->name);
                $buff .= sprintf('$xml_info->author[0]->email_address = "%s";', $xml_info->author->email_address);
                $buff .= sprintf('$xml_info->author[0]->homepage = "%s";', $xml_info->author->homepage);
            }

            // 추가 변수 정리
            $extra_vars = $xml_doc->plugin->extra_vars->var;
            if($extra_vars) {
                if(!is_array($extra_vars)) $extra_vars = array($extra_vars);
                foreach($extra_vars as $key => $val) {
                    unset($obj);
                    $key = $val->attrs->name;
                    $title = $val->title->body;
                    $description = $val->description->body;
                    $xml_info->extra_vars->{$key}->title = $title;
                    $xml_info->extra_vars->{$key}->description = $description;

                    $buff .= sprintf('$xml_info->extra_vars->%s->%s = "%s";', $key, 'title', $title);
                    $buff .= sprintf('$xml_info->extra_vars->%s->%s = "%s";', $key, 'description', $description);
                }
            }

            $buff .= ' ?>';

            FileHandler::writeFile($cache_file, $buff, "w");

		    unset($xml_info);
            include($cache_file);
            return $xml_info;
        }
    }
?>
