<?php
    /**
     * @class  AdController
     * @author SMaker (dowon2308@paran.com)
     * @brief  controller class of ad module
     **/

    class adController extends ad {

        /**
         * @brief init
         **/
        function init() {
			$oAdModel = &getModel('ad');
			if(!$this->module_info->ad_time_range)
				$this->module_info->ad_time_range = $oAdModel->getDefaultAdTimeRange();
        }

        /**
         * @brief 광고 등록
         **/
		function procAdRegister() {
            // 권한 체크
            if(!$this->grant->register_ad) return new Object(-1, 'msg_not_permitted');

            // 광고 등록 시 필요한 변수를 세팅
            $obj = Context::getRequestVars();
            $obj->module_srl = $this->module_srl;
			$obj->is_notice = 'N';
            //if($obj->is_notice!='Y'||!$this->grant->manager) $obj->is_notice = 'N';

			// 광고 내용이 없으면 에러
			settype($obj->ad_content, 'string');
			if($obj->ad_content == '') return new Object(-1, 'msg_invalid_request');

			// 기본값 지정
			$obj->title = $obj->ad_content; # 제목
			$obj->content = $obj->ad_content; # 내용
			$obj->allow_comment = 'N'; # 댓글 허용
			$obj->lock_comment = 'Y'; # 댓글 잠금
			if($obj->url && !preg_match('/^([a-z]+):\/\//i',$obj->url)) $obj->url = 'http://'.$obj->url; # URL
			if(!in_array($obj->url_target,array('_self','_target'))) $obj->url_target = '_blank'; # URL 열기 대상

			// 광고 강조 권한이 없다면
			if(!$this->grant->highlight_ad) {
				unset($obj->ad_color); # 글자색 제거
				unset($obj->ad_bgcolor); # 배경색 제거
				unset($obj->used_style); # 광고 옵션 제거
			}

			// 사용한 광고 옵션을 배열로 변환
			if($obj->used_style) $used_style = explode('|@|',$obj->used_style);

			// 글자색과 배경색이 같을 경우 오류
			if($obj->ad_color && $obj->ad_bgcolor && $obj->ad_color == $obj->ad_bgcolor) return new Object(-1, 'msg_invalid_color');

			// 광고 강조 포인트 계산
			if($obj->is_notice != 'Y' && ($obj->used_style || $obj->ad_color || $obj->ad_bgcolor)) {
				$highlight_point = 0;

				if($this->module_info->each_highlight_point == 'Y') {
					if(count($used_style)>0) $highlight_point += count($used_style) * $this->module_info->highlight_point;
					if($obj->ad_color) $highlight_point += $this->module_info->highlight_point;
					if($obj->ad_bgcolor) $highlight_point += $this->module_info->highlight_point;
				} else {
					$highlight_point = $this->module_info->highlight_point;
				}
			}

			// 사용한 글자색을 배열에 저장
			if($obj->ad_color) {
				$used_style[] = 'text_'.$obj->ad_color;
				unset($obj->ad_color);
			}

			// 사용한 배경색을 배열에 저장
			if($obj->ad_bgcolor) {
				$used_style[] = 'bg_'.$obj->ad_bgcolor;
				unset($obj->ad_bgcolor);
			}

			// 사용한 광고 옵션 & 스타일 배열을 합치기
			$obj->used_style = join('|@|',$used_style);

			// 로그인 정보를 구함
			$logged_info = Context::get('logged_info');

			if(!$this->grant->manager) {
				// 하루 등록 제한을 초과 했는지 검사 (공지는 무시)
				$daily_limit = (int)$this->module_info->daily_limit;
				if($daily_limit>0 && $obj->is_notice !='Y') {
					$args->start_date = date('Ymd').'000000';
					$args->module_srl = $this->module_info->module_srl;
					$args->member_srl = $logged_info->member_srl;
					$args->is_notice = 'N';
					
					$output = executeQuery('ad.getAds',$args);
					if(count($output->data)>$daily_limit) return new Object(-1, sprintf(Context::getLang('msg_daily_limit_over'),$daily_limit));
					unset($output);
				}
			}

			// 포인트 검사 (공지는 무시)
			if($obj->is_notice !='Y') {
				$ad_point = (int)$this->module_info->ad_point;
				// 광고 시간을 사용할 경우
				if($this->module_info->ad_point_rate && $this->module_info->use_time == 'Y') {
					$ad_point *= $obj->ad_time / $this->module_info->ad_point_rate;
					$ad_point += $highlight_point;
					if($ad_point>0) {
						$oPointModel = &getModel('point');
						$oPointController = &getController('point');
						$prev_point = $oPointModel->getPoint($logged_info->member_srl);
						if($ad_point > $prev_point) return new Object(-1, 'msg_not_enough_point');
					}
				}
			}
				

			// 광고 시간 확인 (Firebug나 개발자 도구 등을 통해서 임의로 조작하는 것을 막기)
			if($this->module_info->use_time == 'Y') {
				$obj->ad_time = (int)$obj->ad_time;
				$AdTimeRange = explode(',',$this->module_info->ad_time_range);
				if($obj->ad_time == -1 && !$this->grant->manager) return new Object(-1, 'msg_invalid_request');
				if(!$obj->ad_time || !in_array($obj->ad_time, $AdTimeRange)) return new Object(-1, 'msg_invalid_request');
			}
			
            // ad module의 model 객체 생성
            $oAdModel = &getModel('ad');

            // document module의 controller 객체 생성
            $oDocumentController = &getController('document');

            // 이미 존재하는 광고인지 체크
            $oAd = $oAdModel->getAd($obj->document_srl, $this->grant->manager);

            // 이미 존재하는 경우 에러 출력
            if($oAd->isExists() && $oAd->document_srl == $obj->document_srl) {
				return new Object(-1, 'msg_invalid_request');
            // 그렇지 않으면 신규 등록
            } else {
				// 문서 등록
                $output = $oDocumentController->insertDocument($obj);
                $msg_code = 'success_registed';
                $obj->document_srl = $output->get('document_srl');

				// 오류 발생시 멈춤
				if(!$output->toBool()) return $output;

				// 광고 등록
				$ad->module_srl = $obj->module_srl;
				$ad->document_srl = $obj->document_srl;
				$ad->ad_time = $obj->ad_time;
				$ad->url = $obj->url;
				$ad->url_target = $obj->url_target;
				$ad->style = $obj->used_style;
				$this->insertAd($ad);

				// 포인트 차감 (공지는 무시)
				if($ad_point>0 && $obj->is_notice !='Y') $oPointController->setPoint($logged_info->member_srl, $ad_point, 'minus');
            }

            // 결과를 리턴
            $this->add('mid', Context::get('mid'));

            // 성공 메세지 등록
            $this->setMessage($msg_code);
		}

		/**
		 * @brief 광고 등록
		 **/
		function insertAd($args) {
			if(!$args || !$args->document_srl) return;

			$module_srl = $args->module_srl;
			unset($args->module_srl);

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			$oAd = $oAdModel->getAd($args->document_srl, $this->grant->manager);

			// 입력받은 항목 검사
			$args->ad_time = (int)$args->ad_time;
			if($this->module_info->use_time == 'Y' && !$args->ad_time) return;
			if($this->module_info->use_time != 'Y') $args->ad_time = -1;

			// 광고 종료일을 지정
			if($this->module_info->use_time == 'Y' && $args->ad_time != -1) $args->end_date = date('YmdHis',$oAdModel->dateAdd('h',$args->ad_time,time()));
			else $args->end_date = -1;

			// 기본값 지정
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';
			if(!$args->start_date) $args->start_date = date('Ymd');

			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);

			unset($obj);

			// 캐시 파일 업데이트
			$obj->start_date = date('Ymd').'000000';
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $module_srl;
			$obj->no_page = 'Y';

			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief 공지 등록
		 **/
		function insertNotice($args) {
			if(!$args || !$args->document_srl) return;

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			$oAd = $oAdModel->getAd($args->document_srl, $this->grant->manager);

			// 입력받은 항목 검사
			$args->ad_time = (int)$args->ad_time;
			$args->start_date = trim($args->start_date);
			$args->start_hour = (int)trim($args->start_hour);
			$args->start_minute = (int)trim($args->start_minute);
			$args->start_second = (int)trim($args->start_second);
			if(!$args->ad_time) $args->ad_time = -1;
			if(!$args->start_hour) $args->start_hour = '00';
			elseif(strlen($args->start_hour)<2) $args->start_hour .= '0';
			if(!$args->start_minute) $args->start_minute = '00';
			elseif(strlen($args->start_minute)<2) $args->start_minute .= '0';
			if(!$args->start_second) $args->start_second = '00';
			elseif(strlen($args->start_second)<2) $args->start_second .= '0';

			// 광고 종료일을 지정
			if(!$args->start_date) {
				if($args->ad_time != -1) $args->end_date = $oAdModel->dateAdd('h',$args->ad_time,date('YmdHis'));
				else $args->end_date = -1;
			} else {
				$EndDate = $args->start_date.$args->start_hour.$args->start_minute.$args->start_second;
				$args->end_date = $oAdModel->dateAdd('h',$args->ad_time,$EndDate);
			}

			// 기본값 지정
			if($args->url && !preg_match('/^([a-z]+):\/\//i',$args->url)) $args->url = 'http://'.$args->url;
			if(!in_array($args->url_target,array('_self','_target'))) $args->url_target = '_blank';

			$obj->document_srl = $args->document_srl;
			$obj->start_date = $args->start_date;
			$obj->end_date = $args->end_date;
			$obj->url = $args->url;
			$obj->url_target = $args->url_target;
			$obj->style = $args->style;
			$output = executeQuery('ad.insertAd', $obj);

			unset($obj);

			// 캐시 파일 업데이트
			$obj->start_date = date('Ymd').'000000';
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $module_srl;
			$obj->no_page = 'Y';

			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief 광고 삭제
		 **/
		function deleteAd($document_srl, $delete_document = true, $return_point = true) {
			if(!$document_srl) return;

			$obj->document_srl = $document_srl;

			$oDocumentModel = &getModel('document');
			$oDocument = $oDocumentModel->getDocument($document_srl, $this->grant->manager);

			// 문서 삭제
			if($delete_document) {
				$oDocumentController = &getController('document');
				$oDocumentController->deleteDocument($document_srl);
			}

			$output = executeQuery('ad.deleteAd', $obj);

			// 캐시 파일 업데이트
			$obj->start_date = date('Ymd').'000000';
			$obj->end_date = date('YmdHis');
			$obj->module_srl = $oDocument->get('module_srl');
			$obj->no_page = 'Y';

			$DB = $oAdModel->getAdList($obj);
			$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($obj->module_srl));
			$cache_filename = sprintf('%slist.cache.txt', $cache_path);
			FileHandler::writeFile($cache_filename, base64_encode(serialize($DB->data)));

			return $output;
		}

		/**
		 * @brief 전광판 모듈 => 광고 모듈
		 **/
		function updateModule() {
			$args->old_module = 'linead';
			$args->new_module = 'ad';
			return executeQuery('ad.updateOldModule',$args);
		}

		/**
         *
         * @brief 광고 시간 알림 trigger
         **/
        function triggerNotifyAdTime() {
			// 로그인 상태가 아니면 종료
			$logged_info = Context::get('logged_info');
			if(!$logged_info) return new Object();

			// 특정 모듈이면 종료
			$notNotifyModule = array('addon','admin','widget','editor');
			if(in_array(Context::get('module'),$notNotifyModule)) return new Object();

			// 특정 action이면 종료
			$notNotifyAction = array();
			if(in_array(Context::get('act'),$notNotifyAction) || strpos(Context::get('act'),'dispAdAdmin')) return new Object();

			$MemberSrl = $logged_info->member_srl;
			$UserName = $logged_info->user_name;
			$NickName = $logged_info->nick_name;

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			// communication module의 controller 객체 생성
			$oCommunicationController = &getController('communication');

			// 알림 대상 목록 구함
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			if(!file_exists($cache_filename)) {
				$modules = $oAdModel->getNotifyModules();
				if(!$modules->toBool() || !$modules->data) return new Object();

				$data = $modules->data;

				foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

				$module_srls = join(',',$module_srls);

				// 폴더가 없으면 생성
				if(!is_dir($cache_path)) FileHandler::makedir($cache_path);

				// 캐시 설정
				FileHandler::writeFile($cache_filename, $module_srls);
			} else {
				$module_srls = trim(FileHandler::readFile($cache_filename));
			}

			if(!$module_srls) return new Object();

			// 알림 대상 목록 구하기
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%s%snotify_ad.cache.txt', $cache_path, getNumberingPath($MemberSrl));

			// 캐시 파일이 있으면 읽어 들이고 없으면 DB에서 찾기
			if(!file_exists($cache_filename)) {
				$args->module_srl = $module_srls;
				$args->member_srl = $logged_info->member_srl;
				$args->end_date = date('YmdHis');
				$list = $oAdModel->getAdNotifyList($args);

				// 캐시 파일 쓰기
				FileHandler::writeFile($cache_filename, serialize($notifyList));

				// 오류가 발생하거나 알림 대상 목록 결과가 없으면 종료
				if(!$list->toBool() || !$list->data) return new Object();
			} else {
				// 캐시 파일 읽기
				$notifyList = unserialize(FileHandler::readFile($cache_filename));
			}

			// 알림 대상 목록 결과가 있으면 쪽지 보내기
			if($notifyList && count($notifyList)>0) {
				// 관리자 member srl 구함
				$AdminUser = $oAdModel->getAdminMemberSrl();
				// 언어별 쪽지 제목 / 내용 구함
				$notifyTitle = Context::getLang('notify_title');
				$notifyContent = Context::getLang('notify_content');
				foreach($notifyList as $key => $val) {
					// 쪽지 제목 / 내용 지정
					$msgTitle = $notifyTitle['typeA'];
					$msgContent = sprintf($notifyContent['typeA'],$NickName,$NickName,$val->getAdContent(),zdate($val->get('regdate')),zdate($val->get('end_date')));
					// 쪽지 보내기
					$oCommunicationController->sendMessage($AdminUser, $MemberSrl, $msgTitle, $msgContent, false);
					// 광고 삭제
					$this->deleteAd($val->document_srl, true, false);
				}
				// 캐시 파일 재생성
				FileHandler::writeFile($cache_filename, 'N;');
			}
			return new Object();
		}

        /**
         * @brief 모듈이 삭제될때 등록된 모든 광고를 삭제하는 trigger
         **/
        function triggerDeleteModuleAds(&$obj) {
            $module_srl = $obj->module_srl;
            if(!$module_srl) return new Object();

			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

            // 등록된 광고 목록 구하기 (delete 쿼리가 다중 테이블 select를 지원하지 않아서 어쩔 수 없음)
			$args->module_srl = $module_srl;
			$args->no_page = 'Y';
			$args->select_document_srl = 'Y';
			$output = $oAdModel->getAdList($args);
			if(!$output->toBool()) return $output;

			unset($args);

			if($output->data) {
				foreach($output->data as $key => $val) $document_srls[] = $val->document_srl;

				// 캐시 파일 삭제
				$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($val->get('module_srl')));
				if(is_dir($cache_path)) FileHandler::removeDir($cache_path);

				// 광고 삭제
				$args->document_srls = join(',',$document_srls);
				$output = executeQuery('ad.deleteModuleAds',$args);
			    if(!$output->toBool()) return $output;
			}

            // 캐시 파일 재생성
			$cache_path = './files/cache/ad/';
			$cache_filename = sprintf('%snotify_modules.cache.txt', $cache_path);

			$modules = $oAdModel->getNotifyModules();
			if(!$modules->toBool() || !$modules->data) return new Object();

			$data = $modules->data;

			foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

			$module_srls = join(',',$module_srls);

			// 폴더가 없으면 생성
			if(!is_dir($cache_path)) FileHandler::makedir($cache_path);

			// 캐시 설정
			FileHandler::writeFile($cache_filename, $module_srls);

            return new Object();
        }

        /**
         * @brief 통계 추가
         **/
		function insertStatistics($obj) {
		}

        /**
         * @brief 추가 기능 목록 캐싱 (adModel::getPluginList)
         * 추가 기능 목록의 경우 DB query + Xml Parsing 때문에 캐싱 파일을 이용하도록 함
         **/
        function makePluginCache($filter_enabled = true) {
            $oAdModel = &getModel('ad');

            if($filter_enabled) $args->enabled = "Y";
            
			$output = executeQuery('ad.getPluginList', $args);
            $db_list = $output->data;

            // 파일 목록을 구함
            $downloaded_list = FileHandler::readDir(_XE_PATH_.'modules/ad/plugins');

            // 로그인 여부 및 소속 그룹 구함
            $is_logged = Context::get('is_logged');
            if($is_logged) {
                $logged_info = Context::get('logged_info');
                if($logged_info->group_list && is_array($logged_info->group_list)) {
                    $group_list = array_keys($logged_info->group_list);
                } else $group_list = array();
            }

            // DB 목록을 loop돌면서 xml정보까지 구함
            if(!is_array($db_list)) $db_list = array($db_list);
            foreach($db_list as $plugin) {
                $plugin_name = $plugin->component_name;
                if(!$component_name) continue;

                if(!in_array($plugin_name, $downloaded_list)) continue;

                unset($xml_info);
                $xml_info = $oAdModel->getPluginXmlInfo($plugin_name);
                $xml_info->enabled = $plugin->enabled;

                if($plugin->extra_vars) {
                    $extra_vars = unserialize($plugin->extra_vars);

                    // 사용 권한이 있으면 권한 체크
                    if($extra_vars->target_group) {
                        // 사용 권한이 체크되어 있는데 로그인이 되어 있지 않으면 무조건 사용 중지
                        if(!$is_logged) continue;

                        // 대상 그룹을 구해서 현재 로그인 사용자의 그룹과 비교
                        $target_group = $extra_vars->target_group;
                        unset($extra_vars->target_group);

                        $is_granted = false;
                        foreach($group_list as $group_srl) {
                            if(in_array($group_srl, $target_group)) {
                                $is_granted = true;
                                break;
                            }
                        }
                        if(!$is_granted) continue;
                    }

                    // 대상 모듈이 있으면 체크
                    if($extra_vars->mid_list && count($extra_vars->mid_list) && Context::get('mid')) {
                        if(!in_array(Context::get('mid'), $extra_vars->mid_list)) continue;
                    }

                    // 추가 기능의 설정 정보를 체크
                    if($xml_info->extra_vars) {
                        foreach($xml_info->extra_vars as $key => $val) {
                            $xml_info->extra_vars->{$key}->value = $extra_vars->{$key};
                        }
                    }
                }

                $plugin_list->{$plugin_name} = $xml_info;
            }

            // enabled만 체크하도록 하였으면 그냥 return
            if($filter_enabled) {
                $cache_file = $oAdModel->getPluginCacheFile($filter_enabled);
                $buff = sprintf('<?php if(!defined("__ZBXE__")) exit(); $plugin_list = unserialize("%s"); ?>', str_replace('"','\\"',serialize($plugin_list)));
                FileHandler::writeFile($cache_file, $buff);
                return $plugin_list;
            }

            // 다운로드된 목록의 xml_info를 마저 구함
            foreach($downloaded_list as $plugin_name) {
                // 설정된 것이라면 패스
                if($plugin_list->{$plugin_name}) continue;

                // DB에 입력
                $oAdAdminController = &getAdminController('ad');
                $oAdAdminController->insertPlugin($plugin_name, false);

                // plugin_list에 추가
                unset($xml_info);
                $xml_info = $oAdModel->getPluginXmlInfo($plugin_name);
                $xml_info->enabled = 'N';

                $plugin_list->{$plugin_name} = $xml_info;
            }

            $cache_file = $oAdModel->getPluginCacheFile($filter_enabled, $site_srl);
            $buff = sprintf('<?php if(!defined("__ZBXE__")) exit(); $plugin_list = unserialize("%s"); ?>', str_replace('"','\\"',serialize($plugin_list)));
            FileHandler::writeFile($cache_file, $buff);

            return $plugin_list;
        }

        /**
         * @brief 캐시 파일 삭제
         **/
        function removeCache() {
            $AdModel = &getModel('ad');
            FileHandler::removeFile($oAdModel->getPluginCacheFile(true));
            FileHandler::removeFile($oAdModel->getPluginCacheFile(false));
        }
    }
?>
