<?php
    /**
     * @class  ad
     * @author SMaker (dowon2308@paran.com)
     * @brief  high class of ad module
     **/

	/**
	 * @brief print ad image function
	 */
	 function XE_ad_image($document_srl = 0, $width = 100, $height = 100) {
	 }

	/**
	 * @brief print ad content function
	 */
	 function XE_ad_content($document_srl = 0, $width = 100, $height = 100) {
	 }

	/**
	 * @brief if not exists 'date_parse' function, create 'date_parse' function
	 * @return info of date (second, minute, hour, month, year, …)
	 */
	if(!function_exists('date_parse')) {
		function date_parse($date) {
			$dateInfo= getdate(strtotime($date));
			$dateInfo['second'] = $dateParse['seconds'];
			$dateInfo['minute'] = $dateParse['minutes'];
			$dateInfo['hour'] = $dateParse['hours'];
			$dateInfo['month'] = $dateParse['mon'];
			return array(
				'second' => $dateInfo['seconds'],
				'minute' => $dateInfo['minutes'],
				'hour' => $dateInfo['hours'],
				'month' => $dateInfo['mon'],
				'year' => $dateInfo['year']
			);
		}
	}

	/**
	 * @brief if not exists 'cal_days_in_month' function, create 'cal_days_in_month' function
	* @return max day of month
	 */
	if(!function_exists('cal_days_in_month')) {
		if(!defined('CAL_GREGORIAN')) define('CAL_GREGORIAN', '');
		function cal_days_in_month($calendar , $month , $year) {
			if(checkdate($month, 31, $year)) return 31;
			if(checkdate($month, 30, $year)) return 30;
			if(checkdate($month, 29, $year)) return 29;
			if(checkdate($month, 28, $year)) return 28;
		}
	}

    class ad extends ModuleObject {

        // search option for admin page
        var $search_option = array('content','user_id','member_srl','user_name','nick_name','is_notice','tags','click_count','regdate','ipaddress');

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
			$oModuleController = &getController('module');
			$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');
			$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');

			return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
			$oDB = &DB::getInstance();
			$oAdModel =  &getModel('ad');

			// check field missing
			if(!$oDB->isColumnExists('ad', 'start_date')) return true;
			if(!$oDB->isColumnExists('ad', 'style')) return true;

			// check old linead module info
			if(is_object($oAdModel->getOldConfig())) return true;

			// check old linead module
			if($oAdModel->isExistsOldModule()) return true;

			// check trigger
            $oModuleModel = &getModel('module');
			if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after')) return true;
			if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before')) return true;

			return false;
        }

        /**
         * @brief execute update
         **/
        function moduleUpdate() {
			$oDB = &DB::getInstance();
			$oAdModel = &getModel('ad');
			$oAdController = &getController('ad');
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');

			// check field missing
			if(!$oDB->isColumnExists('ad', 'start_date')) {
				$oDB->addColumn('ad', 'start_date', 'date', '', '');
				$oDB->addIndex('ad', 'idx_start_date', 'start_date');
			}

			if(!$oDB->isColumnExists('ad', 'style')) $oDB->addColumn('ad', 'style', 'text', '', '');

			// if exists old linead module info, execute update
			$OldConfig = $oAdModel->getOldConfig();
			if($OldConfig) {
				// first, save the old module config
				$module_srl = $OldConfig->module_srl;

				// change old linead module to ad module
				$oAdController->updateModule();

				// save need config.
				$config_args->ad_point = $OldConfig->ad_point;
				$config_args->daily_limit = $OldConfig->daily_limit;
				$oModuleController->insertModulePartConfig('ad',$module_srl,$config_args);

				// delete old config
				$args->module = 'linead';
	            $output = executeQuery('module.deleteModuleConfig', $args);
		        if(!$output->toBool()) return $output;
			}

			if($oAdModel->isExistsOldModule()) {
				$oAdController->updateModule();
			}

			// trigger for ad notify feature
			if(!$oModuleModel->getTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after'))
				$oModuleController->insertTrigger('moduleHandler.init', 'ad', 'controller', 'triggerNotifyAdTime', 'after');

			// trigger for delete ads
			if(!$oModuleModel->getTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before'))
				$oModuleController->insertTrigger('module.deleteModule', 'ad', 'controller', 'triggerDeleteModuleAds', 'before');

			return new Object(0,'success_updated');
        }

        /**
         * @brief recompile cache file
         **/
        function recompileCache() {
			// get model class of ad module
			$oAdModel = &getModel('ad');

			// get notify target list
			$output = $oAdModel->getNotifyModules();
			if(!$output->toBool() || !$output->data) return;

			$data = $output->data;

			$module_srls = array();

			foreach($data as $key => $val) if($val->value == 'Y') $module_srls[] = $val->module_srl;

			$module_list = $module_srls;
			$module_srls = join(',',$module_srls);

			foreach($module_list as $k => $module_srl) {
				// get ad list
				$args->module_srl = $module_srls;
				$args->no_page = 'Y';
				$output = $oAdModel->getAdList($args);
				if(!$output->toBool() || !$output->data) return;

				// set cache file
				$cache_path = sprintf('./files/cache/ad/%s/',getNumberingPath($module_srl));
				FileHandler::makedir($cache_path);

				// write cache file
		        $cache_filename = sprintf('%slist.cache.txt', $cache_path);
			    FileHandler::writeFile($cache_filename, base64_encode(serialize($output->data)));
			}
        }
    }
?>
