<?php
    /**
     * @class  AdView
     * @author SMaker (dowon2308@paran.com)
     * @brief  Ad 모듈의 view 클래스
     **/

    class adView extends ad {

        /**
         * @brief 초기화
         **/
        function init() {
			$oAdModel = &getModel('ad');

			Context::set('oAdModel',$oAdModel);
            /**
             * 스킨 경로를 미리 template_path 라는 변수로 설정함
             * 스킨이 존재하지 않는다면 xe_default로 변경
             **/
            $template_path = sprintf('%sskins/%s/',$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)) {
                $this->module_info->skin = 'xe_default';
                $template_path = sprintf('%sskins/%s/',$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);

			// ad module에서 공통으로 쓰이는 js 파일 로드
			Context::addJsFile($this->module_path.'tpl/js/ad.js');
        }

        /**
         * @brief 광고 컨텐츠 출력
         **/
        function dispAdContent() {
			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'documents.list_order';
            $args->order_type = 'asc';
			$args->end_date = date('YmdHis');

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('ad_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('content');
        }

        /**
         * @brief 광고 등록
         **/
        function dispAdRegister() {
			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'documents.list_order';
            $args->order_type = 'asc';

			// Javascript Filter 적용
			Context::AddJsFilter($this->module_path.'tpl/filter', 'register_ad.xml');

            $this->setTemplateFile('register');
        }

        /**
         * @brief 사용자 광고 목록
         **/
        function dispAdList() {
			// ad module의 model 객체 생성
			$oAdModel = &getModel('ad');

			// 로그인 정보를 구함
			$logged_info = Context::get('logged_info');

			// 로그인 상태가 아니라면 에러
			if(!$logged_info) return new Object(-1, 'msg_please_login');

			// 목록을 구하기 위한 대상 모듈에 대한 옵션 설정
			$args->module_srl = $this->module_srl;
			$args->member_srl = $logged_info->member_srl;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'documents.list_order';
            $args->order_type = 'asc';
			$args->end_date = date('YmdHis');

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('ad_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('list');
        }
    }
?>
