<?php
    /**
     * @class  AdAdminView
     * @author SMaker (dowon2308@paran.com)
     * @brief  admin view class of ad module
     **/

    class adAdminView extends ad {

        /**
         * @brief init
         **/
        function init() {
            // grant check
            $oMemberModel = &getModel('member');
            $logged_info = $oMemberModel->getLoggedInfo();

            // if logged member is not adminstrator
            if($logged_info->is_admin!='Y') return $this->stop('msg_is_not_administrator');

            // module_srl이 있으면 미리 체크하여 존재하는 모듈이면 module_info 세팅
            $module_srl = Context::get('module_srl');
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set('module_srl', $module_srl);
            }

            // create module model
            $oModuleModel = &getModel('module');

            // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                if(!$module_info) {
                    Context::set('module_srl','');
                    $this->act = 'list';
                } else {
                    ModuleModel::syncModuleToSite($module_info);
                    $this->module_info = $module_info;
                    Context::set('module_info',$module_info);
                }
            }

			// 모듈 정보가 있고 요청된 모듈이 ad가 아니면 에러
            if($module_info && strtolower($module_info->module) != 'ad') return $this->stop('msg_invalid_request');

			if(strtolower(Context::get('module')) != 'ad') {
				if(function_exists('getNotEncodeUrl')) $refreshURL = getNotEncodeUrl('module','ad');
				elseif(function_exists('getNotEncodedUrl')) $refreshURL = getNotEncodedUrl('module','ad');
				else $refreshURL = getUrl('module','ad');
				header('location:'.$refreshURL);
				exit;
			}

			// get default config
			$oAdModel = &getModel('ad');
			$config = $oAdModel->getConfig();
			Context::set('config', $config);

			// get module version
			//Context::set('currentVersion',$oAdModel->getVersionImg());

            // get module categories
            $module_category = $oModuleModel->getModuleCategories();
            Context::set('module_category', $module_category);

            // set template path
            $template_path = sprintf('%stpl/',$this->module_path);
            $this->setTemplatePath($template_path);

			// load common css / js file
			Context::addCssFile($this->module_path.'tpl/css/ad_admin.css');
			Context::addJsFile($this->module_path.'tpl/js/ad_admin.js');

			// change layout
			$this->setLayoutPath($this->getTemplatePath());
			$this->setLayoutFile('DashboardLayout.html');

			// get dashboard layout menu
			$this->dashboard_menus = Context::getLang('dashboard_menus');
			unset($this->dashboard_menus['PluginSetup']);
			Context::set('dashboard_menus', $this->dashboard_menus);

			// set browser title
			Context::setBrowserTitle(Context::getLang('ad_module'));
        }

		function dispAdAdminDashBoard() {
			// create ad module model
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->list_count = 10;
			$args->page_count = 1;

			// 오늘 등록된 광고만 뽑아오기
			$args->start_regdate = date('Ymd').'000000';

            // set sort index
            $args->sort_index = 'list_order';
            $args->order_type = 'asc';

			// except notice
			$args->is_notice = 'N';

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('today_ad', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('dashboard'));

			// 템플릿 파일 지정
			$this->setTemplateFile('_dashboard');
		}

		function dispAdAdminConfig() {
			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','insert_config.xml');

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['DefaultSetup']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('Config');
		}

        /**
         * @brief 광고 목록
         **/
        function dispAdAdminList() {
            $oModuleModel = &getModel('module');
			$oAdModel = &getModel('ad');

			if(Context::get('is_total') != 'Y') $args->module_srl = $this->module_srl;

			// 목록을 구하기 위한 대상 모듈/ 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->page = Context::get('page');
			$args->list_count = $module_info->list_count;
			$args->page_count = $module_info->page_count;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'list_order';
            $args->order_type = 'asc';

			// 공지는 제외
			$args->is_notice = 'N';

            // 만약 검색어가 있으면 list_count를 search_list_count 로 이용
            if($args->search_keyword) $args->list_count = $this->search_list_count;

            // 일반 글을 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('ad_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿에서 사용할 변수를 Context::set()
            if($this->module_srl) Context::set('module_srl',$this->module_srl);
			Context::set('module_info',$this->module_info);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageAd']['title']);

			// 템플릿 파일 지정
            $this->setTemplateFile('AdList');
        }

        /**
         * @brief  광고 모듈 목록
         **/
		function dispAdAdminModuleList() {
            // 등록된 ad 모듈을 불러와 세팅
            $args->sort_index = 'module_srl';
            $args->page = Context::get('page');
            $args->list_count = 20;
            $args->page_count = 10;
            $args->s_module_category_srl = Context::get('module_category_srl');
            $output = executeQueryArray('ad.getAdModuleList', $args);
            ModuleModel::syncModuleToSite($output->data);

            // 템플릿에 쓰기 위해서 context::set
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('board_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title']);

            // 템플릿 파일 지정
            $this->setTemplateFile('ModuleList');
		}

        /**
         * @brief 선택된 광고 모듈의 정보 출력 (바로 정보 입력으로 변경)
         **/
        function dispAdAdminModuleInfo() {
			$this->dispAdAdminInsertModule();
        }

        /**
         * @brief 광고 모듈 추가 폼 출력
         **/
        function dispAdAdminInsertModule() {
            if(!in_array($this->module_info->module, array('admin', 'ad'))) return new Object(-1, 'msg_invalid_request');

            // 스킨 목록을 구해옴
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록을 구해옴
            $oLayoutModel = &getModel('layout');
            $layout_list = $oLayoutModel->getLayoutList();
            Context::set('layout_list', $layout_list);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','insert_module.xml');

			// module_srl의 유무에 따른 브라우저 제목 지정
			if(Context::get('module_srl')) Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_module_setup'));
			else Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_make_module'));

            // 템플릿 파일 지정
            $this->setTemplateFile('ModuleInsert');
        }

        /**
         * @brief 광고 모듈 삭제 화면 출력
         **/
        function dispAdAdminDeleteModule() {
            if(!Context::get('module_srl')) return $this->dispAdAdminModuleList();
            if(!in_array($this->module_info->module, array('admin', 'ad'))) return new Object(-1, 'msg_invalid_request');

            $module_info = Context::get('module_info');

			// 광고 갯수 구함
            $oAdModel = &getModel('ad');
            $ad_count = $oAdModel->getAdCount($module_info->module_srl);
            $module_info->ad_count = $ad_count;

            Context::set('module_info',$module_info);

			// Javascript Filter 적용
			Context::addJsFilter($this->module_path.'tpl/filter/','delete_module.xml');

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_delete_module'));

            // 템플릿 파일 지정
            $this->setTemplateFile('ModuleDelete');
        }

        /**
         * @brief 권한 목록 출력
         **/
        function dispAdAdminGrantInfo() {
            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $grant_content = $oModuleAdminModel->getModuleGrantHTML($this->module_info->module_srl, $this->xml_info->grant);
            Context::set('grant_content', $grant_content);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title'].' > '.Context::getLang('cmd_manage_grant'));

			// 템플릿 파일 지정
            $this->setTemplateFile('GrantList');
        }

        /**
         * @brief 스킨 정보 보여줌
         **/
        function dispAdAdminSkinInfo() {
            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $skin_content = $oModuleAdminModel->getModuleSkinHTML($this->module_info->module_srl);
            Context::set('skin_content', $skin_content);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageModule']['title'].' > '.Context::getLang('cmd_manage_skin'));

            $this->setTemplateFile('SkinInfo');
        }

        /**
         * @brief 공지 관리
         **/
        function dispAdAdminNoticeList() {
            $oModuleModel = &getModel('module');
			$oAdModel = &getModel('ad');

			// 목록을 구하기 위한 페이지 수/ 목록 수/ 페이지 목록 수에 대한 옵션 설정
			$args->page = Context::get('page');
			$args->list_count = $module_info->list_count;
			$args->page_count = $module_info->page_count;

            // 검색과 정렬을 위한 변수 설정
            $args->search_target = Context::get('search_target');
            $args->search_keyword = Context::get('search_keyword');

            // 지정된 정렬값이 없다면 정렬 값을 지정함
            $args->sort_index = 'list_order';
            $args->order_type = 'asc';

            // 만약 검색어가 있으면 list_count를 search_list_count 로 이용
            if($args->search_keyword) $args->list_count = $this->search_list_count;

			$args->is_notice = 'Y';

            // 공지를 구해서 context set
            $output = $oAdModel->getAdList($args);
            Context::set('notice_list', $output->data);
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['ManageNotice']['title']);

			// 템플릿 파일 지정
            $this->setTemplateFile('NoticeIndex');
        }

        /**
         * @brief 공지 등록
         **/
        function dispAdAdminNoticeWrite() {
			if(!Context::get('module_srl')) {
				// 등록된 ad 모듈을 불러와 세팅
				$args->sort_index = 'module_srl';
				$args->page = Context::get('page');
				$args->list_count = 20;
				$args->page_count = 10;
				$args->s_module_category_srl = Context::get('module_category_srl');
				$output = executeQueryArray('ad.getAdModuleList', $args);
				ModuleModel::syncModuleToSite($output->data);

				// 템플릿에 쓰기 위해서 context::set
				Context::set('total_count', $output->total_count);
				Context::set('total_page', $output->total_page);
				Context::set('page', $output->page);
				Context::set('board_list', $output->data);
				Context::set('page_navigation', $output->page_navigation);

				// 브라우저 제목 지정
				Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_insert_notice').' > '.Context::getLang('cmd_select_module'));
			} else {
				// 브라우저 제목 지정
				Context::setBrowserTitle(Context::getBrowserTitle().' > '.Context::getLang('cmd_insert_notice'));

				// module srl로 mid 찾기
				$oModuleModel = &getModel('module');
				$module_info = $oModuleModel->getModuleInfoByModuleSrl((int)Context::get('module_srl'));

				// mid를 찾지 못했다면 에러
				if($module_info->mid) {
					Context::set('mid', $module_info->mid);
					Context::set('module_srl', $module_info->module_srl);
				} else {
					return new Object(-1, 'msg_module_is_not_exists');
				}

				// Apply Javascript Filter
				Context::addJsFilter($this->module_path.'tpl/filter/','insert_notice.xml');
			}

			// 템플릿 파일 지정
            $this->setTemplateFile('NoticeWrite');
        }

        /**
         * @brief 추가 기능 설정
         **/
        function dispAdAdminPluginSetup() {
            // 추가 기능을 구해옴
            $oAdModel = &getModel('ad');
            $plugin_list = $oAdModel->getPluginList(false, $site_srl);

			Context::set('plugin_list', $plugin_list);

			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['PluginSetup']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('PluginIndex');
        }

		/**
         * @brief 도움말
         **/
        function dispAdAdminHelp() {
			// 브라우저 제목 지정
			Context::setBrowserTitle(Context::getBrowserTitle().' > '.$this->dashboard_menus['help']['title']);

			// 템플릿 파일 지정
			$this->setTemplateFile('Help');
        }
    }
?>
