<?php
    /**
     * @class  counter
     * @author NHN (developers@xpressengine.com)
     * @brief  counter 모듈의 high class
     **/

    class counter extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            $oCounterController = &getController('counter');

            // 0 일자로 기록될 전체 방문 기록 row 추가
            //$oCounterController->insertTotalStatus();

            // 오늘자 row입력
            //$oCounterController->insertTodayStatus();

            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
	    $db_info = Context::getDbInfo ();
            // 카운터에 site_srl추가
            $oDB = &DB::getInstance();
            if(!$oDB->isColumnExists('counter_log', 'site_srl')) return true;
            if ($db_info->db_type == 'cubrid') {
              if(!$oDB->isIndexExists('counter_log', $oDB->prefix.'counter_log_idx_site_counter_log')) return true;
            }
            else {
              if(!$oDB->isIndexExists('counter_log','idx_site_counter_log')) return true;
	    }
            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $db_info = Context::getDBInfo ();
            // 카운터에 site_srl추가
            $oDB = &DB::getInstance();
            if(!$oDB->isColumnExists('counter_log', 'site_srl')) 
                $oDB->addColumn('counter_log','site_srl','number',11,0,true);
            if ($db_info->db_type == 'cubrid') {
              if(!$oDB->isIndexExists('counter_log',$oDB->prefix.'counter_log_idx_site_counter_log')) 
                  $oDB->addIndex('counter_log',$oDB->prefix.'counter_log_idx_site_counter_log',array('site_srl','ipaddress'),false);
            }
            else {
              if(!$oDB->isIndexExists('counter_log','idx_site_counter_log')) 
                  $oDB->addIndex('counter_log','idx_site_counter_log',array('site_srl','ipaddress'),false);
            }

            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }
    }
?>
