<?php
    /**
     * @file   modules/install/lang/jp.lang.php
     * @author zero (zero@nzeo.com) 翻訳：RisaPapa(risapapa@gmail.com)、ミニミ
     * @brief  日本語言語パッケージ（基本的な内容のみ）
     **/

    $lang->introduce_title = 'XEのインストール';
    $lang->license = <<<EndOfLicense
このプログラムは、フリーソフトウェアであり、GPLに従うものとします。
正し、デザインのスキンは、スキン作者が個別的に異なるライセンスを適用することが出来ます。
翻訳文と原文との内容に相違点がある場合は、原文の内容に従うものとします。

<b>GNU 一般公衆利用許諾契約書</b> -  翻訳文
バージョン 2、1991年6月
Copyright (C) 1989, 1991 Free Software Foundation, Inc.  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
この利用許諾契約書を、一字一句そのままに複製し頒布することは許可する。しかし変更は認めない。

はじめに

ソフトウェア向けライセンスの大半は、あなたがそのソフトウェアを共有したり変更したりする自由を奪うように設計されています。対照的に、GNU 一般公衆利用許諾契約書は、あなたがフリーソフトウェアを共有したり変更したりする自由を保証する--すなわち、ソフトウェアがそのユーザすべてにとってフリーであることを保証することを目的としています。この一般公衆利用許諾契約書はフリーソフトウェア財団のソフトウェアのほとんどに適用されており、また GNU GPLを適用すると決めたフリーソフトウェア財団以外の作者によるプログラムにも適用されています(いくつかのフリーソフトウェア財団のソフトウェアには、GNU GPLではなくGNU ライブラリ一般公衆利用許諾契約書が適用されています)。あなたもまた、ご自分のプログラムにGNU GPLを適用することが可能です。

私たちがフリーソフトウェアと言うとき、それは利用の自由について言及しているのであって、価格は問題にしていません。私たちの一般公衆利用許諾契約書は、あなたがフリーソフトウェアの複製物を頒布する自由を保証するよう設計されています(希望に応じてその種のサービスに手数料を課す自由も保証されます)。また、あなたがソースコードを受け取るか、あるいは望めばそれを入手することが可能であるということ、あなたがソフトウェアを変更し、その一部を新たなフリーのプログラムで利用出来るということ、そして、以上で述べたようなことが出来るということがあなたに知らされるということも保証されます。

あなたの権利を守るため、私たちは誰かがあなたの有するこれらの権利を否定することや、これらの権利を放棄するよう要求することを禁止するという制限を加える必要があります。よって、あなたがソフトウェアの複製物を頒布したりそれを変更したりする場合には、そういった制限のためにあなたにある種の責任が発生することになります。

例えば、あなたがフリーなプログラムの複製物を頒布する場合、有料か無料に関わらず、あなたは自分が有する権利を全て受領者に与えなければなりません。また、あなたは彼らもソースコードを受け取るか手に入れることが出来るよう保証しなければなりません。そして、あなたは彼らに対して以下で述べる条件を示し、彼らに自らの持つ権利について知らしめるようにしなければなりません。

私たちはあなたの権利を二段階の手順を踏んで保護します。(1) まずソフトウェアに対して著作権を主張し、そして (2) あなたに対して、ソフトウェアの複製や頒布または改変についての法的な許可を与えるこの契約書を提示します。

また、各作者や私たちを保護するため、私たちはこのフリーソフトウェアには何の保証も無いということを誰もが確実に理解するようにし、またソフトウェアが誰か他人によって改変され、それが次々と頒布されていったとしても、その受領者は彼らが手に入れたソフトウェアがオリジナルのバージョンでは無いこと、そして原作者の名声は他人によって持ち込まれた可能性のある問題によって影響されることがないということを周知させたいと思います。

最後に、ソフトウェア特許がいかなるフリーのプログラムの存在にも不断の脅威を投げかけていますが、私たちは、フリーなプログラムの再頒布者が個々に特許ライセンスを取得することによって、事実上プログラムを独占的にしてしまうという危険を避けたいと思います。こういった事態を予防するため、私たちはいかなる特許も誰もが自由に利用出来るようライセンスされるか、全くライセンスされないかのどちらかでなければならないことを明確にしました。

複製や頒布、改変についての正確な条件と制約を以下で述べていきます。

複製、頒布、改変に関する条件と制約

0. この利用許諾契約書は、そのプログラム(またはその他の著作物)をこの一般公衆利用許諾契約書の定める条件の下で頒布出来る、という告知が著作権者によって記載されたプログラムまたはその他の著作物全般に適用される。以下では、「『プログラム』」とはそのようにしてこの契約書が適用されたプログラムや著作物全般を意味し、また「『プログラム』を基にした著作物」とは『プログラム』やその他著作権法の下で派生物と見なされるもの全般を指す。すなわち、『プログラム』かその一部を、全く同一のままか、改変を加えたか、あるいは他の言語に翻訳された形で含む著作物のことである(「改変」という語の本来の意味からはずれるが、以下では翻訳も改変の一種と見なす)。それぞれの契約者は「あなた」と表現される。

複製や頒布、改変以外の活動はこの契約書ではカバーされない。それらはこの契約書の対象外である。『プログラム』を実行する行為自体に制限はない。また、そのような『プログラム』の出力結果は、その内容が『プログラム』を基にした著作物を構成する場合のみこの契約書によって保護される(『プログラム』を実行したことによって作成されたということとは無関係である)。このような線引きの妥当性は、『プログラム』が何をするのかに依存する。

1. それぞれの複製物において適切な著作権表示と保証の否認声明(disclaimer of warranty)を目立つよう適切に掲載し、またこの契約書および一切の保証の不在に触れた告知すべてをそのまま残し、そしてこの契約書の複製物を『プログラム』のいかなる受領者にも『プログラム』と共に頒布する限り、あなたは『プログラム』のソースコードの複製物を、あなたが受け取った通りの形で複製または頒布することが出来る。媒体は問わない。

あなたは、物理的に複製物を譲渡するという行為に関して手数料を課しても良いし、希望によっては手数料を取って交換における保護の保証を提供しても良い。

2. あなたは自分の『プログラム』の複製物かその一部を改変して『プログラム』を基にした著作物を形成し、そのような改変点や著作物を上記第1節の定める条件の下で複製または頒布することが出来る。ただし、そのためには以下の条件すべてを満たしていなければならない:

a) あなたがそれらのファイルを変更したということと変更した日時が良く 分かるよう、改変されたファイルに告示しなければならない。

b) 『プログラム』またはその一部を含む著作物、あるいは『プログラム』 かその一部から派生した著作物を頒布あるいは発表する場合には、その 全体をこの契約書の条件に従って第三者へ無償で利用許諾しなけれ ばならない。

c) 改変されたプログラムが、通常実行する際に対話的にコマンドを読むよ うになっているならば、そのプログラムを最も一般的な方法で対話的に 実行する際、適切な著作権表示、無保証であること(あるいはあなたが保 証を提供するということ)、ユーザがプログラムをこの契約書で述べた条 件の下で頒布することが出来るということ、そしてこの契約書の複製物 を閲覧するにはどうしたらよいかというユーザへの説明を含む告知が印 刷されるか、あるいは画面に表示されるようにしなければならない(例外 として、『プログラム』そのものは対話的であっても通常そのような告 知を印刷しない場合には、『プログラム』を基にしたあなたの著作物に そのような告知を印刷させる必要はない)。

以上の必要条件は全体としての改変された著作物に適用される。著作物の一部が『プログラム』から派生したものではないと確認出来、それら自身別の独立した著作物であると合理的に考えられるならば、あなたがそれらを別の著作物として分けて頒布する場合、そういった部分にはこの契約書とその条件は適用されない。しかし、あなたが同じ部分を『プログラム』を基にした著作物全体の一部として頒布するならば、全体としての頒布物は、この契約書が課す条件に従わなければならない。というのは、この契約書が他の契約者に与える許可は『プログラム』丸ごと全体に及び、誰が書いたかは関係なく各部分のすべてを保護するからである。

よって、すべてあなたによって書かれた著作物に対し、権利を主張したりあなたの権利に異議を申し立てることはこの節の意図するところではない。むしろ、その趣旨は『プログラム』を基にした派生物ないし集合著作物の頒布を管理する権利を行使するということにある。

また、『プログラム』を基にしていないその他の著作物を『プログラム』(あるいは『プログラム』を基にした著作物)と一緒に集めただけのものを一巻の保管装置ないし頒布媒体に収めても、その他の著作物までこの契約書が保護する対象になるということにはならない。

3. あなたは上記第1節および2節の条件に従い、『プログラム』(あるいは第2節における派生物)をオブジェクトコードないし実行形式で複製または頒布することが出来る。ただし、その場合あなたは以下のうちどれか一つを実施しなければならない:

a) 著作物に、『プログラム』に対応した完全かつ機械で読み取り可能なソー スコードを添付する。ただし、ソースコードは上記第1節および2節の条 件に従いソフトウェアの交換で習慣的に使われる媒体で頒布しなければ ならない。あるいは、

b) 著作物に、いかなる第三者に対しても、『プログラム』に対応した完全 かつ機械で読み取り可能なソースコードを、頒布に要する物理的コスト を上回らない程度の手数料と引き換えに提供する旨述べた少なくとも3年 間は有効な書面になった申し出を添える。ただし、ソースコードは上記 第1節および2節の条件に従いソフトウェアの交換で習慣的に使われる媒 体で頒布しなければならない。あるいは、

c) 対応するソースコード頒布の申し出に際して、あなたが得た情報を一緒 に引き渡す(この選択肢は、営利を目的としない頒布であって、かつあな たが上記小節bで指定されているような申し出と共にオブジェクトコード あるいは実行形式のプログラムしか入手していない場合に限り許可され る)。

著作物のソースコードとは、それに対して改変を加える上で好ましいとされる著作物の形式を意味する。ある実行形式の著作物にとって完全なソースコードとは、それが含むモジュールすべてのソースコード全部に加え、関連するインターフェース定義ファイルのすべてとライブラリのコンパイルやインストールを制御するために使われるスクリプトをも加えたものを意味する。しかし特別な例外として、そのコンポーネント自体が実行形式に付随するのでは無い限り、頒布されるものの中に、実行形式が実行されるオペレーティングシステムの主要なコンポーネント(コンパイラやカーネル等)と通常一緒に(ソースかバイナリ形式のどちらかで)頒布されるものを含んでいる必要はないとする。

実行形式またはオブジェクトコードの頒布が、指定された場所からコピーするためのアクセス手段を提供することで為されるとして、その上でソースコードも同等のアクセス手段によって同じ場所からコピー出来るようになっているならば、第三者がオブジェクトコードと一緒にソースも強制的にコピーさせられるようになっていなくてもソースコード頒布の条件を満たしているものとする。

4. あなたは『プログラム』を、この契約書において明確に提示された行為を除き複製や改変、サブライセンス、あるいは頒布してはならない。他に『プログラム』を複製や改変、サブライセンス、あるいは頒布する企てはすべて無効であり、この契約書の下でのあなたの権利を自動的に終結させることになろう。しかし、複製物や権利をこの契約書に従ってあなたから得た人々に関しては、そのような人々がこの契約書に完全に従っている限り彼らのライセンスまで終結することはない。

5. あなたはこの契約書を受諾する必要は無い。というのは、あなたはこれに署名していないからである。しかし、この契約書以外にあなたに対して『プログラム』やその派生物を改変または頒布する許可を与えるものは存在しない。これらの行為は、あなたがこの契約書を受け入れない限り法によって禁じられている。そこで、『プログラム』(あるいは『プログラム』を基にした著作物全般) を改変ないし頒布することにより、あなたは自分がそのような行為を行うためにこの契約書を受諾したということ、そして『プログラム』とそれに基づく著作物の複製や頒布、改変についてこの契約書が課す制約と条件をすべて受け入れたということを示したものと見なす。

6. あなたが『プログラム』(または『プログラム』を基にした著作物全般)を再頒布するたびに、その受領者は元々のライセンス許可者から、この契約書で指定された条件と制約の下で『プログラム』を複製や頒布、あるいは改変する許可を自動的に得るものとする。あなたは、受領者がここで認められた権利を行使することに関してこれ以上他のいかなる制限も課してはならない。あなたには、第三者がこの契約書に従うことを強制する責任はない。

7. 特許侵害あるいはその他の理由(特許関係に限らない)から、裁判所の判決あるいは申し立ての結果としてあなたに(裁判所命令や契約などにより)このライセンスの条件と矛盾する制約が課された場合でも、あなたがこの契約書の条件を免除されるわけではない。もしこの契約書の下であなたに課せられた責任と他の関連する責任を同時に満たすような形で頒布出来ないならば、結果としてあなたは『プログラム』を頒布することが全く出来ないということである。例えば特許ライセンスが、あなたから直接間接を問わずコピーを受け取った人が誰でも『プログラム』を使用料無料で再頒布することを認めていない場合、あなたがその制約とこの契約書を両方とも満たすには『プログラム』の頒布を完全に中止するしかないだろう。

この節の一部分が特定の状況の下で無効ないし実施不可能な場合でも、節の残りの部分は適用されるよう意図されている。その他の状況では節が全体として適用されるよう意図されている。

特許やその他の財産権を侵害したり、そのような権利の主張の効力に異議を唱えたりするようあなたを誘惑することがこの節の目的ではない。この節には、人々によってライセンス慣行として実現されてきた、フリーソフトウェア頒布のシステムの完全性を護るという目的しかない。多くの人々が、フリーソフトウェアの頒布システムが首尾一貫して適用されているという信頼に基づき、このシステムを通じて頒布される多様なソフトウェアに寛大な貢献をしてきたのは事実であるが、人がどのようなシステムを通じてソフトウェアを頒布したいと思うかはあくまでも作者/寄与者次第であり、あなたが選択を押しつけることは出来ない。

この節は、この契約書のこの節以外の部分の一帰結になると考えられるケースを徹底的に明らかにすることを目的としている。

8. 『プログラム』の頒布や利用が、ある国においては特許または著作権が主張されたインターフェースのいずれかによって制限されている場合、『プログラム』にこの契約書を適用した元の著作権者は、そういった国々を排除した明確な地理的頒布制限を加え、そこで排除されていない国の中やそれらの国々の間でのみ頒布が許可されるようにしても構わない。その場合、そのような制限はこの契約書本文で書かれているのと同様に見なされる。

9. フリーソフトウェア財団は、時によって改訂または新版の一般公衆利用許諾書を発表することが出来る。そのような新版は現在のバージョンとその精神においては似たものになるだろうが、新たな問題や懸念を解決するため細部では異なる可能性がある。

それぞれのバージョンには、見分けが付くようにバージョン番号が振られている。『プログラム』においてそれに適用されるこの契約書のバージョン番号が指定されていて、更に「それ以降のいかなるバージョン(any later version)」も適用して良いとなっていた場合、あなたは従う条件と制約として、指定のバージョンか、フリーソフトウェア財団によって発行された指定のバージョン以降の版のどれか一つのどちらかを選ぶことが出来る。『プログラム』でライセンスのバージョン番号が指定されていないならば、あなたは今までにフリーソフトウェア財団から発行されたバージョンの中から好きに選んで構わない。

10. もしあなたが『プログラム』の一部を、その頒布条件がこの契約書と異なる他のフリーなプログラムと統合したいならば、作者に連絡して許可を求めよ。フリーソフトウェア財団が著作権を保有するソフトウェアについては、フリーソフトウェア財団に連絡せよ。私たちは、このような場合のために特別な例外を設けることもある。私たちが決定を下すにあたっては、私たちのフリーソフトウェアの派生物すべてがフリーな状態に保たれるということと、一般的にソフトウェアの共有と再利用を促進するという二つの目標を規準に検討されるであろう。

無保証について

11. 『プログラム』は代価無しに利用が許可されるので、適切な法が認める限りにおいて、『プログラム』に関するいかなる保証も存在しない。書面で別に述べる場合を除いて、著作権者、またはその他の団体は、『プログラム』を、表明されたか言外にかは問わず、商業的適性を保証するほのめかしやある特定の目的への適合性(に限られない)を含む一切の保証無しに「あるがまま」で提供する。『プログラム』の質と性能に関するリスクのすべてはあなたに帰属する。『プログラム』に欠陥があると判明した場合、あなたは必要な保守点検や補修、修正に要するコストのすべてを引き受けることになる。

12. 適切な法か書面での同意によって命ぜられない限り、著作権者、または上記で許可されている通りに『プログラム』を改変または再頒布したその他の団体は、あなたに対して『プログラム』の利用ないし利用不能で生じた通常損害や特別損害、偶発損害、間接損害(データの消失や不正確な処理、あなたか第三者が被った損失、あるいは『プログラム』が他のソフトウェアと一緒に動作しないという不具合などを含むがそれらに限らない)に一切の責任を負わない。そのような損害が生ずる可能性について彼らが忠告されていたとしても同様である。

条件と制約終わり

<b>GNU 一般公衆利用許諾契約書</b> -  原文

GNU GENERAL PUBLIC LICENSE

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users. This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it. (Some other Free Software Foundation software is covered by the GNU Lesser General Public License instead.) You can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights. These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.

We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software.

Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software. If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations.

Finally, any free program is threatened constantly by software patents. We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary. To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all.

The precise terms and conditions for copying, distribution and modification follow.
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License. The "Program", below, refers to any such program or work, and a "work based on the Program" means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language. (Hereinafter, translation is included without limitation in the term "modification".) Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program). Whether that is true depends on what the Program does.

1. You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program.

You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.

2. You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:

a) You must cause the modified files to carry prominent notices stating that you changed the files and the date of any change. 
b) You must cause any work that you distribute or publish, that in whole or in part contains or is derived from the Program or any part thereof, to be licensed as a whole at no charge to all third parties under the terms of this License. 
c) If the modified program normally reads commands interactively when run, you must cause it, when started running for such interactive use in the most ordinary way, to print or display an announcement including an appropriate copyright notice and a notice that there is no warranty (or else, saying that you provide a warranty) and that users may redistribute the program under these conditions, and telling the user how to view a copy of this License. (Exception: if the Program itself is interactive but does not normally print such an announcement, your work based on the Program is not required to print an announcement.) 

These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program.

In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.

3. You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following:

a) Accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, 
b) Accompany it with a written offer, valid for at least three years, to give any third party, for a charge no more than your cost of physically performing source distribution, a complete machine-readable copy of the corresponding source code, to be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, 
c) Accompany it with the information you received as to the offer to distribute corresponding source code. (This alternative is allowed only for noncommercial distribution and only if you received the program in object code or executable form with such an offer, in accord with Subsection b above.) 

The source code for a work means the preferred form of the work for making modifications to it. For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable. However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.

If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code.

4. You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.

5. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Program or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it.

6. Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License.

7. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all. For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances.

It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice.

This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.

8. If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License.

9. The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.

Each version is given a distinguishing version number. If the Program specifies a version number of this License which applies to it and "any later version", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation.

10. If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.

NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
END OF TERMS AND CONDITIONS





EndOfLicense;

    $lang->install_condition_title = "インストールするための必須条件を確認して下さい。";

    $lang->install_checklist_title = array(
            'php_version' => 'PHPバージョン',
            'permission' => 'パーミッション',
            'xml' => 'XMLライブラリ',
            'iconv' => 'ICONVライブラリ',
            'gd' => 'GDライブラリ',
            'session' => 'Session.auto_startの設定',
        );

    $lang->install_checklist_desc = array(
            'php_version' => '【必須】PHPバージョンが 5.2.2の場合は、PHPのセキュリティバグのため、インストール出来ません。',
            'permission' => '【必須】XEのインストールパスまたは「./files」ディレクトリのパーミッションを「707」に設定して下さい。',
            'xml' => '【必須】XML通信のためにXMLライブラリが必要です',
            'session' => '【必須】XEでは、セッションを使用しているため、「php.ini」の設定を「session.auto_start=0」にして下さい。',
            'iconv' => 'UTF-8と多言語サポート及び文字コード変換のため、「iconv」をインストールする必要があります。',
            'gd' => 'イメージ変換機能を使用するためには、「GDライブラリ」をインストールする必要があります。',
        );

    $lang->install_checklist_xml = 'XMLライブラリのインストール';
    $lang->install_without_xml = 'XMLライブラリがインストールされていません。';
    $lang->install_checklist_gd = 'GDライブラリのインストール';
    $lang->install_without_gd  = 'イメージ変換用のGDライブラリがインストールされていません。';
    $lang->install_checklist_gd = 'GDライブラリのインストール';
    $lang->install_without_iconv = '文字列処理のための「iconv」ライブラリがインストールされていません。';
    $lang->install_session_auto_start = 'PHPの設定で「session.auto_start==1」 にするとセッション処理に問題が発生することがあります。';
    $lang->install_permission_denied = 'インストールする対象ディレクトリのパーミッションが「707」になっていません。';

    $lang->cmd_agree_license = 'ライセンスに同意します。';
    $lang->cmd_install_fix_checklist = 'インストール必須条件を設定しました。';
    $lang->cmd_install_next = 'インストールを続けます。';
    $lang->cmd_ignore = 'FTP設定を省略する';

    $lang->db_desc = array(
        'mysql' => 'MySQL DBでPHPの「mysql*()」関数を利用してデータの入出力を行います。<br />DBは「myisam」タイプで作成されるため、トランザクション処理は出来ません。',
        'mysql_innodb' => 'MySQL DBで「innodb」タイプでデータの入出力を行います。<br />「innodb」ではトランザクションの処理が行えます。',
        'sqlite2' => 'ファイルタイプデータベースである「sqlite2」をサポートします。<br />インストール時、セキュリティのため、DBファイルはウェブがらアクセス出来ない場所に作成して下さい。<br />（安定化までのテストは行われていません）',
        'sqlite3_pdo' => 'PHPのPDOを経由うして「sqlite3」をサポートします。<br />インストール時、セキュリティのため、DBファイルはウェブからアクセス出来ない場所に作成して下さい。',
        'cubrid' => 'CUBRID DBを利用します。 <a href="http://www.xpressengine.com/?mid=manual&pageid=2880556" onclick="window.open(this.href);return false;" class="manual">manual</a>',
        'mssql' => 'MSSQL DBを利用します。',
        'postgresql' => 'PostgreSql DBを利用します。',
        'firebird' => 'Firebird DBを利用します。<br />DB生成方法 (create database "/path/dbname.fdb" page_size=8192 default character set UTF8;)',
    );

    $lang->form_title = 'データベース &amp; 管理者情報入力';
    $lang->db_title = 'データベース情報入力';
    $lang->db_type = 'データベースの種類';
    $lang->select_db_type = '使用するデータベース種類を選択して下さい。';
    $lang->db_hostname = 'ホスト名';
    $lang->db_port = 'ポート番号';
    $lang->db_userid = 'ユーザＩＤ';
    $lang->db_password = 'パスワード';
    $lang->db_database = 'データベース名';
    $lang->db_database_file = 'データベースファイル';
    $lang->db_table_prefix = 'テーブルプレフィックス';

    $lang->admin_title = '管理者情報';

    $lang->env_title = '環境設定';
    $lang->use_optimizer = 'オプティマイザー使用';
    $lang->about_optimizer = 'オプティマイザーを使用すると多数の「CSS/JS」ファイルを、統合・圧縮して転送するのでレスポンスが早くなります。<br />但し、CSSまたはJSファイルによっては問題が生じる場合があります。この場合は、チェックを外すと正常に動作します。';
    $lang->use_rewrite = 'リライト・モジュールを使用';
    $lang->about_rewrite = 'Webサーバで「リライト・モジュール（mod_rewrite）」をサポートしている場合は、「http://アドレス/?document_srl=123」のようなアドレスを動的だけど「http://アドレス/123」のように静的なページに見せることが出来ます。';
    $lang->time_zone = 'タイムゾーン';
    $lang->about_time_zone = 'サーバの設定時間とサービスしているローカル時間との差がある場合、タイムゾーンを指定して表示時間を合わせることが出来ます。';
    $lang->qmail_compatibility = 'Qmail 互換';
    $lang->about_qmail_compatibility = 'Qmail等、CRLFを改行コードとして認識出来ないMTA（Message Transfer Agent）で、メールの送信が出来るようにします。';

    $lang->about_database_file = 'Sqliteはファイルにデータを保存します。そのため、データベースファイルにはウェブからアクセス出来ない場所にしなければなりません。<br/><span style="color:red">データファイルのパーミッションは「707」に設定して下さい。</span>';

    $lang->success_installed = '正常にインストールされました。';

    $lang->msg_cannot_proc = 'インストール出来る環境が整っていないため、リクエストを実行出来ませんでした。';
    $lang->msg_already_installed = '既にインストールされています。';
    $lang->msg_dbconnect_failed = "データベースアクセスにエラーが発生しました。\nデータベースの情報をもう一度確認して下さい。";
    $lang->msg_table_is_exists = "既にデータベースにデーブルが作成されています。\nconfigファイルを再作成しました。";
    $lang->msg_install_completed = "インストールが完了しました。\nありがとうございます。";
    $lang->msg_install_failed = 'インストールファイルを作成する際にエラーが発生しました。';
?>
