<?php
    /**
     * @file   common/lang/jp.lang.php
     * @author zero (zero@nzeo.com) 翻訳：RisaPapa、ミニミ
     * @brief  日本語言語パッケージ（基本的な実行関連の用語がまとめられている）
     **/

    // 基本的な実行に用いる用語
    $lang->cmd_write = '書き込む';
    $lang->cmd_reply = '返信';
    $lang->cmd_delete = '削除';
    $lang->cmd_modify = '修正';
    $lang->cmd_edit = '編集';
    $lang->cmd_view = '表示';
    $lang->cmd_view_all = 'すべて表示';
    $lang->cmd_list = 'リスト';
    $lang->cmd_prev = '前へ';
    $lang->cmd_next = '次へ';
    $lang->cmd_send_trackback = 'トラックバック送信';
    $lang->cmd_registration = $lang->cmd_submit = '登録';
    $lang->cmd_comment_registration = 'コメント登録';
    $lang->cmd_insert = '挿入';
    $lang->cmd_save = '保存';
    $lang->cmd_load = '読み込む';
    $lang->cmd_input = '入力';
    $lang->cmd_search = '検索';
    $lang->cmd_find = '検索';
    $lang->cmd_replace = '置換';
    $lang->cmd_confirm = '確認';
    $lang->cmd_cancel = '取り消し';
    $lang->cmd_back = '戻る';
    $lang->cmd_vote = '推薦';
    $lang->cmd_vote_down = '非推薦';
    $lang->cmd_declare = '通報';
    $lang->cmd_cancel_declare = '通報取り消し';
    $lang->cmd_declared_list = '通報リスト';
    $lang->cmd_copy = 'コピー';
    $lang->cmd_move = '移動';
    $lang->cmd_move_up = '上へ';
    $lang->cmd_move_down = '下へ';
    $lang->cmd_add_indent = 'インデント';
    $lang->cmd_remove_indent = '逆インデント';
    $lang->cmd_management = '管理';
    $lang->cmd_make = '作成';
    $lang->cmd_select = '選択';
    $lang->cmd_select_all = 'すべて選択';
    $lang->cmd_unselect_all = 'すべて解除';
    $lang->cmd_reverse_all = '選択の反転';
	$lang->cmd_close_all = 'すべて閉じる';
    $lang->cmd_open_all = 'すべて開く';
    $lang->cmd_reload = 'リロード';
    $lang->cmd_close = '閉じる';
    $lang->cmd_open = '開く';
    $lang->cmd_setup = '設定';
    $lang->cmd_addition_setup = '追加設定';
    $lang->cmd_option = 'オプション';
    $lang->cmd_apply = '適用';
    $lang->cmd_open_calendar = 'カレンダーを開く';
    $lang->cmd_send = '送信';
    $lang->cmd_print = '印刷';
    $lang->cmd_scrap = 'スクラップ';
    $lang->cmd_preview = 'プレビュー';
    $lang->cmd_reset = '初期化';
    $lang->cmd_remake_cache = 'キャッシュファイル再生成';
    $lang->cmd_publish = '発行';
    $lang->cmd_layout_setup = 'レイアウト設定';
    $lang->cmd_layout_edit = 'レイアウト編集';
    $lang->cmd_search_by_ipaddress = 'IPアドレスで検索';
    $lang->cmd_add_ip_to_spamfilter = 'スパムフィルターにIPを追加';

    $lang->enable = '可能';
    $lang->disable = '不可';

    // 基本用語
    $lang->menu = 'メニュー';
    $lang->no = '番号';
    $lang->notice = 'お知らせ';
    $lang->secret = '非公開';
    $lang->category = $lang->category_srl = 'カテゴリ';
    $lang->none_category = 'カテゴリ無し';
    $lang->none_image = 'イメージなし';
    $lang->document_srl = '書き込み番号';
    $lang->user_id = 'ユーザーＩＤ';
    $lang->author = '作成者';
    $lang->password = 'パスワード';
    $lang->password1 = 'パスワード';
    $lang->password2 = 'パスワード確認';
    $lang->admin_id = '管理者ＩＤ';
    $lang->writer = '投稿者';
    $lang->user_name = '名前';
    $lang->nick_name = 'ニックネーム';
    $lang->email_address = 'メールアドレス';
    $lang->homepage = 'ホームページ';
    $lang->blog = 'ブログ';
    $lang->birthday = 'お誕生日';
    $lang->browser_title = 'ブラウザータイトル';
    $lang->title = 'タイトル';
    $lang->title_content = 'タイトル＋内容';
    $lang->topic = 'トピック';
    $lang->replies = '返事';
    $lang->content = '内容';
    $lang->document = '書き込み';
    $lang->comment = 'コメント';
    $lang->description = '説明';
    $lang->trackback = 'トラックバック';
    $lang->tag = 'タグ';
    $lang->allow_comment = 'コメント許可';
    $lang->lock_comment = 'コメントロック';
    $lang->allow_trackback = 'トラックバック許可';
    $lang->uploaded_file = '添付';
    $lang->grant = '権限';
    $lang->target = '対象';
    $lang->total = 'すべて';
    $lang->total_count = 'トータル数';
    $lang->ipaddress = 'IPアドレス';
    $lang->path = 'パス';
    $lang->cart = '選択項目';
    $lang->friend = '友達';
    $lang->notify = 'アラート';
    $lang->order_target = 'ソート対象';
    $lang->order_type = 'ソート方法';
    $lang->order_asc = '昇る';
    $lang->order_desc = '降下';
    $lang->file = 'ファイル';

    $lang->mid = 'モジュール名';
    $lang->sid = 'バーチャル（Virtual）サイト名';
    $lang->layout = 'レイアウト';
    $lang->widget = 'ウィジェット';
    $lang->module = 'モジュール';
    $lang->skin = 'スキン';
    $lang->colorset = 'カラーセット';
    $lang->extra_vars = '拡張変数';

    $lang->domain = 'ドメイン';
    $lang->url = 'URL';
    $lang->document_url = '書き込みＵＲＬ';
    $lang->trackback_url = 'トラックバックＵＲＬ';
    $lang->blog_name = 'ブログ名';
    $lang->excerpt = '抜粋';

    $lang->document_count = '書き込み数';
    $lang->page_count = 'ページ数';
    $lang->list_count = 'リスト数';
    $lang->search_list_count = '検索リスト数';
    $lang->readed_count = '閲覧数';
    $lang->voted_count = '推薦数';
    $lang->comment_count = 'コメント数';
    $lang->member_count = '会員数';
    $lang->date = '日付';
    $lang->regdate = '登録日';
    $lang->last_update = '最近修正日';
    $lang->last_post = '最近登録';
    $lang->signup_date = '登録日';
    $lang->last_login = '最近ログイン';
    $lang->first_page = '最初のページ';
    $lang->last_page = '最後のページ';
    $lang->search_target = '検索対象';
    $lang->search_keyword = 'キーワード';
    $lang->is_default = 'デフォルト';

    $lang->no_documents = '登録された書き込みがありません。';

    $lang->board_manager = '掲示板管理';
    $lang->member_manager = '会員管理';
    $lang->layout_manager = 'レイアウト管理';

    $lang->use = '使用';
    $lang->notuse = '未使用';
    $lang->not_exists = 'なし';

    $lang->public = '公開';
    $lang->private = '非公開';

    $lang->unit_sec = '秒';
    $lang->unit_min = '分';
    $lang->unit_hour = '時';
    $lang->unit_day = '日';
    $lang->unit_week = '週';
    $lang->unit_month = '月';
    $lang->unit_year = '年';

    $lang->unit_week = array(
        'Monday' => '月',
        'Tuesday' => '火',
        'Wednesday' => '水',
        'Thursday' => '木',
        'Friday' => '金',
        'Saturday' => '土',
        'Sunday' => '日',
    );

    $lang->unit_meridiem = array(
        'am' => '午前',
        'pm' => '午後',
        'AM' => '午前',
        'PM' => '午後',
    );

    $lang->time_gap = array(
        'min' => '%d 分前',
        'mins' => '%d 分前',
        'hour' => '%d 時間前',
        'hours' => '%d 時間前',
    );

    // 説明関連
    $lang->about_tag = 'タグを入力する時、「,」（半角コンマ）を使うと複数登録出来ます。';
    $lang->about_layout = 'レイアウトでモジュールの枠をデザインします。上段のレイアウトメニューで管理出来ます。';

    // メッセージ関連
    $lang->msg_call_server = 'サーバへ問合わせ中です。しばらくお待ち下さい。';
    $lang->msg_db_not_setted = 'DBが設定されていません。';
    $lang->msg_dbconnect_failed = "データベースアクセスにエラーが発生しました。\nデータベースの情報をもう一度確認して下さい。";
    $lang->msg_invalid_queryid = 'クエリIDの値が無効です。';
    $lang->msg_not_permitted = '権限がありません。';
    $lang->msg_input_password = 'パスワードを入力して下さい。';
    $lang->msg_invalid_document = '無効な書き込み番号です。';
    $lang->msg_invalid_request = '無効なリクエストです。';
    $lang->msg_invalid_password = 'パスワードが正しくありません。';
    $lang->msg_error_occured = 'エラーが発生しました。';
    $lang->msg_not_founded = '見つかりません。';
    $lang->msg_no_result = '検索結果がありません。';
    $lang->msg_fail_to_request_open = 'リクエストのアクセスに失敗しました。';
    $lang->msg_invalid_format = '正しくないフォーマットです。';

    $lang->msg_not_permitted_act = '現在の操作は実行する権限がありません。';
    $lang->msg_module_is_not_exists = "요청하신 모듈을 찾을 수 없습니다.\n사이트 관리자에게 모듈 점검 요청 바랍니다";
    $lang->msg_module_is_not_standalone = 'このモジュールはスタンドアローンでは作動しません。';
    $lang->msg_default_url_is_not_defined = '기본 URL이 정해지지 않아서 동작을 중지합니다';

    $lang->success_registed = '登録しました。';
    $lang->success_declared = '通報しました。';
    $lang->success_updated = '修正しました。';
    $lang->success_deleted = '削除しました。';
    $lang->success_restore = '復元しました。';
    $lang->success_voted = '推薦しました。';
    $lang->success_blamed = '非推薦しました。';
    $lang->success_moved = '移動しました。';
    $lang->success_sended = '送信しました。';
    $lang->success_reset = '初期化しました。';
    $lang->success_leaved = '退会しました。';
    $lang->success_saved = '保存しました。';

    $lang->fail_to_delete = '削除に失敗しました。';
    $lang->fail_to_move = '移動に失敗しました。';

    $lang->failed_voted = '推薦出来ません。';
    $lang->failed_blamed = '非推薦出来ません。';
    $lang->failed_declared = '通報出来ません。';
    $lang->fail_to_delete_have_children = '返信の書き込みがあり、削除出来ません。';

    $lang->confirm_submit = '登録しますか？';
    $lang->confirm_logout = 'ログアウトしますか？';
    $lang->confirm_vote = '推薦しますか？';
    $lang->confirm_delete = '削除しますか？';
    $lang->confirm_restore = '復元しますか？';
    $lang->confirm_move = '移動しますか？';
    $lang->confirm_reset = '初期化しますか？';
    $lang->confirm_leave = '退会しますか？';

    $lang->column_type = 'タイプ';
    $lang->column_type_list['text'] = '入力フィールド(text)';
    $lang->column_type_list['homepage'] = 'URLタイプ(url)';
    $lang->column_type_list['email_address'] = 'メールアドレスタイプ(email)';
    $lang->column_type_list['tel'] = '電話番号タイプ(phone)';
    $lang->column_type_list['textarea'] = 'テキストエリア(textarea)';
    $lang->column_type_list['checkbox'] = 'チェックボックス(checkbox)';
    $lang->column_type_list['select'] = '選択(select)';
    $lang->column_type_list['radio'] = 'ラジオボタン (radio)';
    $lang->column_type_list['kr_zip'] = '韓国住所(zip)';
    $lang->column_type_list['date'] = '日付(年月日)';
    //$lang->column_type_list['jp_zip'] = '日本住所(zip)';
    $lang->column_name = 'コラム名';
    $lang->column_title = 'コラムタイトル';
    $lang->default_value = 'デフォルト値';
    $lang->is_active = '活性化';
    $lang->is_required = '必須項目';
    $lang->eid = '拡張変数名';

    // ftp関連
    $lang->ftp_form_title = 'サーバーのFTP情報の入力';
    $lang->ftp = 'FTP';
    $lang->ftp_port = 'FTPポート番号（port）';
    $lang->cmd_check_ftp_connect = 'FTP接続をテストする';
    $lang->about_ftp_info = "
        FTP情報は次の場合、利用されます。<br />
        1. サーバー側のPHPの設定中、「safe_mode=On」になった際、FTP情報を用いてXEが正常に働くようにします。<br />
        2. FTP経由でXEの自動アップデート等に使われます。<br />
        FTP情報は「files/config/ftp.config.php」の中に保存されます。<br />
        また、XEのインストールの後、管理者画面からFTP情報の変更・削除が可能です。（省略可能） <br />
    ";

    $lang->msg_safe_mode_ftp_needed = 'PHPのsafe_modeがOnの場合、FTP情報を登録することで、XEのインストール及び利用が可能になります。';
    $lang->msg_ftp_not_connected = 'localhostへのFTP接続エラーが発生しました。FTPポート(port)番号をはじめ、FTPサービスが可能であるかをご確認下さい。';
    $lang->msg_ftp_invalid_auth_info = 'ログインが失敗しました。 FTPアクセス情報を再度ご確認下さい。';
    $lang->msg_ftp_mkdir_fail = 'FTPを用いたディレクトリ生成に失敗しました。FTPサーバーの設定を再度ご確認下さい。';
    $lang->msg_ftp_chmod_fail = 'FTPを用いたディレクトリパーミッション(permission)変更に失敗しました。FTPサーバーの設定を再度ご確認下さい。';
    $lang->msg_ftp_connect_success = 'FTP接続に成功しました。';

    // xml filterで用いられているjavascript用のアラートメッセージ
    $lang->filter->isnull = '%sを入力して下さい。';
    $lang->filter->outofrange = '%sの文字の長さを合わせて下さい。';
    $lang->filter->equalto = '%sが正しくありません。';
    $lang->filter->invalid_email = '%sのパターンが正しくありません。 (例: zbxe@xepressengine.com)';
    $lang->filter->invalid_user_id = $lang->filter->invalid_userid = "%sの形式が正しくありません。\\n半角の英数と記号「_」を組み合わせて入力して下さい。頭字は半角英文字でなければなりません。";
    $lang->filter->invalid_homepage = '%sの形式が正しくありません。 (例: http://www.xepressengine.com)';
    $lang->filter->invalid_korean = '%sの形式が正しくありません。ハングルのみ入力して下さい。';
    $lang->filter->invalid_korean_number = '%sの形式が正しくありません。ハングルと半角数字で入力して下さい。';
    $lang->filter->invalid_alpha = '%sの形式が正しくありません。半角英文字のみ入力して下さい。';
    $lang->filter->invalid_alpha_number = '%sの形式が正しくありません。半角英数で入力して下さい。';
    $lang->filter->invalid_number = '%sの形式が正しくありません。半角数字で入力して下さい。';
?>
