<?php
    /**
     * @class  tccommentnotifier controller
     * @author haneul (haneul0318@gmail.com) 
     * @brief  tccommentnotifier 모듈의 controller class
     **/


    class tccommentnotifyController extends tccommentnotify {
        /**
         * @brief initialization
         **/

        function init() {
        }

        function insertSite($title, $name, $url)
        {
            $id = getNextSequence();
            $args->id = $id;
            $args->title = $title; 
            $args->name = $name; 
            $args->url = $url;
            $output = executeQuery("tccommentnotify.insertSite", $args);
            if(!$output->toBool())
            {
                return -1;
            }
            else
            {
                return $id;
            }
        }

        function insertParent(&$obj, $siteid, $module_srl)
        {
            $parentid = getNextSequence();
            $args->notified_srl = $parentid;
            $args->module_srl = $module_srl;
            $args->name = $obj->r1_name;
            $args->homepage = $obj->r1_homepage;
            $args->written = date('YmdHis', $obj->r1_regdate);
            $args->comment = $obj->r1_body;
            $args->entry = $obj->s_no;
            $args->siteid = $siteid;
            $args->url = $obj->r1_url;
            $args->remoteid = $obj->r1_no;
            $args->entrytitle = $obj->s_post_title;
            $args->entryurl = $obj->s_url;
            $args->list_order = $parentid * -1;
            $output = executeQuery("tccommentnotify.insertCommentNotified", $args);
            if(!$output->toBool())
            {
                return -1;
            }
            return $parentid;
        }

        function procDoNotify()
        {
            $oController = &getController('module');
            $output = $oController->lock('commentnotify', 400);
            if(!$output->toBool()) return;
            $deadline = $output->get('deadline');

            if( file_exists($this->cachedir.$this->cachefile) )
            {
                FileHandler::removeFile($this->cachedir.$this->cachefile);
            }

            $oModel = &getModel('tccommentnotify');
            $output = $oModel->GetCommentsFromNotifyQueue();
            if(!$output->toBool())
            {
                debugPrint("Error");
                debugPrint($output);
            }
            if($output->data)
            {
                foreach($output->data as $data)
                {
                    $this->deleteFromQueue($data->comment_srl);
                    $this->sendCommentNotify($data->comment_srl);
                }
            }
            $oController->unlock('commentnotify', $deadline);
        }

        function deleteFromQueue($comment_srl)
        {
            $args->comment_srl = $comment_srl;
            executeQuery("tccommentnotify.deleteFromQueue", $args);
        }

        function triggerInsertComment($obj)
        {
            $oCommentModel = &getModel('comment');
            $oComment = $oCommentModel->getComment($obj->comment_srl);
            $output = $this->insertCommentNotifyQueue($obj->comment_srl);
            if($output->toBool())
            {
                if(!file_exists($this->cachedir.$this->cachefile))
                {
                    if(!file_exists($this->cachedir))
                    {
                        FileHandler::makeDir($this->cachedir);
                    }
                    $fp = fopen($this->cachedir.$this->cachefile, "w");
                    fwrite($fp, "aa");
                    fclose($fp);
                }
            }
            return new Object(); 
        }

        function insertCommentNotifyQueue($comment_srl)
        {
            $args->comment_srl = $comment_srl;
            return executeQuery("tccommentnotify.insertQueue", $args);
        }

        function sendCommentNotify($comment_srl)
        {
            set_include_path("./libs/PEAR");
            require_once('PEAR.php');
            require_once('HTTP/Request.php');

            $oCommentModel = &getModel('comment');
            $oChild = $oCommentModel->getComment($comment_srl);

            if(!$oChild->isExists())
            {
                return;
            }

            $document_srl = $oChild->get('document_srl');
            
            $oDocumentModel = &getModel('document');
            $oDocument = $oDocumentModel->getDocument($document_srl);

            $oParent = null;
            $parent_srl = $oChild->get('parent_srl');
            if(!$parent_srl)
            {
                $oParent = $oDocument;
            }
            else
            {
                $oParent = $oCommentModel->getComment($parent_srl);
            }

            if(!$oParent->isExists())
            {
                return;
            }

            $parentHomepage = $oParent->getHomepageUrl();
            $oMemberModel = &getModel('member');
            if(!$parentHomepage)
            {
                $parent_member = $oParent->getMemberSrl();
                if(!$parent_member)
                    return; 
                $member_info = $oMemberModel->getMemberInfoByMemberSrl($parent_member);
                $parentHomepage = $member_info->homepage;
                if(!$parentHomepage)
                    return;
            }

            $childHomepage = $oChild->getHomepageUrl();
            if(!$childHomepage)
            {
                $child_member = $oChild->getMemberSrl();
                if($child_member)
                {
                    $child_info = $oMemberModel->getMemberInfoByMemberSrl($child_member);
                    $childHomepage = $member_info->homepage;
                }
            }

            $oModuleModel = &getModel('module');
            $module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
            $res = $this->SendNotifyRequest($parentHomepage, $module_info, $oDocument, $oParent, $parentHomepage, $oChild, $childHomepage);
        }

        function SendNotifyRequest($target, &$module_info, &$oDocument, &$oParent, $parentHomepage, &$oChild, $childHomepage)
        {
            $post_data = array();
            $oModuleModel = &getModel('module');
            $site_info = $oModuleModel->getSiteInfo($module_info->site_srl);
            $post_data['mode'] = 'fb';
            $post_data['url'] = getFullSiteUrl($site_info->domain,'','mid', $module_info->mid);
            $post_data['s_home_title'] = $module_info->browser_title;
            $post_data['s_post_title'] = $oDocument->getTitleText();
            $post_data['s_name'] = $oDocument->getNickName();
            $post_data['s_url'] = getFullSiteUrl($site_info->domain,'','document_srl',$oDocument->document_srl);
            $post_data['s_no'] = $oDocument->document_srl;
            $post_data['r1_name'] = $oParent->getNickName();
            if($oChild->get('parent_srl'))
            {
                $post_data['r1_no'] = $oParent->comment_srl;
                $post_data['r1_url'] = sprintf("%s#comment_%s", getFullSiteUrl($site_info->domain,'','document_srl',$oDocument->document_srl), $oParent->comment_srl);
                $post_data['r2_rno'] = $oParent->comment_srl;
            }
            else
            {
                $post_data['r1_no'] = -1; 
                $post_data['r1_url'] = getFullSiteUrl($site_info->domain,'','document_srl',$oDocument->document_srl);
                $post_data['r2_rno'] = -1; 
            }
            
            $post_data['r1_pno'] = $oDocument->document_srl;
            $post_data['r1_rno'] = '0';
            $post_data['r1_homepage'] = $parentHomepage;
            $post_data['r1_regdate'] = ztime($oParent->get('regdate'));
            $post_data['r2_name'] = $oChild->getNickName();
            $post_data['r2_no'] = $oChild->comment_srl;
            $post_data['r2_pno'] = $oDocument->document_srl;
            $post_data['r2_homepage'] = $childHomepage;
            $post_data['r2_regdate'] = ztime($oChild->get('regdate'));
            $post_data['r2_url'] = sprintf("%s#comment_%s", getFullSiteUrl($site_info->domain,'','document_srl',$oDocument->document_srl), $oChild->comment_srl);
        
            if($oChild->get('parent_srl'))
            {
                $post_data['r1_body'] = strip_tags($oParent->get('content'));
            }
            else
            {
                $post_data['r1_body'] = $oParent->getContentText(250);
            }

            $post_data['r2_body'] = strip_tags($oChild->get('content'));
            if(!FileHandler::getRemoteResource($target, null, 3, 'POST', "application/x-www-form-urlencoded; charset=utf-8", array(), array(), $post_data))
            {
                $indexedPage = rtrim($target, '/').'/index.php';
                if(!FileHandler::getRemoteResource($indexedPage, null, 3, 'POST', "application/x-www-form-urlencoded; charset=utf-8", array(), array(), $post_data))
                {
                    return false;
                }
            }
            return true;
        }

        function insertCommentNotify(&$obj, $siteid, $parentid, $module_srl)
        {
            $myid = getNextSequence();
            $args->notified_srl = $myid;
            $args->module_srl = $module_srl; 
            $args->parent_srl = $parentid;
            $args->name = $obj->r2_name;
            $args->homepage = $obj->r2_homepage;
            $args->written = date('YmdHis', $obj->r2_regdate);
            $args->comment = $obj->r2_body;
            $args->url = $obj->r2_url;
            $args->remoteid = $obj->r2_no;
            $args->list_order = $myid * -1;
            $output = executeQuery("tccommentnotify.insertCommentNotifiedChild", $args);
            $bRet = $output->toBool();
            return $bRet;
        }

        function updateParent($parentid)
        {
            $args->notified_srl = $parentid;
            $args->list_order = -1 * getNextSequence();
            $output = executeQuery("tccommentnotify.updateParent", $args);
        }

        function procNotifyReceived($module_srl) {

            $obj = Context::getRequestVars();
            $oModel = &getModel('tccommentnotify');

            $oDB = &DB::getInstance();
            $oDB -> begin();
            $siteid = $oModel->GetSite( $obj->url );
            if(!$obj->r1_no)
            {
                $obj->r1_no = 0;
            }

            if( $siteid == -2 )
            {
                $oDB->rollback();
                return;
            }
            else if( $siteid == -1 )
            { 
                $siteid = $this->insertSite($obj->s_home_title, $obj->s_name, $obj->url);
                if($siteid == -1)
                {
                    $oDB->rollback();
                    return;
                }
            }

            $parentid = $oModel->GetParentID( $obj->s_no, $siteid, $module_srl, $obj->r1_no );
            $commentid = -1;
            if( $parentid == -2 )
            {
                $oDB->rollback();
                return;
            }
            else if ( $parentid == -1 )
            {
                $parentid = $this->insertParent( $obj, $siteid, $module_srl );
                if($parentid == -1)
                {
                    $oDB->rollback();
                    return;
                }
            }
            else
            {
               $commentid = $oModel->GetCommentID( $parentid, $obj->r2_no );
               if($commentid != -1)
               {
                    $oDB->rollback();
                    return;
               }
               $this->updateParent($parentid); 
            }

            if(!$this->insertCommentNotify($obj, $siteid, $parentid, $module_srl))
            {
                $oDB->rollback();
                return;
            }

            $oDB->commit();
        }
    }
?>
